import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="md-select settings-shared input-device-settings-shared">#menuContainer{display:table;width:200px}#remappingContainer{display:flex;gap:8px;width:calc(100% - 15px);overflow:scroll}iron-dropdown{background-color:var(--cros-bg-color-elevation-3);border-radius:2px;box-shadow:var(--cr-elevation-3);max-height:50vh;overflow:auto}.label-container{display:flex;gap:8px;line-height:16px}.label-container>iron-icon{--iron-icon-height:16px;--iron-icon-width:16px}.md-select{background-position-x:calc(100% - 15px);padding:10px 16px;width:168px}</style>
<div tabindex="0" id="selectDropdown" role="button"
    class="md-select label-container"
    on-click="showDropdownMenu_">
  <div id="remappingContainer">
    <template is="dom-if" if="[[remappedToKeyCombination_]]">
      <template is="dom-repeat" items="[[inputKeys_]]">
        <template is="dom-if" if="[[getIconIdForKey_(item)]]">
          <div aria-label="[[getAriaLabelForIcon(item)]]" role="img">
            <iron-icon icon="[[getIconIdForKey_(item)]]"
                aria-hidden="true">
            </iron-icon>
          </div>
        </template>
        <template is="dom-if" if="[[!getIconIdForKey_(item)]]">
          <span>[[item]]</span>
        </template>
      </template>
    </template>
    <template is="dom-if" if="[[!remappedToKeyCombination_]]">
      [[label_]]
    </template>
  </div>
</div>
<iron-dropdown opened="[[shouldShowDropdownMenu_]]"
    no-cancel-on-outside-click
    focus-target="[[focusTarget_]]"
    dynamic-align>
  <div id="menuContainer" slot="dropdown-content">
    <template is="dom-repeat" items="[[menu]]">
      <customize-button-dropdown-item option="[[item]]"
          selected="[[isItemSelected_(item, selectedItem)]]">
      </customize-button-dropdown-item>
    </template>
  </div>
</iron-dropdown>
<!--_html_template_end_-->`;
}
