import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="settings-shared input-device-settings-shared">.subsection{padding-inline-start:20px}#inputContainer{height:70px}#renamingDialog{--cr-dialog-width:320px}:host([button-name-invalid_]) #inputSuffix{color:var(--cros-text-color-alert)}#inputSuffix{display:flex;font-size:var(--cr-form-field-label-font-size);height:var(--cr-form-field-label-height);justify-content:flex-end;line-height:var(--cr-form-field-label-line-height);margin:8px 0;position:absolute;top:130px;white-space:var(--cr-input-error-white-space);width:256px}:host-context([chrome-refresh-2023]) #inputSuffix{top:140px}
</style>
<div class="subsection" id="subsection">
  <template is="dom-repeat"
      items="{{buttonRemappingList}}"
      index-as="index">
    <customize-button-row id$="row-[[index]]"
        button-remapping-list="[[buttonRemappingList]]"
        remapping-index="[[index]]"
        action-list$="[[actionList]]"
        meta-key="[[metaKey]]">
    </customize-button-row>
  </template>
</div>

<cr-dialog id="renamingDialog" on-close="cancelRenamingDialogClicked_">
  <div slot="title">$i18n{buttonRenamingDialogTitle}</div>
  <div slot="body">
    <div id="inputContainer">
      <cr-input id="renamingDialogInput"
        autofocus
        label="$i18n{buttonRemappingDialogInputLabel}"
        on-keydown="onKeyDownInRenamingDialog_"
        invalid="[[buttonNameInvalid_]]"
        value="{{selectedButtonName_}}"
        aria-description=
            "[[i18n('buttonRemappingRenamingDialogInputDescription',
                maxInputLength)]]">
      </cr-input>
      <div id="inputSuffix">
        <span id="duplicateNameError" hidden="[[!duplicateButtonName_]]">
          $i18n{buttonRenamingDialogErrorMessage}
        </span>
        <span id="inputCount" aria-hidden="true">
          [[getInputCountString_(selectedButtonName_)]]
        </span>
      </div>
    </div>
  </div>
  <div slot="button-container">
    <div>
      <cr-button id="cancelButton"
          on-click="cancelRenamingDialogClicked_">
        $i18n{buttonRemappingDialogCancelLabel}
      </cr-button>
    </div>
    <div>
      <cr-button id="saveButton" class="action-button"
          on-click="saveRenamingDialogClicked_"
          disabled="[[isSaveButtonDisabled_]]">
        $i18n{buttonRemappingDialogSaveLabel}
      </cr-button>
    </div>
  </div>
</cr-dialog>
<key-combination-input-dialog
    id="keyCombinationInputDialog"
    button-remapping-list="{{buttonRemappingList}}"
    remapping-index="[[selectedButtonIndex_]]"
    meta-key="[[metaKey]]"
    on-close="onKeyCombinationDialogClose_">
</key-combination-input-dialog>
<!--_html_template_end_-->`;
}
