import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="settings-shared">cr-link-row:not(:last-of-type){border-bottom:var(--cr-separator-line)}.restore-defaults-button{border-radius:16px;height:32px;margin-inline:16px}.restore-defaults-icon{--iron-icon-fill-color:currentColor;margin-inline-end:8px}</style>

<os-settings-animated-pages id="pages" section="[[section_]]">
  <div id="main" route-path="default">
    <settings-card header-text="$i18n{devicePageTitle}">
      <template is="dom-if"
          if="[[showPerDeviceMouseRow_(mice)]]">
        <cr-link-row id="perDeviceMouseRow"
            start-icon="os-settings:device-mouse" label="$i18n{mouseTitle}"
            on-click="onPerDeviceMouseClick_" aria-label="$i18n{mouseTitle}"
            role-description="$i18n{subpageArrowRoleDescription}">
        </cr-link-row>
      </template>
      <template is="dom-if"
          if="[[showPerDeviceTouchpadRow_(touchpads)]]">
        <cr-link-row id="perDeviceTouchpadRow"
            start-icon="os-settings:device-touchpad"
            aria-label="$i18n{touchpadTitle}"
            label="$i18n{touchpadTitle}" on-click="onPerDeviceTouchpadClick_"
            role-description="$i18n{subpageArrowRoleDescription}">
        </cr-link-row>
      </template>
      <template is="dom-if"
          if="[[showPerDevicePointingStickRow_(pointingSticks)]]">
        <cr-link-row id="perDevicePointingStickRow"
            start-icon="os-settings:device-pointing-stick"
            aria-label="$i18n{pointingStickTitle}"
            label="$i18n{pointingStickTitle}"
            on-click="onPerDevicePointingStickClick_"
            role-description="$i18n{subpageArrowRoleDescription}">
        </cr-link-row>
      </template>
      <cr-link-row id="perDeviceKeyboardRow"
          start-icon="os-settings:device-keyboard"
          label="$i18n{keyboardTitle}"
          aria-label="$i18n{keyboardTitle}"
          sub-label="[[inputMethodDisplayName_]]"
          on-click="onPerDeviceKeyboardClick_"
          role-description="$i18n{subpageArrowRoleDescription}">
      </cr-link-row>
      <template is="dom-if" if="[[hasStylus_]]">
        <cr-link-row id="stylusRow"
            start-icon="os-settings:device-stylus"
            label="$i18n{stylusTitle}"
            on-click="onStylusClick_"
            role-description="$i18n{subpageArrowRoleDescription}">
        </cr-link-row>
      </template>
      <template is="dom-if" if="[[showGraphicsTabletRow_(graphicsTablets,
          isPeripheralCustomizationEnabled)]]">
        <cr-link-row id="tabletRow"
            start-icon="os-settings:device-tablet" label="$i18n{tabletTitle}"
            on-click="onGraphicsTabletClick"
            role-description="$i18n{subpageArrowRoleDescription}">
        </cr-link-row>
      </template>
      <cr-link-row id="displayRow" start-icon="os-settings:device-display"
          label="$i18n{displayTitle}" on-click="onDisplayClick_"
          role-description="$i18n{subpageArrowRoleDescription}">
      </cr-link-row>
      <cr-link-row id="audioRow" start-icon="os-settings:device-audio"
          label="$i18n{audioTitle}" on-click="onAudioClick_"
          role-description="$i18n{subpageArrowRoleDescription}">
      </cr-link-row>
    </settings-card>

    <printing-settings-card></printing-settings-card>
  </div>

  <template is="dom-if" route-path="/pointer-overlay">
    <os-settings-subpage
        page-title="[[getPointersTitle_(hasMouse_, hasPointingStick_,
                                        hasTouchpad_)]]">
      <settings-pointers prefs="{{prefs}}"
          has-mouse="[[hasMouse_]]"
          has-pointing-stick="[[hasPointingStick_]]"
          has-touchpad="[[hasTouchpad_]]"
          has-haptic-touchpad="[[hasHapticTouchpad_]]">
      </settings-pointers>
    </os-settings-subpage>
  </template>
  <template is="dom-if" route-path="/per-device-mouse">
    <os-settings-subpage page-title="$i18n{mouseTitle}">
      <settings-per-device-mouse
          mice="[[mice]]"
          mouse-policies="[[mousePolicies]]">
      </settings-per-device-mouse>
    </os-settings-subpage>
  </template>
  <template is="dom-if" route-path="/per-device-keyboard">
    <os-settings-subpage page-title="$i18n{keyboardTitle}">
      <settings-per-device-keyboard
          prefs="{{prefs}}"
          keyboards="[[keyboards]]"
          keyboard-policies="[[keyboardPolicies]]">
      </settings-per-device-keyboard>
    </os-settings-subpage>
  </template>
  <template is="dom-if" route-path="/per-device-touchpad">
    <os-settings-subpage page-title="$i18n{touchpadTitle}">
      <settings-per-device-touchpad
          touchpads="[[touchpads]]"
          prefs="{{prefs}}"
          >
      </settings-per-device-touchpad>
    </os-settings-subpage>
  </template>
  <template is="dom-if" route-path="/per-device-pointing-stick">
    <os-settings-subpage page-title="$i18n{pointingStickTitle}">
      <settings-per-device-pointing-stick
          pointing-sticks="[[pointingSticks]]">
      </settings-per-device-pointing-stick>
    </os-settings-subpage>
  </template>
  <template is="dom-if" route-path="/keyboard-overlay">
    <os-settings-subpage page-title="$i18n{keyboardTitle}">
      <settings-keyboard prefs="{{prefs}}">
      </settings-keyboard>
    </os-settings-subpage>
  </template>
  <template is="dom-if" route-path="/stylus">
    <os-settings-subpage page-title="$i18n{stylusTitle}">
      <settings-stylus prefs="{{prefs}}"></settings-stylus>
    </os-settings-subpage>
  </template>
  <template is="dom-if" route-path="/graphics-tablet">
    <os-settings-subpage page-title="$i18n{tabletTitle}">
      <settings-graphics-tablet-subpage
          graphics-tablets="[[graphicsTablets]]">
      </settings-graphics-tablet-subpage>
    </os-settings-subpage>
  </template>
  <template is="dom-if"
      route-path="/graphics-tablet/customizeTabletButtons">
    <os-settings-subpage id="customizeTabletButtonsSubpage"
        page-title="$i18n{customizeTabletButtonsLabel}">
      <settings-customize-tablet-buttons-subpage
          graphics-tablets="[[graphicsTablets]]">
      </settings-customize-tablet-buttons-subpage>
    </os-settings-subpage>
  </template>
  <template is="dom-if"
      route-path="/graphics-tablet/customizePenButtons">
    <os-settings-subpage id="customizePenButtonsSubpage"
        page-title="$i18n{customizePenButtonsLabel}">
      <settings-customize-pen-buttons-subpage
          graphics-tablets="[[graphicsTablets]]">
      </settings-customize-pen-buttons-subpage>
    </os-settings-subpage>
  </template>
  <template is="dom-if" route-path="/display">
    <os-settings-subpage page-title="$i18n{displayTitle}">
      <settings-display prefs="{{prefs}}"></settings-display>
    </os-settings-subpage>
  </template>
  <template is="dom-if" route-path="/audio">
    <os-settings-subpage page-title="$i18n{audioTitle}">
      <settings-audio prefs="{{prefs}}">
      </settings-audio>
    </os-settings-subpage>
  </template>
  <template is="dom-if"
      route-path="/per-device-keyboard/remap-keys">
    <os-settings-subpage id="perDeviceKeyboardRemapKeysRow"
        page-title="$i18n{remapKeyboardKeysRowLabel}">
        <cr-button id="restoreDefaultsButton" slot="subpage-title-extra"
            on-click="restoreDefaults"
            class="restore-defaults-button">
        <iron-icon icon="os-settings:refresh" class="restore-defaults-icon">
        </iron-icon>
        <span>$i18n{keyboardRemapRestoreDefaultsLabel}</span>
    </cr-button>
      <settings-per-device-keyboard-remap-keys keyboards="[[keyboards]]"
          keyboard-policies="[[keyboardPolicies]]"
          id="remap-keys">
      </settings-per-device-keyboard-remap-keys>
    </os-settings-subpage>
  </template>
  <template is="dom-if"
      route-path="/per-device-mouse/customizeButtons">
    <os-settings-subpage id="customizeMouseButtonsRow"
        page-title="$i18n{customizeMouseButtonsTitle}">
      <settings-customize-mouse-buttons-subpage
          mouse-list="[[mice]]"
          mouse-policies="[[mousePolicies]]">
      </settings-customize-mouse-buttons-subpage>
    </os-settings-subpage>
  </template>

  <!-- Input subpages -->
  <template is="dom-if" route-path="/osLanguages/input">
    <os-settings-subpage page-title="$i18n{inputPageTitle}">
      <os-settings-input-page prefs="{{prefs}}"
          languages="[[languages]]"
          language-helper="[[languageHelper]]">
      </os-settings-input-page>
    </os-settings-subpage>
  </template>

  <template is="dom-if" route-path="/osLanguages/inputMethodOptions">
    <os-settings-subpage>
      <settings-input-method-options-page prefs="{{prefs}}"
          language-helper="[[languageHelper]]">
      </settings-input-method-options-page>
    </os-settings-subpage>
  </template>

  <template is="dom-if" route-path="/osLanguages/editDictionary">
    <os-settings-subpage page-title="$i18n{editDictionaryLabel}">
      <os-settings-edit-dictionary-page></os-settings-edit-dictionary-page>
    </os-settings-subpage>
  </template>

  <template is="dom-if"
      route-path="/osLanguages/japaneseManageUserDictionary">
    <os-settings-subpage
        page-title="$i18n{japaneseManageUserDictionaryLabel}">
      <os-settings-japanese-manage-user-dictionary-page>
      </os-settings-japanese-manage-user-dictionary-page>
    </os-settings-subpage>
  </template>

  <!-- Printing cups printers subpage -->
  <template is="dom-if" route-path="/cupsPrinters">
    <os-settings-subpage
        page-title="$i18n{cupsPrintTitle}"
        search-label="$i18n{searchLabel}"
        search-term="{{searchTerm}}">
      <settings-cups-printers search-term="{{searchTerm}}"
          prefs="{{prefs}}">
      </settings-cups-printers>
    </os-settings-subpage>
  </template>
</os-settings-animated-pages>
<!--_html_template_end_-->`;
}
