import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="settings-shared">#displayArea{height:100%;overflow:hidden;position:relative;width:100%}.display{align-items:center;background:var(--cros-textfield-background-color);color:var(--cros-text-color-secondary);cursor:default;display:flex;font-size:100%;font-weight:500;justify-content:center;margin:4px;padding:3px;position:absolute;text-align:center}.display[selected]{border:var(--cros-icon-color-prominent) solid 1px}.display.mirror{border:var(--cros-icon-color-prominent) solid 1px}.highlight-left{border-left:var(--cros-icon-color-prominent) solid 1px}.highlight-right{border-right:var(--cros-icon-color-prominent) solid 1px}.highlight-top{border-top:var(--cros-icon-color-prominent) solid 1px}.highlight-bottom{border-bottom:var(--cros-icon-color-prominent) solid 1px}.display.elevate{box-shadow:var(--cr-elevation-3)}</style>
<div id="displayArea" on-iron-resize="calculateVisualScale_">
  <template is="dom-repeat" items="[[mirroringDestinationIds_]]">
    <div id="_mirror_[[item]]" class="display mirror"
        hidden$="[[!mirroring]]"
        style$="[[getMirrorDivStyle_(index, mirroringDestinationIds_.length,
                                     displays, visualScale)]]">
    </div>
  </template>
  <template is="dom-repeat" items="[[displays]]">
    <div id="_[[item.id]]" class="display elevate"
        draggable="[[dragEnabled]]" on-focus="onFocus_"
        on-click="onSelectDisplayClick_"
        style$="[[getDivStyle_(item.id, item.bounds, visualScale)]]"
        selected$="[[isSelected_(item, selectedDisplay)]]"
        tabindex="0">
    </div>
  </template>
</div>
<!--_html_template_end_-->`;
}
