import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="cr-shared-style settings-shared iron-flex
  iron-flex-alignment">.indented{align-self:stretch;margin-inline-start:var(--cr-section-indent-padding);padding:0}#nightLightTemperatureDiv[disabled]{opacity:0.38;pointer-events:none}.text-area{margin:10px 0}#nightLightSlider{flex-grow:1;margin-top:20px}#nightLightDropDownDiv{width:200px;text-align:right;margin-top:8px}iron-collapse{width:100%}</style>

<settings-toggle-button
    id="nightLightToggleButton"
    class="settings-box first"
    label="$i18n{displayNightLightLabel}"
    pref="{{prefs.ash.night_light.enabled}}"
    sub-label="$i18n{displayNightLightText}"
    deep-link-focus-id$="[[Setting.kNightLight]]">
</settings-toggle-button>

<div id="nightLightSettingsDiv"
    class="settings-box continuation start layout vertical">
  <!-- Color temperature slider -->
  <div id="nightLightTemperatureDiv"
      class="settings-box indented continuation"
      hidden$="[[!prefs.ash.night_light.enabled.value]]">
    <div class="start text-area" id="colorTemperatureLabel">
      $i18n{displayNightLightTemperatureLabel}
    </div>
    <settings-slider id="colorTemperatureSlider"
        aria-labelledby="colorTemperatureLabel" min="0" max="100"
        scale="100" label-min="$i18n{displayNightLightTempSliderMinLabel}"
        label-max="$i18n{displayNightLightTempSliderMaxLabel}"
        pref="{{prefs.ash.night_light.color_temperature}}"
        deep-link-focus-id$="[[Setting.kNightLightColorTemperature]]">
    </settings-slider>
  </div>
  <!-- Schedule settings -->
  <div class="settings-box indented">
    <div id="NightLightLabelDiv" class="start text-area" aria-hidden="true">
      <div id="nightLightScheduleLabel" class="label">
        $i18n{displayNightLightScheduleLabel}
      </div>
      <div id="nightLightScheduleSubLabel" class="secondary label"
          hidden$="[[!nightLightScheduleSubLabel_]]">
        [[nightLightScheduleSubLabel_]]
      </div>
    </div>
    <div id="nightLightDropDownDiv"
        class="cr-row-gap">
      <settings-dropdown-menu
          id="nightLightScheduleTypeDropDown"
          label="$i18n{displayNightLightScheduleLabel}"
          aria-describedby="nightLightScheduleSubLabel"
          pref="{{prefs.ash.night_light.schedule_type}}"
          menu-options="[[scheduleTypesList_]]">
      </settings-dropdown-menu>
      <template is="dom-if" if="[[shouldShowGeolocationWarningText_]]"
          restamp>
        <settings-privacy-hub-geolocation-warning-text
            id="warningText"
            warning-text-with-anchor=
                "[[geolocationWarningText_]]"
            on-link-clicked="openGeolocationDialog_">
        </settings-privacy-hub-geolocation-warning-text>
      </template>
    </div>
  </div>
  <!-- Custom schedule slider -->
  <iron-collapse id="nightLightCustomScheduleCollapse"
      opened="[[shouldOpenCustomScheduleCollapse_]]">
    <div class="settings-box indented continuation">
      <div class="start text-area layout vertical">
        <div class="settings-box continuation self-stretch">
          <settings-scheduler-slider id="nightLightSlider" prefs="{{prefs}}"
              pref-start-time="{{prefs.ash.night_light.custom_start_time}}"
              pref-end-time="{{prefs.ash.night_light.custom_end_time}}">
          </settings-scheduler-slider>
        </div>
      </div>
    </div>
  </iron-collapse>
</div>

<!-- System geolocation dialog, letting users enable location permission -->
<template is="dom-if" if="[[shouldShowGeolocationDialog_]]" restamp>
  <settings-privacy-hub-geolocation-dialog id="geolocationDialog"
      on-close="onGeolocationDialogClose_"
      prefs="{{prefs}}">
  </settings-privacy-hub-geolocation-dialog>
</template>
<!--_html_template_end_-->`;
}
