import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="settings-shared input-device-settings-shared">#header{display:flex;height:24px;padding:12px 0}.subsection{margin-bottom:0;margin-top:8px}#description{color:var(--cr-secondary-text-color);margin-inline-start:20px}</style>
<template is="dom-repeat" items="[[graphicsTablets]]"
    as="graphicsTablet" index-as="index" restamp>
    <div class="device" data-evdev-id$="[[graphicsTablet.id]]">
      <per-device-subsection-header
          device-key="[[graphicsTablet.deviceKey]]"
          name="[[graphicsTablet.name]]"
          battery-info="[[graphicsTablet.batteryInfo]]"
          icon="os-settings:device-tablet">
      </per-device-subsection-header>
      <div class="subsection">
        <template is="dom-if"
            if="[[showInstallAppRow(graphicsTablet.appInfo)]]">
          <per-device-install-row app-info="[[graphicsTablet.appInfo]]">
          </per-device-install-row>
        </template>
        <template is="dom-if"
            if="[[showCustomizeTabletButtonsRow(graphicsTablet)]]">
          <cr-link-row id="customizeTabletButtons"
              class="bottom-divider" on-click="onCustomizeTabletButtonsClick"
              aria-describedby="graphicsTabletName"
              label="$i18n{customizeTabletButtonsLabel}">
          </cr-link-row>
        </template>
        <cr-link-row id="customizePenButtons"
            class="hr bottom-divider" on-click="onCustomizePenButtonsClick"
            aria-describedby="graphicsTabletName"
            label="$i18n{customizePenButtonsLabel}">
        </cr-link-row>
      </div>
    </div>
    <template is="dom-if"
        if="[[isCompanionAppInstalled(graphicsTablet.appInfo)]]">
      <per-device-app-installed-row app-info="[[graphicsTablet.appInfo]]">
      </per-device-app-installed-row>
    </template>
</template>
<!--_html_template_end_-->`;
}
