import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="settings-shared input-device-settings-shared">:host{--cr-dialog-width:416px}#shortcut-input-container{display:flex;flex-direction:row;justify-content:center;margin:0;padding:20px 0px}#shortcut-input-container:focus{outline:none}#dialogDescription{margin:0;text-align:center;padding-bottom:24px}.right-button-group{display:flex;gap:8px}</style>
<cr-dialog id="keyCombinationInputDialog">
  <div slot="title">$i18n{keyCombinationDialogTitle}</div>
  <div slot="body">
    <div id="dialogDescription">
      $i18n{buttonRemappingDialogDescription}
    </div>
    <div id="shortcut-input-container" class="flex-row" tabindex="-1">
      <shortcut-input id="shortcutInput" aria-describedby="dialogDescription"
          shortcut-input-provider="[[getShortcutProvider()]]"
          show-separator="true"
          meta-key="[[metaKey]]"
          ignore-blur>
      </shortcut-input>
    </div>
  </div>
  <div slot="button-container">
    <div class="left-button-group">
      <template is="dom-if" if="[[shouldShowEditButton_(isCapturing)]]">
        <cr-button class="edit-button"
            id="editButton"
            on-click="onEditButtonClicked_">
          $i18n{buttonRemappingDialogChangeLabel}
        </cr-button>
      </template>
    </div>
    <div class="right-button-group">
      <cr-button id="cancelButton"
          on-click="cancelDialogClicked_">
        $i18n{buttonRemappingDialogCancelLabel}
      </cr-button>
      <cr-button id="saveButton" class="action-button"
          on-click="saveDialogClicked_"
          disabled$="[[shouldDisableSaveButton_(inputKeyEvent)]]">
        $i18n{buttonRemappingDialogSaveLabel}
      </cr-button>
    </div>
  </div>
</cr-dialog>
<!--_html_template_end_-->`;
}
