// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * 'per-device-app-installed-row' is responsible for displaying companion app
 * information for an installed app.
 */
import './input_device_settings_shared.css.js';
import '../settings_shared.css.js';
import 'chrome://resources/ash/common/cr_elements/cr_auto_img/cr_auto_img.js';
import 'chrome://resources/ash/common/cr_elements/cr_link_row/cr_link_row.js';
import 'chrome://resources/ash/common/cr_elements/cr_shared_vars.css.js';
import { I18nMixin } from 'chrome://resources/ash/common/cr_elements/i18n_mixin.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
import { getInputDeviceSettingsProvider } from './input_device_mojo_interface_provider.js';
import { getTemplate } from './per_device_app_installed_row.html.js';
const PerDeviceAppInstalledRowElementBase = I18nMixin(PolymerElement);
export class PerDeviceAppInstalledRowElement extends PerDeviceAppInstalledRowElementBase {
    constructor() {
        super(...arguments);
        this.inputDeviceSettingsProvider = getInputDeviceSettingsProvider();
    }
    static get is() {
        return 'per-device-app-installed-row';
    }
    static get template() {
        return getTemplate();
    }
    static get properties() {
        return {
            appInfo: {
                type: Object,
            },
            openAppLabel: {
                type: String,
                computed: 'computeOpenAppLabel(appInfo.*)',
            },
        };
    }
    computeOpenAppLabel() {
        return this.i18n('openAppLabel', this.appInfo.appName);
    }
    onCompanionAppRowClick() {
        this.inputDeviceSettingsProvider.launchCompanionApp(this.appInfo.packageId);
    }
}
customElements.define(PerDeviceAppInstalledRowElement.is, PerDeviceAppInstalledRowElement);
