import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="settings-shared input-device-settings-shared">#header{display:flex;height:24px;margin-top:12px}.subsection{margin-bottom:0}#description{color:var(--cr-secondary-text-color);font:var(--cros-button-2-font);margin-inline-start:20px}.subsection-header{color:var(--cr-secondary-text-color);font:var(--cros-body-2-font);height:24px;margin:12px 0;padding-inline-start:0}#modifierKeysHeader{margin-bottom:0}</style>
<div id="header">
  <div id="description">[[computeKeyboardKeysDescription(keyboard.*)]]</div>
</div>
<div class="subsection">
  <template is="dom-if" if="[[!isAltClickAndSixPackCustomizationEnabled]]">
    <keyboard-remap-modifier-key-row
        has-function-key="[[hasFunctionKey]]"
        default-remappings="[[defaultRemappings]]"
        key="[[modifierKey.kMeta]]" id="metaKey"
        meta-key="[[keyboard.metaKey]]"
        aria-label="[[getActionRowLabel('perDeviceKeyboardKeySearch')]]"
        pref="{{fakeMetaPref}}"
        remove-top-border>
    </keyboard-remap-modifier-key-row>
    <keyboard-remap-modifier-key-row
        has-function-key="[[hasFunctionKey]]"
        default-remappings="[[defaultRemappings]]"
        key="[[modifierKey.kControl]]" id="ctrlKey"
        meta-key="[[keyboard.metaKey]]"
        aria-label="[[getActionRowLabel('perDeviceKeyboardKeyCtrl')]]"
        pref="{{fakeCtrlPref}}">
    </keyboard-remap-modifier-key-row>
    <keyboard-remap-modifier-key-row
        has-function-key="[[hasFunctionKey]]"
        default-remappings="[[defaultRemappings]]"
        key="[[modifierKey.kAlt]]" id="altKey"
        meta-key="[[keyboard.metaKey]]"
        aria-label="[[getActionRowLabel('perDeviceKeyboardKeyAlt')]]"
        pref="{{fakeAltPref}}">
    </keyboard-remap-modifier-key-row>
    <keyboard-remap-modifier-key-row
        has-function-key="[[hasFunctionKey]]"
        default-remappings="[[defaultRemappings]]"
        key="[[modifierKey.kEscape]]" id="escapeKey"
        meta-key="[[keyboard.metaKey]]"
        aria-label="[[getActionRowLabel('perDeviceKeyboardKeyEscape')]]"
        pref="{{fakeEscPref}}">
    </keyboard-remap-modifier-key-row>
    <keyboard-remap-modifier-key-row
        has-function-key="[[hasFunctionKey]]"
        default-remappings="[[defaultRemappings]]"
        key="[[modifierKey.kBackspace]]" id="backspaceKey"
        meta-key="[[keyboard.metaKey]]"
        aria-label="[[getActionRowLabel('perDeviceKeyboardKeyBackspace')]]"
        pref="{{fakeBackspacePref}}">
    </keyboard-remap-modifier-key-row>
    <template is="dom-if" if="[[hasAssistantKey]]" restamp>
      <keyboard-remap-modifier-key-row
          has-function-key="[[hasFunctionKey]]"
          default-remappings="[[defaultRemappings]]"
          key="[[modifierKey.kAssistant]]" id="assistantKey"
          meta-key="[[keyboard.metaKey]]"
          aria-label="[[getActionRowLabel('perDeviceKeyboardKeyAssistant')]]"
          pref="{{fakeAssistantPref}}">
      </keyboard-remap-modifier-key-row>
    </template>
    <template is="dom-if" if="[[hasCapsLockKey]]" restamp>
      <keyboard-remap-modifier-key-row
          has-function-key="[[hasFunctionKey]]"
          default-remappings="[[defaultRemappings]]"
          key="[[modifierKey.kCapsLock]]" id="capsLockKey"
          meta-key="[[keyboard.metaKey]]"
          aria-label="[[getActionRowLabel('perDeviceKeyboardKeyCapsLock')]]"
          pref="{{fakeCapsLockPref}}">
      </keyboard-remap-modifier-key-row>
    </template>
  </template>
  <template is="dom-if" if="[[isAltClickAndSixPackCustomizationEnabled]]">
    <h2 class="subsection-header" id="modifierKeysHeader">
      $i18n{modifierKeysLabel}
    </h2>
    <div class="subsection">
      <keyboard-remap-modifier-key-row
          has-function-key="[[hasFunctionKey]]"
          default-remappings="[[defaultRemappings]]"
          key="[[modifierKey.kMeta]]" id="metaKey"
          meta-key="[[keyboard.metaKey]]"
          aria-label="[[getActionRowLabel('perDeviceKeyboardKeySearch')]]"
          pref="{{fakeMetaPref}}"
          remove-top-border>
      </keyboard-remap-modifier-key-row>
      <keyboard-remap-modifier-key-row
          has-function-key="[[hasFunctionKey]]"
          default-remappings="[[defaultRemappings]]"
          key="[[modifierKey.kControl]]" id="ctrlKey"
          meta-key="[[keyboard.metaKey]]"
          aria-label="[[getActionRowLabel('perDeviceKeyboardKeyCtrl')]]"
          pref="{{fakeCtrlPref}}">
      </keyboard-remap-modifier-key-row>
      <keyboard-remap-modifier-key-row
          has-function-key="[[hasFunctionKey]]"
          default-remappings="[[defaultRemappings]]"
          key="[[modifierKey.kAlt]]" id="altKey"
          meta-key="[[keyboard.metaKey]]"
          aria-label="[[getActionRowLabel('perDeviceKeyboardKeyAlt')]]"
          pref="{{fakeAltPref}}">
      </keyboard-remap-modifier-key-row>
      <keyboard-remap-modifier-key-row
          has-function-key="[[hasFunctionKey]]"
          default-remappings="[[defaultRemappings]]"
          key="[[modifierKey.kEscape]]" id="escapeKey"
          meta-key="[[keyboard.metaKey]]"
          aria-label="[[getActionRowLabel('perDeviceKeyboardKeyEscape')]]"
          pref="{{fakeEscPref}}">
      </keyboard-remap-modifier-key-row>
      <keyboard-remap-modifier-key-row
          has-function-key="[[hasFunctionKey]]"
          default-remappings="[[defaultRemappings]]"
          key="[[modifierKey.kBackspace]]" id="backspaceKey"
          meta-key="[[keyboard.metaKey]]"
          aria-label="[[getActionRowLabel('perDeviceKeyboardKeyBackspace')]]"
          pref="{{fakeBackspacePref}}">
      </keyboard-remap-modifier-key-row>
      <template is="dom-if" if="[[hasAssistantKey]]" restamp>
        <keyboard-remap-modifier-key-row
            has-function-key="[[hasFunctionKey]]"
            default-remappings="[[defaultRemappings]]"
            key="[[modifierKey.kAssistant]]" id="assistantKey"
            meta-key="[[keyboard.metaKey]]"
            aria-label="[[getActionRowLabel('perDeviceKeyboardKeyAssistant')]]"
            pref="{{fakeAssistantPref}}">
        </keyboard-remap-modifier-key-row>
      </template>
      <template is="dom-if" if="[[hasQuickInsertKey]]" restamp>
        <keyboard-remap-modifier-key-row
            has-function-key="[[hasFunctionKey]]"
            default-remappings="[[defaultRemappings]]"
            key="[[modifierKey.kQuickInsert]]" id="quickInsertKey"
            meta-key="[[keyboard.metaKey]]"
            aria-label=
                "[[getActionRowLabel('perDeviceKeyboardKeyQuickInsert')]]"
            pref="{{fakeQuickInsertPref}}">
        </keyboard-remap-modifier-key-row>
      </template>
      <template is="dom-if" if="[[hasFunctionKey]]" restamp>
        <keyboard-remap-modifier-key-row
            has-function-key="[[hasFunctionKey]]"
            default-remappings="[[defaultRemappings]]"
            key="[[modifierKey.kFunction]]" id="functionKey"
            meta-key="[[keyboard.metaKey]]"
            aria-label="[[getActionRowLabel('perDeviceKeyboardKeyFunction')]]"
            pref="{{fakeFunctionPref}}">
        </keyboard-remap-modifier-key-row>
      </template>
      <template is="dom-if" if="[[hasCapsLockKey]]" restamp>
        <keyboard-remap-modifier-key-row
            has-function-key="[[hasFunctionKey]]"
            default-remappings="[[defaultRemappings]]"
            key="[[modifierKey.kCapsLock]]" id="capsLockKey"
            meta-key="[[keyboard.metaKey]]"
            aria-label="[[getActionRowLabel('perDeviceKeyboardKeyCapsLock')]]"
            pref="{{fakeCapsLockPref}}">
        </keyboard-remap-modifier-key-row>
      </template>
    </div>
    <template is="dom-if" if="[[!hasFunctionKey]]">
      <h2 class="subsection-header" id="otherKeysHeader">
        $i18n{otherKeysLabel}
      </h2>
    </template>
    <div class="subsection">
      <template is="dom-if" if="[[!hasFunctionKey]]">
        <keyboard-six-pack-key-row id="del"
            modifier="[[keyboard.sixPackKeyRemappings.del]]"
            key="del"
            pref="{{deletePref}}"
            aria-label="[[getShortcutRowLabel('sixPackKeyLabelDelete')]]">
        </keyboard-six-pack-key-row>
        <keyboard-six-pack-key-row id="pageDown"
            modifier="[[keyboard.sixPackKeyRemappings.pageDown]]"
            key="pageDown"
            pref="{{pageDownPref}}"
            aria-label="[[getShortcutRowLabel('sixPackKeyLabelPageDown')]]">
        </keyboard-six-pack-key-row>
        <keyboard-six-pack-key-row id="pageUp"
            modifier="[[keyboard.sixPackKeyRemappings.pageUp]]"
            key="pageUp"
            pref="{{pageUpPref}}"
            aria-label="[[getShortcutRowLabel('sixPackKeyLabelPageUp')]]">
        </keyboard-six-pack-key-row>
        <keyboard-six-pack-key-row id="end"
            modifier="[[keyboard.sixPackKeyRemappings.end]]"
            key="end"
            pref="{{endPref}}"
            aria-label="[[getShortcutRowLabel('sixPackKeyLabelEnd')]]">
        </keyboard-six-pack-key-row>
        <keyboard-six-pack-key-row id="home"
            modifier="[[keyboard.sixPackKeyRemappings.home]]"
            key="home"
            pref="{{homePref}}"
            aria-label="[[getShortcutRowLabel('sixPackKeyLabelHome')]]">
        </keyboard-six-pack-key-row>
        <keyboard-six-pack-key-row id="insert"
            modifier="[[keyboard.sixPackKeyRemappings.insert]]"
            key="insert"
            pref="{{insertPref}}"
            aria-label="[[getShortcutRowLabel('sixPackKeyLabelInsert')]]">
        </keyboard-six-pack-key-row>
      </template>
      <template is="dom-if"
          if="[[shouldShowFkeys(keyboard.*, hasFunctionKey)]]">
        <fkey-row key="f11"
            aria-label="[[getShortcutRowLabel('f11KeyLabel')]]" id="f11"
            pref="{{f11KeyPref}}" keyboard="[[keyboard]]">
        </fkey-row>
        <fkey-row key="f12"
            aria-label="[[getShortcutRowLabel('f12KeyLabel')]]" id="f12"
            pref="{{f12KeyPref}}" keyboard="[[keyboard]]">
        </fkey-row>
      </template>
    </div>
  </template>
</div><!--_html_template_end_-->`;
}
