import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="settings-shared input-device-settings-shared">.settings-box:first-of-type{border-top:none}.settings-box,#mouseAcceleration,#mouseControlledScrolling{margin-left:var(--cr-section-indent-width)}#mouseReverseScrollRow{border-top:none}.subsection-subtitle{padding-top:15px}</style>
<div id="mouse">
  <per-device-subsection-header
    id="subsectionHeader"
    device-key="[[mouse.deviceKey]]"
    name="[[mouse.name]]"
    battery-info="[[mouse.batteryInfo]]"
    icon="os-settings:device-mouse">
  </per-device-subsection-header>
  <template is="dom-if" if="[[showSwapToggleButton(
      customizationRestriction, isPeripheralCustomizationEnabled_)]]">
    <settings-toggle-button id="mouseSwapToggleButton"
        label="$i18n{mouseSwapButtonsLabel}" pref="{{primaryRightPref}}">
    </settings-toggle-button>
  </template>
  <template is="dom-if" if="[[showInstallAppRow(mouse.appInfo)]]">
    <per-device-install-row app-info="[[mouse.appInfo]]">
    </per-device-install-row>
  </template>
  <div class="subsection">
    <h2 class="subsection-subtitle">$i18n{mouseCursor}</h2>
    <template is="dom-if" if="[[!isPeripheralCustomizationEnabled_]]">
      <div class="settings-box">
        <div class="start settings-box-text" id="mouseSwapButtonLabel">
          $i18n{mouseSwapButtonsLabel}
        </div>
        <settings-dropdown-menu id="mouseSwapButtonDropdown"
            aria-describedby="mouseName"
            label="$i18n{mouseSwapButtonsLabel}"
            pref="{{primaryRightPref}}"
            menu-options="[[swapPrimaryOptions_]]"
            deep-link-focus-id$="[[Setting.kMouseSwapPrimaryButtons]]">
        </settings-dropdown-menu>
      </div>
    </template>
    <settings-toggle-button id="mouseAcceleration"
        class="hr"
        pref="{{accelerationPref}}"
        label="[[getCursorAccelerationString()]]"
        sub-label="$i18n{mouseAccelerationDescription}"
        aria-describedby="mouseName"
        deep-link-focus-id$="[[Setting.kMouseAcceleration]]">
    </settings-toggle-button>
    <div class="settings-box">
      <div class="start" id="mouseSpeedLabel" aria-hidden="true">
        [[getCursorSpeedString()]]
      </div>
      <settings-slider id="mouseSpeedSlider"
          pref="{{sensitivityPref}}"
          ticks="[[sensitivityValues_]]"
          aria-describedby="mouseName"
          label-aria="[[getCursorSpeedString()]]"
          label-min="$i18n{pointerSlow}"
          label-max="$i18n{pointerFast}"
          deep-link-focus-id$="[[Setting.kMouseSpeed]]">
      </settings-slider>
    </div>
    <h2 class="hr">$i18n{mouseScrolling}</h2>
    <div class="settings-box bottom-divider" id="mouseReverseScrollRow"
          on-click="onMouseReverseScrollRowClicked_" actionable-row>
      <div class="start settings-box-text">
        <localized-link
            aria-describedby="mouseName"
            on-click="onLearnMoreLinkClicked_"
            id="enableMouseReverseScrollingLabel"
            localized-string="$i18n{mouseReverseScrollLabel}"
            link-url="$i18n{naturalScrollLearnMoreLink}">
        </localized-link>
        <div class="secondary">
          $i18n{mouseReverseScrollDescription}
        </div>
      </div>
      <cr-toggle id="mouseReverseScroll"
          checked="{{reverseScrollValue}}"
          aria-describedby="mouseName"
          aria-label=
              "[[getLabelWithoutLearnMore('mouseReverseScrollLabel')]]"
          deep-link-focus-id$="[[Setting.kMouseReverseScrolling]]">
      </cr-toggle>
    </div>
    <div class="settings-box bottom-divider" id="mouseControlledScrollingRow"
         on-click="onMouseControlledScrollingRowClicked_" actionable-row>
      <div class="start settings-box-text">
        <localized-link
          aria-describedby="mouseName"
          on-click="onLearnMoreLinkClicked_"
          id="enableMouseControlledScrollingLabel"
          localized-string="$i18n{mouseControlledScrollingLabel}"
          link-url="$i18n{controlledScrollingLearnMoreLink}">
        </localized-link>
      </div>
      <cr-toggle id="mouseControlledScrolling"
                 checked="{{!scrollAccelerationValue}}"
                 aria-describedby="mouseName"
                 aria-label=
                 "[[getLabelWithoutLearnMore('mouseControlledScrollingLabel')]]"
                 deep-link-focus-id$="[[Setting.kMouseScrollAcceleration]]">
      </cr-toggle>
    </div>
    <div class="settings-box">
      <div class="start" id="mouseScrollSpeedLabel" aria-hidden="true">
        $i18n{mouseScrollSpeed}
      </div>
      <settings-slider id="mouseScrollSpeedSlider"
                       pref="{{scrollSensitivityPref}}"
                       ticks="[[sensitivityValues_]]"
                       aria-describedby="mouseName"
                       label-aria="$i18n{mouseScrollSpeed}"
                       label-min="$i18n{pointerSlow}"
                       label-max="$i18n{pointerFast}"
                       disabled="[[mouse.settings.scrollAcceleration]]"
                       aria-disabled="[[mouse.settings.scrollAcceleration]]">
      </settings-slider>
    </div>
    <template is="dom-if" if="[[showCustomizeButtonRow(
        customizationRestriction,isPeripheralCustomizationEnabled_)]]">
      <cr-link-row id="customizeMouseButtons"
        class="hr bottom-divider" on-click="onCustomizeButtonsClick"
        aria-describedby="mouseName"
        label="$i18n{customizeMouseButtonsTitle}">
      </cr-link-row>
    </template>
    <template is="dom-if" if="[[isCompanionAppInstalled(mouse.appInfo)]]">
      <per-device-app-installed-row id="AppInstalledRow"
          app-info="[[mouse.appInfo]]">
      </per-device-app-installed-row>
    </template>
  </div>
</div>
<!--_html_template_end_-->`;
}
