import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="settings-shared input-device-settings-shared">.settings-box:first-of-type{border-top:none}</style>
<div id="pointingStick">
  <per-device-subsection-header
      id="subsectionHeader"
      device-key="[[pointingStick.deviceKey]]"
      name="[[getPointingStickName(pointingStick.name)]]"
      icon="os-settings:device-pointing-stick">
  </per-device-subsection-header>
  <div class="subsection">
    <div class="settings-box">
      <div class="start settings-box-text"
          id="pointingStickSwapButtonLabel">
        $i18n{pointingStickPrimaryButton}
      </div>
      <settings-dropdown-menu id="pointingStickSwapButtonDropdown"
          aria-describedby="pointingStickName"
          label="$i18n{pointingStickPrimaryButton}"
          pref="{{primaryRightPref}}"
          menu-options="[[swapPrimaryOptions]]"
          deep-link-focus-id$=
              "[[Setting.kPointingStickSwapPrimaryButtons]]">
      </settings-dropdown-menu>
      </div>
      <settings-toggle-button id="pointingStickAcceleration"
          aria-describedby="pointingStickName"
          class="hr"
          pref="{{accelerationPref}}"
          label="$i18n{pointingStickAccelerationLabel}"
          deep-link-focus-id$="[[Setting.kPointingStickAcceleration]]">
      </settings-toggle-button>
      <div class="settings-box bottom-divider">
      <div class="start" id="pointingStickSpeedLabel" aria-hidden="true">
        $i18n{pointingStickSpeed}
      </div>
      <settings-slider id="pointingStickSpeedSlider"
          pref="{{sensitivityPref}}"
          ticks="[[sensitivityValues]]"
          aria-describedby="pointingStickName"
          label-aria="$i18n{pointingStickSpeed}"
          label-min="$i18n{pointerSlow}"
          label-max="$i18n{pointerFast}"
          deep-link-focus-id$="[[Setting.kPointingStickSpeed]]">
      </settings-slider>
    </div>
  </div>
</div><!--_html_template_end_-->`;
}
