import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="settings-shared input-device-settings-shared">cr-link-row{padding-inline-end:var(--cr-section-padding);padding-inline-start:var(--cr-section-padding)}</style>
<div id="touchpad">
  <template is="dom-if" if="[[isBuiltInTrackpadDisabled_(
        prefs.settings.a11y.disable_trackpad_mode.value, mice
      )]]" restamp>
    <div id="disabledTouchpadHeader">
      <h2 aria-hidden="true" class="subsection-header bottom-divider"
          id="deviceName">
        [[getTouchpadName(touchpad.name)]]
      </h2>
      <cr-link-row id="cursorTouchpadSubpageButton" class="hr"
          label="$i18n{builtInTouchpadDisabled}"
          on-click="onDisabledTouchpadSettingsClick_"
          role-description="$i18n{subpageArrowRoleDescription}" embedded>
      </cr-link-row>
    </div>
  </template>
  <template is="dom-if" if="[[!isBuiltInTrackpadDisabled_(
        prefs.settings.a11y.disable_trackpad_mode.value, mice
      )]]" restamp>
    <div id="touchpadSettings">
      <per-device-subsection-header
          device-key="[[touchpad.deviceKey]]"
          name="[[getTouchpadName(touchpad.name)]]"
          battery-info="[[touchpad.batteryInfo]]"
          icon="os-settings:device-touchpad">
      </per-device-subsection-header>
      <div class="subsection">
        <template is="dom-if" if="[[showInstallAppRow(touchpad.appInfo)]]">
          <per-device-install-row app-info="[[touchpad.appInfo]]">
          </per-device-install-row>
        </template>
        <settings-toggle-button id="enableTapToClick"
            pref="{{enableTapToClickPref}}"
            label="$i18n{touchpadTapToClickEnabledLabel}"
            sub-label="$i18n{touchpadTapToClickDescription}"
            aria-describedby="touchpadName"
            deep-link-focus-id$="[[Setting.kTouchpadTapToClick]]">
        </settings-toggle-button>
        <template is="dom-if"
            if="[[isAltClickAndSixPackCustomizationEnabled]]">
          <div id="simulateRightClickContainer" class="settings-box">
            <div id="simulateRightClickLabel" aria-hidden="true"
                class="start settings-box-text">
            $i18n{touchpadSimulateRightClickLabel}
            </div>
            <settings-dropdown-menu id="simulateRightClickDropdown"
                label="$i18n{touchpadSimulateRightClickLabel}"
                pref="{{simulateRightClickPref}}"
                aria-describedby="touchpadName"
                menu-options="[[simulateRightClickOptions_]]"
                deep-link-focus-id$="[[Setting.kTouchpadSimulateRightClick]]">
            </settings-dropdown-menu>
          </div>
        </template>
        <settings-toggle-button id="enableTapDragging"
            class="hr"
            pref="{{enableTapDraggingPref}}"
            label="$i18n{tapDraggingLabel}"
            sub-label="$i18n{tapDraggingDescription}"
            aria-describedby="touchpadName"
            deep-link-focus-id$="[[Setting.kTouchpadTapDragging]]">
        </settings-toggle-button>
        <settings-toggle-button id="touchpadAcceleration"
            class="hr"
            pref="{{accelerationPref}}"
            label="$i18n{touchpadAccelerationLabel}"
            sub-label="$i18n{touchpadAccelerationDescription}"
            aria-describedby="touchpadName"
            deep-link-focus-id$="[[Setting.kTouchpadAcceleration]]">
        </settings-toggle-button>
        <div class="settings-box">
          <div class="start" id="touchpadSpeedLabel" aria-hidden="true">
          $i18n{touchpadSpeed}
          </div>
          <settings-slider id="touchpadSensitivity"
              pref="{{sensitivityPref}}"
              ticks="[[sensitivityValues_]]"
              aria-describedby="touchpadName"
              label-aria="$i18n{touchpadSpeed}"
              label-min="$i18n{pointerSlow}"
              label-max="$i18n{pointerFast}"
              deep-link-focus-id$="[[Setting.kTouchpadSpeed]]">
          </settings-slider>
        </div>
        <template is="dom-if" if="[[touchpad.isHaptic]]" restamp>
          <div class="settings-box">
            <div class="start" id="touchpadHapticClickSensitivityLabel"
                aria-hidden="true">
            $i18n{touchpadHapticClickSensitivityLabel}
            </div>
            <settings-slider id="touchpadHapticClickSensitivity"
                pref="{{hapticClickSensitivityPref}}"
                ticks="[[hapticClickSensitivityValues_]]"
                aria-describedby="touchpadName"
                label-aria="$i18n{touchpadHapticClickSensitivityLabel}"
                label-min="$i18n{touchpadHapticLightClickLabel}"
                label-max="$i18n{touchpadHapticFirmClickLabel}"
                deep-link-focus-id$=
                "[[Setting.kTouchpadHapticClickSensitivity]]">
            </settings-slider>
          </div>
          <div class="settings-box two-line" id="touchpadHapticFeedbackRow"
              on-click="onTouchpadHapticFeedbackRowClicked_" actionable-row>
            <div class="start settings-box-text">
              <div>$i18n{touchpadHapticFeedbackTitle}</div>
              <div class="secondary">
                <localized-link
                    aria-describedby="touchpadName"
                    on-click="onLearnMoreLinkClicked_"
                    id="touchpadHapticFeedbackSecondary"
                    localized-string=
                        "$i18n{touchpadHapticFeedbackSecondaryText}"
                    link-url="$i18n{hapticFeedbackLearnMoreLink}">
                </localized-link>
              </div>
            </div>
            <cr-toggle id="touchpadHapticFeedbackToggle"
                checked="{{hapticFeedbackValue}}"
                aria-describedby="touchpadName"
                aria-label=
                    "[[getLabelWithoutLearnMore(
                      'touchpadHapticFeedbackTitle'
                    )]]"
                deep-link-focus-id$="[[Setting.kTouchpadHapticFeedback]]">
            </cr-toggle>
          </div>
        </template>
        <div class="settings-box bottom-divider" id="reverseScrollRow"
            on-click="onTouchpadReverseScrollRowClicked_" actionable-row>
          <div class="start settings-box-text">
            <localized-link
                aria-describedby="touchpadName"
                on-click="onLearnMoreLinkClicked_"
                id="enableReverseScrollingLabel"
                localized-string="$i18n{touchpadScrollLabel}"
                link-url="$i18n{naturalScrollLearnMoreLink}">
            </localized-link>
            <div class="secondary">
              $i18n{touchpadScrollDescription}
            </div>
          </div>
          <cr-toggle id="enableReverseScrollingToggle"
              checked="{{reverseScrollValue}}"
              aria-describedby="touchpadName"
              aria-label=
                  "[[getLabelWithoutLearnMore('touchpadScrollLabel')]]"
              deep-link-focus-id$="[[Setting.kTouchpadReverseScrolling]]">
          </cr-toggle>
          <template is="dom-if" if="[[isCompanionAppInstalled(
                touchpad.appInfo
              )]]">
            <per-device-app-installed-row app-info="[[touchpad.appInfo]]">
            </per-device-app-installed-row>
          </template>
        </div>
      </div>
    </div>
  </template>
</div>
<!--_html_template_end_-->`;
}
