import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="iron-flex cr-shared-style settings-shared md-select">.indented{margin-inline-start:var(--cr-section-indent-padding);padding-inline-start:0}cr-policy-indicator{padding-inline-end:8px}.dropdown-row{--cr-section-min-height:64px}#optimizedChargingManagedIndicator{margin:0 16px}</style>
<div id="powerSourceRow" class="cr-row first"
    hidden$="[[!batteryStatus_.present]]">
  <div class="flex cr-padded-text" aria-hidden="true">
    <div id="powerSourceLabel">[[powerSourceLabel_]]</div>
    <div id="batteryStatus" class="secondary">[[batteryStatus_.statusText]]</div>
  </div>
  <select id="powerSource" class="md-select"
      hidden$="[[!showPowerSourceDropdown_]]"
      aria-labelledby="powerSourceLabel"
      aria-describedby="batteryStatus"
      on-change="onPowerSourceChange_"
      deep-link-focus-id$="[[Setting.kPowerSource]]">
    <option value="" selected="[[isEqual_('', selectedPowerSourceId_)]]">
      $i18n{powerSourceBattery}
    </option>
    <template is="dom-repeat" items="[[powerSources_]]">
      <option value="[[item.id]]"
          selected="[[isEqual_(item.id, selectedPowerSourceId_)]]">
        [[item.description]]
      </option>
    </template>
  </select>
  <div hidden$="[[showPowerSourceDropdown_]]"
      aria-labelledby="powerSourceLabel"
      aria-describedby="batteryStatus">
    [[powerSourceName_]]
  </div>
</div>

<!-- optimizedCharging -->
<template is="dom-if" if="[[!optimizedChargingHidden_]]" restamp>
  <div id="optimizedChargingSettingsRow"
      class$="[[getClassForRow_(batteryStatus_.present, 'optimizedCharging')]]">
    <div class="flex layout horizontal center">
      <div class="flex settings-box-text">
        <div id="optimizedChargingLabel">
          $i18n{powerOptimizedChargingLabel}
        </div>
        <div id="optimizedChargingSublabel" class="cr-secondary-text sub-label"
            hidden$="[[adaptiveChargingManaged_]]">
          <span class="sub-label-text">[[optimizedChargingSublabel_]]</span>
        </div>
      </div>
    </div>
    <template is="dom-if" if="[[adaptiveChargingManaged_]]">
      <cr-policy-pref-indicator id="optimizedChargingManagedIndicator"
          pref="[[adaptiveChargingPref_]]"
          icon-aria-label="$i18n{powerOptimizedChargingLabel}">
      </cr-policy-pref-indicator>
    </template>
    <cr-button id="optimizedChargingChangeButton"
        aria-label="$i18n{powerOptimizedChargingChangeAriaLabel}"
        on-click="makeOptimizedChargingDialogVisible_"
        disabled="[[adaptiveChargingManaged_]]"
        deep-link-focus-id$="[[Setting.kAdaptiveCharging]]
            [[Setting.kChargeLimit]]">
      $i18n{powerOptimizedChargingChangeLabel}
    </cr-button>
    <div class="separator"></div>
    <settings-toggle-v2 id="optimizedChargingToggle"
        aria-labelledby="optimizedChargingSublabel"
        checked="[[optimizedChargingEnabled_]]"
        on-change="onOptimizedChargingToggleChange_"
        disabled="[[adaptiveChargingManaged_]]"
        deep-link-focus-id$="[[Setting.kOptimizedCharging]]">
    </settings-toggle-v2>
  </div>
</template>


<!-- batterySaver -->
<settings-toggle-button id="batterySaverToggle"
    class$="[[getClassForRow_(batteryStatus_.present, 'batterySaver')]]"
    hidden$="[[batterySaverHidden_]]"
    pref="{{prefs.power.cros_battery_saver_active}}"
    label="$i18n{powerBatterySaverLabel}"
    sub-label="$i18n{powerBatterySaverSubtext}"
    learn-more-url="$i18n{powerBatterySaverLearnMoreUrl}"
    disabled="[[isExternalPowerAC_]]"
    deep-link-focus-id$="[[Setting.kBatterySaver]]">
</settings-toggle-button>

<!-- adaptiveCharging -->
<template is="dom-if" if="[[!batteryChargeLimitAvailable_]]" restamp>
  <settings-toggle-button id="adaptiveChargingToggle"
      class$="[[getClassForRow_(batteryStatus_.present, 'adaptiveCharging')]]"
      hidden$="[[!adaptiveChargingSupported_]]"
      pref="[[adaptiveChargingPref_]]"
      label="$i18n{powerAdaptiveChargingLabel}"
      sub-label="$i18n{powerAdaptiveChargingSubtext}"
      learn-more-url="$i18n{powerAdaptiveChargingLearnMoreUrl}"
      on-settings-boolean-control-change="onAdaptiveChargingToggleChange_"
      deep-link-focus-id$="[[Setting.kAdaptiveCharging]]"
      no-set-pref>
  </settings-toggle-button>
</template>

<!-- idle -->
<template is="dom-if" if="[[!batteryStatus_.present]]" restamp>
  <div class$="[[getClassForRow_(batteryStatus_.present, 'idle')]]">
    <div id="powerIdleLabel" class="flex" aria-label="true">
      $i18n{powerIdleLabel}
    </div>

    <template is="dom-if" if="[[acIdleManaged_]]" restamp>
      <cr-policy-indicator id="noBatteryAcIdleManagedIndicator"
          indicator-type="devicePolicy"
          icon-aria-label="$i18n{powerIdleWhileChargingAriaLabel}">
      </cr-policy-indicator>
    </template>
    <select id="noBatteryAcIdleSelect"
        class="md-select"
        on-change="onAcIdleSelectChange_"
        disabled="[[shouldAcIdleSelectBeDisabled_]]"
        aria-label="$i18n{powerIdleWhileChargingAriaLabel}"
        deep-link-focus-id$="[[Setting.kPowerIdleBehaviorWhileCharging]]">
      <template is="dom-repeat" items="[[acIdleOptions_]]">
        <option value="[[item.value]]" selected="[[item.selected]]">
          [[item.name]]
        </option>
      </template>
    </select>
  </div>
</template>

<!-- acIdle -->
<template is="dom-if" if="[[batteryStatus_.present]]" restamp>
  <div id="acIdleSettingBox"
      class$="[[getClassForRow_(batteryStatus_.present, 'acIdle')]]">
    <div class="flex" aria-hidden="true">
      $i18n{powerInactiveWhilePluggedInLabel}
    </div>
    <template is="dom-if" if="[[acIdleManaged_]]" restamp>
      <cr-policy-indicator id="acIdleManagedIndicator"
          indicator-type="devicePolicy"
          icon-aria-label="$i18n{powerIdleWhileChargingAriaLabel}">
      </cr-policy-indicator>
    </template>
    <select id="acIdleSelect" class="md-select"
        on-change="onAcIdleSelectChange_"
        disabled="[[shouldAcIdleSelectBeDisabled_]]"
        aria-label="$i18n{powerIdleWhileChargingAriaLabel}"
        deep-link-focus-id$="[[Setting.kPowerIdleBehaviorWhileCharging]]">
      <template is="dom-repeat" items="[[acIdleOptions_]]">
        <option value="[[item.value]]" selected="[[item.selected]]">
          [[item.name]]
        </option>
      </template>
    </select>
  </div>

  <div id="batteryIdleSettingBox"
      class$="[[getClassForRow_(batteryStatus_.present, 'batteryIdle')]]">
    <div class="flex" aria-hidden="true">
      $i18n{powerInactiveWhileOnBatteryLabel}
    </div>
    <template is="dom-if" if="[[batteryIdleManaged_]]" restamp>
      <cr-policy-indicator id="batteryIdleManagedIndicator"
          indicator-type="devicePolicy"
          icon-aria-label="$i18n{powerIdleWhileOnBatteryAriaLabel}">
      </cr-policy-indicator>
    </template>
    <select id="batteryIdleSelect" class="md-select"
        on-change="onBatteryIdleSelectChange_"
        disabled="[[shouldBatteryIdleSelectBeDisabled_]]"
        aria-label="$i18n{powerIdleWhileOnBatteryAriaLabel}"
        deep-link-focus-id$="[[Setting.kPowerIdleBehaviorWhileOnBattery]]">
      <template is="dom-repeat" items="[[batteryIdleOptions_]]">
        <option value="[[item.value]]" selected="[[item.selected]]">
          [[item.name]]
        </option>
      </template>
    </select>
  </div>
</template>

<settings-toggle-button id="lidClosedToggle"
  class$="[[getClassForRow_(batteryStatus_.present, 'lidClosed')]]"
  hidden$="[[!hasLid_]]" pref="[[lidClosedPref_]]" label="[[lidClosedLabel_]]"
  on-settings-boolean-control-change="onLidClosedToggleChange_" no-set-pref
  deep-link-focus-id$="[[Setting.kSleepWhenLaptopLidClosed]]">
</settings-toggle-button>

<template is="dom-if" if="[[optimizedChargingDialogVisible_]]" restamp>
  <power-optimized-charging-dialog
      id="optimizedChargingDialog"
      prefs="{{prefs}}"
      on-close="onOptimizedChargingDialogClose_">
  </power-optimized-charging-dialog>
</template>
<!--_html_template_end_-->`;
}
