import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="settings-shared">progress{-webkit-appearance:none;display:block;height:28px;width:100%}progress::-webkit-progress-bar{background-color:var(--cros-tab-slider-track-color);border-radius:2px}progress::-webkit-progress-value{background-color:var(--cros-icon-color-prominent);border-radius:2px}progress.space-low::-webkit-progress-value{background-color:var(--cros-icon-color-warning)}progress.space-critically-low::-webkit-progress-value{background-color:var(--cros-icon-color-alert)}iron-icon{--iron-icon-fill-color:var(--cros-icon-color-warning);--iron-icon-height:32px;--iron-icon-width:32px}#criticallyLowMessage iron-icon{--iron-icon-fill-color:var(--cros-icon-color-alert)}.storage-size{color:var(--cr-secondary-text-color)}.message-area{background-color:var(--cros-textfield-background-color);border-radius:2px;display:flex;margin:14px 0 16px;padding-bottom:12px;padding-inline-end:48px;padding-inline-start:16px;padding-top:16px;width:100%}.message-area>iron-icon{flex:none;padding-inline-end:16px}.message-title{color:var(--cros-text-color-primary);font-size:115%}.message-description{color:var(--cros-text-color-secondary);font-size:92%;line-height:1.6em;margin:1em 0}#barArea{display:flex;flex-direction:column;margin:24px 0 54px;width:100%}#barLabels{display:flex}.bar-label{display:flex;flex-direction:column}.bar-label .vertical-line{align-self:center;background-color:var(--cros-separator-color);height:8px;margin-bottom:4px;width:1px}.bar-label .wrapper{color:var(--cros-text-color-primary);text-align:center;white-space:nowrap}.end-aligned .wrapper{direction:rtl}:host-context([dir=rtl]) .end-aligned .wrapper{direction:ltr}.end-aligned .wrapper span{direction:initial;unicode-bidi:embed}</style>
<template is="dom-if" if="[[isSpaceLow_(sizeStat_.spaceState)]]">
  <div class="settings-box first">
    <div id="lowMessage" class="message-area">
      <iron-icon icon="cr:warning"></iron-icon>
      <div class="message">
        <div class="message-title">$i18n{storageSpaceLowMessageTitle}</div>
        <div class="message-description">
          <span>$i18n{storageSpaceLowMessageLine1}</span>
          <span>&nbsp;$i18n{storageSpaceLowMessageLine2}</span>
        </div>
      </div>
    </div>
  </div>
</template>
<template is="dom-if" if="[[isSpaceCriticallyLow_(sizeStat_.spaceState)]]">
  <div class="settings-box first">
    <div id="criticallyLowMessage" class="message-area">
      <iron-icon icon="cr:warning"></iron-icon>
      <div class="message">
        <div class="message-title">
          $i18n{storageSpaceCriticallyLowMessageTitle}
        </div>
        <div class="message-description">
          <span>$i18n{storageSpaceCriticallyLowMessageLine1}</span>
          <span>&nbsp;$i18n{storageSpaceCriticallyLowMessageLine2}</span>
        </div>
      </div>
    </div>
  </div>
</template>
<div class="settings-box first">
  <div id="barArea">
    <progress id="bar" class$="[[getBarClass_(sizeStat_.spaceState)]]"
        value="[[roundTo2DecimalPoints_(sizeStat_.usedRatio)]]"
        aria-label="$i18n{storageOverviewAriaLabel}"
        aria-valuetext$="[[sizeStat_.usedSize]]"
        aria-describedby="barLabels">
    </progress>
    <div id="barLabels" aria-hidden="true">
      <div id="inUseLabelArea" class="bar-label">
        <div class="vertical-line"></div>
        <div class="wrapper"><span>$i18n{storageItemInUse}</span></div>
        <div class="wrapper">
          <span class="storage-size">[[sizeStat_.usedSize]]</span>
        </div>
      </div>
      <div id="availableLabelArea" class="bar-label end-aligned">
        <div class="vertical-line"></div>
        <div class="wrapper"><span>$i18n{storageItemAvailable}</span></div>
        <div class="wrapper">
          <span class="storage-size">[[sizeStat_.availableSize]]</span>
        </div>
      </div>
    </div>
  </div>
</div>

<template is="dom-if" if="[[localUserFilesAllowed_(prefs.filebrowser.local_user_files_allowed.value)]]">
  <cr-link-row id="myFilesSizeLink" class="hr" on-click="onMyFilesClick_"
      label="$i18n{storageItemMyFiles}"
      sub-label="[[myFilesSizeSubLabel_]]"
      external>
  </cr-link-row>
</template>
<template is="dom-if" if="[[!localUserFilesAllowed_(prefs.filebrowser.local_user_files_allowed.value)]]">
  <div id="myFilesSizeDiv"
      class="settings-box two-line single-column"
      aria-describedby="myFilesSizeLabel"
      aria-labelledby="myFilesSizeLabel">
    <div id="myFilesSizeLabel" class="label" aria-hidden="true">
      $i18n{storageItemMyFiles}
    </div>
    <div id="myFilesSizeSubLabel" class="secondary label" aria-hidden="true">
      [[myFilesSizeSubLabel_]]
    </div>
  </div>
</template>

<cr-link-row id="browsingDataSize" class="hr" on-click="onBrowsingDataClick_"
    label="$i18n{storageItemBrowsingData}"
    sub-label="$i18n{storageSizeComputing}"
    external>
</cr-link-row>
<cr-link-row id="appsSize" class="hr" on-click="onAppsClick_"
    label="$i18n{storageItemApps}"
    sub-label="$i18n{storageSizeComputing}"
    external>
</cr-link-row>
<template is="dom-if" if="[[shouldShowOfflineFilesRow_(isDriveEnabled_)]]">
  <cr-link-row id="driveOfflineSize" class="hr"
      on-click="onDriveOfflineClick_"
      label="$i18n{storageItemOffline}"
      sub-label="$i18n{storageSizeComputing}"
      role-description="$i18n{subpageArrowRoleDescription}">
  </cr-link-row>
</template>
<template is="dom-if" if="[[showCrostiniStorage_]]">
  <cr-link-row id="crostiniSize" class="hr" on-click="onCrostiniClick_"
      label="$i18n{storageItemCrostini}"
      sub-label="$i18n{storageSizeComputing}"
      role-description="$i18n{subpageArrowRoleDescription}">
  </cr-link-row>
</template>
<template is="dom-if" if="[[showOtherUsers_]]">
  <cr-link-row id="otherUsersSize" class="hr" on-click="onOtherUsersClick_"
      label="$i18n{storageItemOtherUsers}"
      sub-label="$i18n{storageSizeComputing}"
      role-description="$i18n{subpageArrowRoleDescription}">
  </cr-link-row>
</template>
<template is="dom-if" if="[[!isEphemeralUser_]]">
  <div id="systemSize"
      class="settings-box two-line single-column stretch settings-box-text"
      aria-describedby="systemSizeSubLabel"
      aria-labelledby="systemSizeLabel">
    <div id="systemSizeLabel" class="label" aria-hidden="true">
      $i18n{storageItemSystem}
    </div>
    <div id="systemSizeSubLabel" class="secondary label" aria-hidden="true">
      $i18n{storageSizeComputing}
    </div>
  </div>
</template>
<template is="dom-if" if="[[!isEphemeralUser_]]">
  <div id="systemEncryption"
      class="settings-box two-line single-column stretch settings-box-text"
      aria-describedby="systemEncryptionSubLabel"
      aria-labelledby="systemEncryptionLabel">
    <div id="systemEncryptionLabel" class="label" aria-hidden="true">
      $i18n{storageItemEncryption}
    </div>
    <div id="systemEncryptionSubLabel"
        class="secondary label" aria-hidden="true">
      [[storageEncryptionSubLabel_]]
    </div>
  </div>
</template>
<template is="dom-if" if="[[isExternalStorageEnabled_]]">
  <cr-link-row id="externalStoragePreferences" class="hr"
      on-click="onExternalStoragePreferencesClick_"
      label="$i18n{storageExternal}"
      role-description="$i18n{subpageArrowRoleDescription}">
  </cr-link-row>
</template>
<!--_html_template_end_-->`;
}
