import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="settings-shared md-select">.settings-box>.secondary{align-items:center;display:flex;margin-top:0}paper-spinner-lite{height:var(--cr-icon-size);margin-inline-start:12px;width:var(--cr-icon-size)}cr-policy-indicator{padding:0 var(--cr-controlled-by-spacing)}#selectApp{width:400px}</style>

<settings-toggle-button id="enableStylusToolsToggle"
    pref="{{prefs.settings.enable_stylus_tools}}"
    label="$i18n{stylusEnableStylusTools}"
    deep-link-focus-id$="[[Setting.kStylusToolsInShelf]]">
</settings-toggle-button>

<template is="dom-if" if="[[hasInternalStylus_]]">
  <settings-toggle-button
      id ="launchPaletteOnEjectEventToggle"
      class="hr"
      pref="{{prefs.settings.launch_palette_on_eject_event}}"
      label="$i18n{stylusAutoOpenStylusTools}"
      disabled="[[!prefs.settings.enable_stylus_tools.value]]">
  </settings-toggle-button>
</template>

<div class="settings-box">
  <div id="stylusNoteTakingAppLabel" class="start">
    $i18n{stylusNoteTakingApp}
  </div>

  <div id="no-apps" class="secondary"
      hidden$="[[!showNoApps_(appChoices_, waitingForAndroid_)]]">
    $i18n{stylusNoteTakingAppNoneAvailable}
  </div>

  <div id="waiting" class="secondary" hidden$="[[!waitingForAndroid_]]">
    $i18n{stylusNoteTakingAppWaitingForAndroid}
    <paper-spinner-lite active></paper-spinner-lite>
  </div>

  <select id="selectApp" class="md-select"
      on-change="onSelectedAppChanged_"
      aria-labelledby="stylusNoteTakingAppLabel"
      hidden$="[[!showApps_(appChoices_, waitingForAndroid_)]]"
      deep-link-focus-id$="[[Setting.kStylusNoteTakingApp]]">
    <template is="dom-repeat" items="[[appChoices_]]">
      <option value="[[item.value]]" selected="[[item.preferred]]">
        [[item.name]]
      </option>
    </template>
  </select>
</div>

<cr-link-row id="findMoreAppsLink" class="hr" on-click="onFindAppsClick_"
    hidden$="[[!prefs.arc.enabled.value]]"
    label="$i18n{stylusFindMoreAppsPrimary}"
    sub-label="$i18n{stylusFindMoreAppsSecondary}"
    external>
</cr-link-row>
<!--_html_template_end_-->`;
}
