import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="settings-shared md-select">.toggle-container{display:flex;flex-direction:row;flex-wrap:nowrap;justify-content:space-between}#selectDevice{width:100%}</style>
<settings-toggle-button
    id="guestShowUsbNotificationToggle"
    pref="{{prefs.guest_os.usb_notification_enabled}}"
    no-set-pref
    label="$i18n{guestOsSharedUsbDevicesNotificationsLabel}"
    on-settings-boolean-control-change="onGuestUsbNotificationChange_"
    deep-link-focus-id$="[[Setting.kGuestUsbNotification]]">
</settings-toggle-button>
<settings-toggle-button
    id="guestUsbPersistentPassthroughToggle"
    pref="{{prefs.guest_os.usb_persistent_passthrough_enabled}}"
    no-set-pref
    label="$i18n{guestOsSharedUsbPersistentPassthroughLabel}"
    on-settings-boolean-control-change="onGuestUsbPersistentPassthroughChange_"
    deep-link-focus-id$="[[Setting.kGuestUsbPersistentPassthrough]]">
</settings-toggle-button>
<div class="settings-box first">
  <div class="settings-box-text">
    [[getDescriptionText_()]]
    <div class="secondary" id="secondaryText">
      $i18n{guestOsSharedUsbDevicesExtraDescription}
    </div>
  </div>
</div>
<template is="dom-if" if="[[!hasContainers]]" restamp>
  <div class="settings-box secondary continuation"
      hidden="[[sharedUsbDevices_.length]]">
     $i18n{guestOsSharedUsbDevicesListEmptyMessage}
  </div>
  <template is="dom-if" if="[[sharedUsbDevices_.length]]" restamp>
    <div class="list-frame vertical-list">
      <template is="dom-repeat" items="[[sharedUsbDevices_]]">
        <div class="list-item toggle-container">
          <div class="label">[[item.device.label]]</div>
          <cr-toggle class="toggle" checked="[[item.shared]]"
              on-change="onDeviceSharedChange_"
              aria-label$="[[item.device.label]]">
          </cr-toggle>
        </div>
      </template>
    </div>
  </template>
</template>

<template is="dom-if" if="[[hasContainers]]" restamp>
  <div id="addUsb" class="settings-box first">
    <div id="usbTableTitle" class="start"
        aria-hidden="true">
      $i18n{guestOsSharedUsbDevicesTableTitle}
    </div>
    <cr-button id="addUsbBtn" on-click="onAddUsbClick_"
        aria-label="$i18n{guestOsSharedUsbDevicesAddTitle}"
        aria-describedby="addUsb">
      $i18n{add}
    </cr-button>
  </div>
  <template is="dom-if" if="[[sharedUsbDevices_.length]]" restamp>
    <template is="dom-repeat" items="[[allContainers_]]"
        as="containerInfo" index-as="cidx" mutable-data>
      <template is="dom-if"
          if="[[showGuestId_(sharedUsbDevices_, containerInfo.id)]]" restamp>
        <h2 id="usbListContainerId[[cidx]]"
            hidden="[[!showGuestId_(sharedUsbDevices_, containerInfo.id)]]"
            class="settings-box usb-list-guest-id">
            [[guestLabel_(containerInfo.id)]]
        </h2>
        <div class="list-frame vertical-list usb-list-card"
            id="usbListCard[[cidx]]">
          <template is="dom-repeat" items="[[sharedUsbDevices_]]"
              filter="[[byGuestId_(containerInfo.id)]]" mutable-data>
            <div class="list-item">
              <div id="usbLabel[[cidx]]-[[index]]"
                  class="start usb-list-card-label" aria-hidden="true">
                [[item.device.label]]
              </div>
              <cr-icon-button id="removeUsb[[cidx]]-[[index]]"
                  class="icon-clear usb-list-card-remove" title="$i18n{remove}"
                  on-click="onRemoveUsbClick_" data-guid$="[[item.device.guid]]"
                  aria-label="$i18n{remove}"
                  aria-describedby$="usbLabel[[cidx]]-[[index]]">
              </cr-icon-button>
            </div>
          </template>
        </div>
      </template>
    </template>
  </template>
  <template is="dom-if"
      if="[[!hasSharedDevices_(sharedUsbDevices_, allContainers_)]]" restamp>
    <div class="settings-box secondary">
      $i18n{guestOsSharedUsbDevicesNoneAttached}
    </div>
  </template>
</template>
<template is="dom-if" if="[[showAddUsbDialog_]]" restamp>
  <settings-guest-os-shared-usb-devices-add-dialog
      on-close="onAddUsbDialogClose_"
      shared-usb-devices="[[sharedUsbDevices_]]"
      all-containers="[[allContainers_]]"
      default-guest-id="[[defaultGuestId]]">
  </settings-guest-os-shared-usb-devices-add-dialog>
</template>
<template is="dom-if" if="[[reassignDevice_]]" restamp>
  <cr-dialog id="reassignDialog" close-text="$i18n{close}"
      on-cancel="onReassignCancel_" show-on-attach>
    <div slot="title">
      $i18n{guestOsSharedUsbDevicesInUse}
    </div>
    <div slot="body">
      [[getReassignDialogText_(reassignDevice_)]]
    </div>
    <div slot="button-container">
      <cr-button id="cancel" class="cancel-button"
          on-click="onReassignCancel_">
        $i18n{cancel}
      </cr-button>
      <cr-button id="continue" class="action-button"
          on-click="onReassignContinueClick_">
        $i18n{continue}
      </cr-button>
    </div>
  </cr-dialog>
</template>
<template is="dom-if" if="[[showGuestUsbNotificationDialog_]]" restamp>
  <settings-guest-os-confirmation-dialog
      id="guestShowUsbNotificationDialog"
      accept-button-text="$i18n{guestOsSharedUsbDevicesNotificationDialogAccept}"
      on-close="onGuestUsbNotificationDialogClose_">
    <div slot="body">
      [[getNotificationDialogText_()]]
    </div>
  </settings-guest-os-confirmation-dialog>
</template>
<template is="dom-if" if="[[showGuestUsbPersistentPassthroughDialog_]]" restamp>
  <settings-guest-os-confirmation-dialog
      id="guestShowUsbPersistentPassthroughDialog"
      accept-button-text="$i18n{guestOsSharedUsbDevicesNotificationDialogAccept}"
      on-close="onGuestUsbPersistentPassthroughDialogClose_">
    <div slot="body">
      [[getGuestUsbPersistentPassthroughDialogText_()]]
    </div>
  </settings-guest-os-confirmation-dialog>
</template>
<!--_html_template_end_-->`;
}
