// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import '../../controls/v2/settings_toggle_v2.js';
import 'chrome://resources/ash/common/cr_elements/cr_dialog/cr_dialog.js';
import 'chrome://resources/ash/common/cr_elements/cr_checkbox/cr_checkbox.js';
import { assert } from 'chrome://resources/js/assert.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
import { getTemplate } from './settings_toggle_v2_storybook.html.js';
export class SettingsToggleV2Storybook extends PolymerElement {
    static get is() {
        return 'settings-toggle-v2-storybook';
    }
    static get template() {
        return getTemplate();
    }
    static get properties() {
        return {
            checkedValue_: {
                type: Boolean,
                value: true,
            },
            basicToggleDisabled_: {
                type: Boolean,
                value: false,
            },
            prefCheckedValue_: {
                type: Boolean,
                value: true,
            },
            showBasicDialog_: {
                type: Boolean,
                value: false,
            },
            virtualManagedPref_: {
                type: Object,
                value: {
                    key: 'virtual_managed_pref',
                    type: chrome.settingsPrivate.PrefType.BOOLEAN,
                    value: true,
                    enforcement: chrome.settingsPrivate.Enforcement.ENFORCED,
                    controlledBy: chrome.settingsPrivate.ControlledBy.DEVICE_POLICY,
                },
            },
            virtualPref_: {
                type: Boolean,
                value: {
                    key: 'virtual_pref',
                    type: chrome.settingsPrivate.PrefType.BOOLEAN,
                    value: true,
                },
            },
        };
    }
    onCheckedValueChange_(event) {
        this.checkedValue_ = event.detail;
    }
    onInvertedToggleChanged_(event) {
        this.set('virtualPref_.value', !event.detail);
    }
    handlePrefChange_(event) {
        this.set('virtualPref_.value', event.detail.value);
    }
    enableDialog_() {
        this.showBasicDialog_ = true;
    }
    getToggle_() {
        const toggle = this.shadowRoot.querySelector('#noSetPrefToggle');
        assert(toggle);
        return toggle;
    }
    closeDialog_() {
        const dialog = this.shadowRoot.querySelector('cr-dialog');
        assert(dialog);
        dialog.close();
        this.showBasicDialog_ = false;
    }
    onCancelButtonClicked_() {
        this.closeDialog_();
        const toggle = this.getToggle_();
        toggle.resetToPrefValue();
    }
    onConfirmButtonClicked_() {
        this.closeDialog_();
        const toggle = this.getToggle_();
        toggle.commitPrefChange();
    }
}
customElements.define(SettingsToggleV2Storybook.is, SettingsToggleV2Storybook);
