// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import 'chrome://resources/cros_components/sidenav/sidenav.js';
import '../../settings_shared.css.js';
import './storybook_styles.css.js';
import './settings_dropdown_row_storybook.js';
import './settings_dropdown_v2_storybook.js';
import './settings_row_storybook.js';
import './settings_slider_row_storybook.js';
import './settings_slider_v2_storybook.js';
import './settings_toggle_v2_storybook.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
import { castExists } from '../../assert_extras.js';
import { getTemplate } from './storybook_subpage.html.js';
export class SettingsStorybookSubpage extends PolymerElement {
    static get is() {
        return 'settings-storybook-subpage';
    }
    static get template() {
        return getTemplate();
    }
    static get properties() {
        return {
            /**
             * The index of the selected page.
             */
            selectedIndex_: {
                type: Number,
                value: 0,
            },
        };
    }
    ready() {
        super.ready();
        // Hide left menu.
        const uiElement = castExists(document.body.querySelector('os-settings-ui'));
        uiElement.shadowRoot.querySelector('#left').hidden = true;
    }
    onSidenavSelect_(event) {
        if (event.detail.enabled) {
            this.selectedIndex_ = parseInt(event.detail.item.id, 10);
        }
    }
}
customElements.define(SettingsStorybookSubpage.is, SettingsStorybookSubpage);
