import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><!-- TODO(b/281904820): Remove me. -->
<style include="settings-shared iron-flex iron-positioning">:host{--cr-dialog-width:372px}paper-spinner-lite{height:20px;position:absolute;right:16px;top:6px;width:20px}#confirmationCodeMessage{margin-bottom:30px}#cancel{margin-inline-end:8px}</style>
<cr-dialog id="installErrorDialog" show-on-attach>
  <div slot="title">$i18n{eSimInstallErrorDialogTitle}</div>
  <div slot="body">
    <div id="genericErrorContainer"
        hidden$="[[isConfirmationCodeError_(errorCode)]]">
      $i18n{eSimInstallErrorDialogGenericErrorMessage}
    </div>
    <template is="dom-if" if="[[isConfirmationCodeError_(errorCode)]]" restamp>
      <div id="confirmationCodeErrorContainer">
        <div id="confirmationCodeMessage">
          $i18n{eSimInstallErrorDialogConfirmationCodeMessage}
        </div>
        <div class="relative">
          <cr-input id="confirmationCode"
              value="{{confirmationCode_}}"
              spellcheck="false"
              disabled="[[isInstallInProgress_]]"
              error-message="$i18n{eSimInstallErrorDialogConfirmationCodeError}"
              invalid="[[isConfirmationCodeInvalid_]]">
          </cr-input>
          <paper-spinner-lite active
              hidden$="[[!isInstallInProgress_]]">
          </paper-spinner-lite>
        </div>
      </div>
    </template>
  </div>
  <div slot="button-container">
    <cr-button id="cancel"
        on-click="onCancelClicked_"
        class="cancel-button"
        hidden$="[[!isConfirmationCodeError_(errorCode)]]">
      $i18n{eSimRenameProfileDialogCancel}
    </cr-button>
    <cr-button id="done"
        on-click="onDoneClicked_"
        disabled="[[isDoneButtonDisabled_(errorCode, confirmationCode_, isInstallInProgress_)]]"
        class="action-button">
      $i18n{eSimRenameProfileDialogDone}
    </cr-button>
  </div>
</cr-dialog>
<!--_html_template_end_-->`;
}
