import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="settings-shared">:host{--cr-dialog-width:416px}#title{height:15px}#warningMessage{--iron-icon-fill-color:var(--cros-icon-color-disabled);--iron-icon-height:16px;--iron-icon-width:16px;font-size:smaller;margin-top:20px}#warningMessage iron-icon{float:left;padding-inline-end:4px}:host-context([dir='rtl']) #warningMessage iron-icon{float:right}#warningMessage div{overflow:hidden}#cancel{margin-inline-end:8px}#cancel:focus{box-shadow:0 0 0 2px var(--focus-shadow-color)}</style>
<cr-dialog id="dialog" show-on-attach>
  <div id="title" slot="title">
    [[getTitleString_(esimProfileName_)]]
  </div>
  <div slot="body">
    <div id="description">$i18n{eSimRemoveProfileDialogDescription}</div>
    <div id="warningMessage" hidden$="[[!showCellularDisconnectWarning]]">
      <iron-icon icon="cr:info-outline"></iron-icon>
      <div>$i18n{eSimDialogConnectionWarning}</div>
    </div>
  </div>
  <div slot="button-container">
    <cr-button id="cancel"
        aria-label="[[getCancelBtnA11yLabel_(esimProfileName_)]]"
        on-click="onCancelClick_"
        class="cancel-button">
      $i18n{eSimRemoveProfileDialogCancel}
    </cr-button>
    <cr-button id="remove"
        aria-label$="[[getRemoveBtnA11yLabel_(esimProfileName_)]]"
        aria-describedby="description warningMessage"
        on-click="onRemoveProfileClick_"
        class="action-button">
      $i18n{eSimRemoveProfileDialogRemove}
    </cr-button>
  </div>
</cr-dialog>
<!--_html_template_end_-->`;
}
