import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="settings-shared iron-positioning">:host{--cr-dialog-width:416px;--cr-dialog-title-slot-padding-bottom:10px}#body{overflow:hidden;padding:0 20px 2px 20px}#warningMessage{--iron-icon-fill-color:var(--cros-icon-color-disabled);--iron-icon-height:16px;--iron-icon-width:16px;font-size:smaller;padding-bottom:12px}#warningMessage iron-icon{float:left;padding-inline-end:4px}:host-context([dir='rtl']) #warningMessage iron-icon{float:right}#warningMessage div{overflow:hidden}#inputContainer{margin-top:12px}#inputInfo{background-color:var(--cros-bg-color);color:var(--cros-text-color-secondary);font-size:var(--cr-form-field-label-font-size);font-weight:400;height:30px;line-height:var(--cr-form-field-label-line-height);padding-top:8px;position:absolute;top:50px;width:100%}@media (prefers-color-scheme:dark){#inputInfo{background-image:linear-gradient(rgba(255,255,255,0.04),rgba(255,255,255,0.04))}}#inputInfo.error{color:var(--cros-text-color-alert)}#inputSubtitle{display:block;width:260px}#inputCount{position:absolute;right:0;top:8px}:host-context([dir='rtl']) #inputCount{left:0;right:auto}#cancel{margin-inline-end:8px}</style>
<cr-dialog id="profileRenameDialog" show-on-attach>
  <div slot="title">$i18n{eSimRenameProfileDialogLabel}</div>
  <div id="body" slot="body">
    <div id="warningMessage" hidden$="[[!showCellularDisconnectWarning]]">
      <iron-icon icon="cr:info-outline"></iron-icon>
      <div>$i18n{eSimDialogConnectionWarning}</div>
    </div>
    <template is="dom-if" if="[[!errorMessage_]]" restamp>
      <div id="inputContainer" class="relative">
        <!-- Set error-message so then it is read out by ChromeVox
          when cr-input is invalid. Since we already display the error
          message in #inputInfo, this is visually hidden by #inputInfo. -->
        <cr-input id="eSimprofileName"
            value="{{esimProfileName_}}"
            spellcheck="false"
            disabled="[[isRenameInProgress_]]"
            invalid="[[isInputInvalid_]]"
            label="$i18n{eSimRenameProfileInputTitle}"
            aria-label="[[i18n('eSimRenameProfileDialogLabel')]]"
            aria-description="[[i18n('eSimRenameProfileInputA11yLabel',
                maxInputLength)]]"
            error-message="[[i18n('eSimRenameProfileInputA11yLabel',
                maxInputLength)]]">
        </cr-input>
        <div id="inputInfo"
            class$="[[getInputInfoClass_(isInputInvalid_)]]"
            aria-hidden="true">
          <span id="inputSubtitle">$i18n{eSimRenameProfileInputSubtitle}</span>
          <span id="inputCount">
            [[getInputCountString_(esimProfileName_)]]
          </span>
        </div>
      </div>
    </template>
    <div id="errorMessage" aria-live="polite" hidden$="[[!errorMessage_]]">
      [[errorMessage_]]
    </div>
  </div>
  <div slot="button-container">
    <template is="dom-if" if="[[!errorMessage_]]" restamp>
      <cr-button id="cancel"
          on-click="onCancelClick_"
          disabled="[[isRenameInProgress_]]"
          class="cancel-button">
        $i18n{eSimRenameProfileDialogCancel}
      </cr-button>
    </template>
    <cr-button id="done"
        on-click="onRenameDialogDoneClick_"
        disabled="[[isDoneButtonDisabled_(isRenameInProgress_,
            esimProfileName_)]]"
        aria-label$="[[getDoneBtnA11yLabel_(esimProfileName_)]]"
        aria-describedby="warningMessage"
        class="action-button">
      $i18n{eSimRenameProfileDialogDone}
    </cr-button>
  </div>
</cr-dialog>
<!--_html_template_end_-->`;
}
