import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="internet-shared iron-flex">:host{--cr-dialog-width:380px}#subtitle{font-size:0.75rem;font-weight:500;height:40px;position:relative;left:20px;top:-10px;width:340px}#warningMessage{--iron-icon-fill-color:var(--cros-icon-color-disabled);--iron-icon-height:16px;--iron-icon-width:16px;font-size:smaller;margin-top:20px}#warningMessage iron-icon{float:left;padding-inline-end:4px}:host-context([dir='rtl']) #warningMessage iron-icon{float:right}#warningMessage div{overflow:hidden}network-config-toggle{color:var(--cr-primary-text-color)}.input-info{font-size:var(--cr-form-field-label-font-size);height:20px;position:relative;top:-16px}.error{color:var(--cros-text-color-alert)}#errorMessage{font-weight:500}
</style>

<cr-dialog id="dialog" show-on-attach>
  <div slot="title">$i18n{hotspotSettingsTitle}</div>>
  <div slot="header" id="subtitle" class="secondary">
    <localized-link
        localized-string="[[i18nAdvanced('hotspotSettingsSubtitle')]]">
    </localized-link>
  </div>

  <div id="body" slot="body" aria-hidden="true">
    <network-config-input id="hotspotName" label="$i18n{hotspotConfigNameLabel}"
        value="{{hotspotSsid_}}" invalid="[[isSsidInvalid_]]">
    </network-config-input>
    <div id="hotspotNameInputInfo"
        class$="[[getSsidInputInfoClass_(isSsidInvalid_)]]"
        aria-hidden="true">
      [[getSsidInputInfo_(hotspotSsid_)]]
    </div>
    <network-password-input id="hotspotPassword"
        label="$i18n{hotspotConfigPasswordLabel}" value="{{hotspotPassword_}}"
        invalid="[[isPasswordInvalid_]]">
    </network-password-input>
    <div id="hotspotPasswordInputInfo"
        class$="[[getPasswordInputInfoClass_(isPasswordInvalid_)]]"
        aria-hidden="true">
      $i18n{hotspotConfigPasswordInfo}
    </div>
    <network-config-select id="security"
        label="$i18n{hotspotConfigSecurityLabel}"
        onc-prefix="Hotspot.WiFi.Security"
        value="{{securityType_}}" items="[[getSecurityItems_()]]">
    </network-config-select>
    <network-config-toggle id="hotspotBssidToggle"
        label="$i18n{hotspotConfigBssidToggleLabel}"
        sub-label="$i18n{hotspotConfigBssidToggleSublabel}"
        checked="{{isRandomizeBssidToggleOn_}}">
    </network-config-toggle>
    <network-config-toggle id="hotspotCompatibilityToggle"
        label="$i18n{hotspotConfigCompatibilityToggleLabel}"
        sub-label="$i18n{hotspotConfigCompatibilityToggleSublabel}"
        checked="{{isExtendCompatibilityToggleOn_}}">
    </network-config-toggle>
    <div id="warningMessage" aria-hidden="true">
      <iron-icon tabindex="0" icon="cr:info-outline"
          aria-labelledby="hotspotConfigWarningMessage">
      </iron-icon>
      <div id="hotspotConfigWarningMessage">
        $i18n{hotspotConfigWarningMessage}
      </div>
    </div>
  </div>

  <div class="layout horizontal center" slot="button-container">
    <template is="dom-if" if="[[error_]]" restamp>
      <div id="errorMessage" class="flex error">
        [[error_]]
      </div>
    </template>
    <cr-button id="cancelButton" class="cancel-button" on-click="onCancelClick_">
      $i18n{hotspotConfigCancelButton}
    </cr-button>
    <cr-button id="saveButton" class="action-button" on-click="onSaveClick_"
        disabled="[[isSaveButtonDisabled_(isSsidInvalid_, isPasswordInvalid_)]]">
      $i18n{hotspotConfigSaveButton}
    </cr-button>
  </div>
</cr-dialog><!--_html_template_end_-->`;
}
