import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="settings-shared">.separator-line{border-top:var(--cr-separator-line);padding:0}#hotspotToggleText{font-weight:500}#hotspotToggleText[on]{color:var(--cros-text-color-prominent)}#hotspotToggleText:not([on]){color:var(--cros-text-color-secondary)}</style>
<div class="settings-box first">
  <div id="hotspotToggleText" class="start" on$="[[isHotspotToggleOn_]]">
     [[getOnOffString_(hotspotInfo.state)]]
  </div>
  <cr-toggle id="enableHotspotToggle"
      checked="{{isHotspotToggleOn_}}"
      disabled="[[isToggleDisabled_(hotspotInfo.allowStatus,
          hotspotInfo.state)]]"
      on-change="onHotspotToggleChange_"
      aria-label="$i18n{hotspotToggleA11yLabel}"
      deep-link-focus-id$="[[Setting.kHotspotOnOff]]">
  </cr-toggle>
</div>
<div id="hotspotConfigurationRow" class="settings-box two-line">
  <div class="link-wrapper">
    <div id="hotspotSSIDLabel" class="settings-box-text">
        $i18n{hotspotNameLabel}
      <div id="hotspotSSID" class="secondary">
          [[getHotspotConfigSsid_(hotspotInfo.config.ssid)]]
      </div>
    </div>
  </div>
  <cr-button id="configureButton"
      hidden$="[[!showHotspotAutoDisableToggle_(hotspotInfo)]]"
      on-click="onHotspotConfigureClick_">
    $i18n{hotspotConfigureButton}
  </cr-button>
</div>
<template is="dom-if" if="[[showHotspotAutoDisableToggle_(hotspotInfo)]]"
    restamp>
  <settings-toggle-button id="hotspotAutoDisableToggle" class="hr"
      label="$i18n{hotspotAutoDisableLabel}"
      sub-label="$i18n{hotspotAutoDisableSublabel}"
      pref="{{autoDisableVirtualPref_}}"
      on-change="onAutoDisableChange_"
      deep-link-focus-id$="[[Setting.kHotspotAutoDisabled]]">
  </settings-toggle-button>
</template>
<div id="connectedDeviceCountRow"
    class="settings-box settings-box-text two-line single-column stretch"
    hidden$="[[hideConnectedDeviceCount_(hotspotInfo)]]">
  <div id="connectedDeviceCountLabel">
      $i18n{hotspotConnectedDeviceCountLabel}
  </div>
  <div id="connectedDeviceCount" class="secondary">
      [[getHotspotConnectedDeviceCount_(hotspotInfo.clientCount)]]
  </div>
</div>
<div class="separator-line"></div>
<!--_html_template_end_-->`;
}
