import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="internet-shared iron-flex">.settings-box{border-top:var(--network-summary-item-border-top,var(--cr-separator-line))}#hotspotPageTitle{padding-inline-start:0}network-icon{padding-inline-end:16px;padding-inline-start:0;--network-icon-fill-color:var(--cros-sys-primary)}</style>

<div class="settings-box two-line no-padding">
  <div id="hotspotSummaryItemRow"
      actionable$="[[shouldShowArrowButton_(hotspotInfo.allowStatus)]]"
      on-click="navigateToDetailPage_"
      class="flex layout horizontal center link-wrapper">
      <network-icon
          id="hotspotIcon"
          hotspot-info="[[hotspotInfo]]">
      </network-icon>

    <div id="hotspotPageTitle" class="middle settings-box-text">
      $i18n{hotspotPageTitle}
      <div class="secondary" id="hotspotStateSublabel"
          hidden="[[shouldHideHotspotStateSublabel_(
              hotspotInfo.allowStatus, hotspotInfo.state)]]">
        [[getHotspotStateSublabel_(hotspotInfo.state)]]
      </div>
      <localized-link class="secondary" id="hotspotDisabledSublabelLink"
          hidden="[[!shouldHideHotspotStateSublabel_(
              hotspotInfo.allowStatus, hotspotInfo.state)]]"
          localized-string="[[getHotspotDisabledSublabelLink_(
              hotspotInfo.allowStatus)]]">
      </localized-link>
    </div>

    <template is="dom-if" if="[[shouldShowPolicyIndicator_(
        hotspotInfo.allowStatus)]]" restamp>
      <cr-policy-indicator id="policyIndicator"
          indicator-type="[[getPolicyIndicatorType_()]]">
      </cr-policy-indicator>
    </template>

    <template is="dom-if" if="[[shouldShowArrowButton_(
        hotspotInfo.allowStatus, hotspotInfo.state)]]" restamp>
      <cr-icon-button id="hotspotSummaryItemRowArrowIcon"
          class="subpage-arrow layout end"
          aria-label="$i18n{hotspotPageTitle}"
          aria-description$="[[getHotspotStateSublabel_(hotspotInfo.state)]]"
          aria-roledescription="$i18n{subpageArrowRoleDescription}"
          on-click="navigateToDetailPage_">
      </cr-icon-button>
    </template>
  </div>

  <div class="separator"></div>
  <cr-toggle id="enableHotspotToggle"
      class="margin-matches-padding"
      checked="{{isHotspotToggleOn_}}"
      disabled$="[[isToggleDisabled_(hotspotInfo.allowStatus,
          hotspotInfo.state)]]"
      on-change="onHotspotToggleChange_"
      aria-label="$i18n{hotspotToggleA11yLabel}">
  </cr-toggle>
</div>
<!--_html_template_end_-->`;
}
