import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="internet-shared iron-flex">cr-dialog::part(dialog){width:460px}.error{color:var(--cros-text-color-alert);font-weight:500}</style>

<cr-dialog id="dialog" close-text="$i18n{close}">
  <div id="dialogTitle" slot="title">
    [[getDialogTitle_(name, type, showConnect)]]
  </div>
  <div id="dialogBody" slot="body">
    <network-config id="networkConfig" class="flex"
        guid="[[guid]]" name="{{name}}" type="{{type}}"
        enable-connect="{{enableConnect_}}" enable-save="{{enableSave_}}"
        share-allow-enable="[[shareAllowEnable_]]"
        share-default="[[shareDefault_]]"
        error="{{error_}}"
        on-close="onClose_"
        connect-on-enter="[[showConnect]]"
        on-properties-set="onPropertiesSet_">
    </network-config>
  </div>

  <div class="layout horizontal center" slot="button-container">
    <template is="dom-if" if="[[error_]]" restamp>
      <div class="flex error">[[getError_(error_)]]</div>
    </template>
    <cr-button class="cancel-button" on-click="onCancelClick_">
      $i18n{cancel}
    </cr-button>
    <template is="dom-if" if="[[!showConnect]]">
      <cr-button id="saveButton" class="action-button"
          on-click="onSaveClick_" disabled="[[!enableSave_]]">
        $i18n{save}
      </cr-button>
    </template>
    <template is="dom-if" if="[[showConnect]]">
      <cr-button id="connectButton" class="action-button"
          on-click="onConnectClick_" disabled="[[!enableConnect_]]">
        $i18n{networkButtonConnect}
      </cr-button>
    </template>
  </div>

</cr-dialog>
<!--_html_template_end_-->`;
}
