import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="internet-shared settings-shared iron-flex">:host{padding-bottom:40px}iron-icon{margin-inline-end:10px}cr-policy-indicator{margin-inline-start:var(--cr-controlled-by-spacing)}cr-policy-network-indicator-mojo{margin:0 var(--cr-controlled-by-spacing)}#networkState[connected]{color:var(--cros-text-color-positive)}#networkState[warning]{color:var(--cros-text-color-warning)}#networkState[error]{color:var(--cros-text-color-alert)}#preferNetworkToggleContainer:hover{background-color:var(--cr-hover-background-color)}#preferNetworkToggleContainer:active{background-color:var(--cr-active-background-color)}paper-spinner-lite{height:var(--cr-icon-size);width:var(--cr-icon-size)}.warning{color:var(--cr-secondary-text-color);margin-inline-start:var(--cr-controlled-by-spacing)}#signinButton>iron-icon{margin-inline-end:0}#mac-address-container{border-top:none}#hiddenToggle{margin-inline-start:var(--cr-section-padding)}cr-link-row:not([warning]){--cr-secondary-text-color:var(--cros-text-color-positive)}#apnSubpageButton{height:var(--cr-section-two-line-min-height)}</style>
<!-- Title section: Icon + name + connection state. -->
<div id="titleDiv" class="settings-box first">
  <div class="start layout horizontal center">
    <network-icon
        show-technology-badge="[[showTechnologyBadge_]]"
        network-state="[[getNetworkState_(managedProperties_)]]">
    </network-icon>
    <div id="networkState" class="title settings-box-text"
        connected$="[[showConnectedState_(managedProperties_)]]"
        warning$="[[showRestrictedConnectivity_(managedProperties_,
                           deviceState_)]]"
        error$="[[isOutOfRangeOrNotEnabled_(outOfRange_, deviceState_)]]">
      [[getStateText_(managedProperties_, propertiesReceived_,
          outOfRange_, deviceState_)]]
    </div>
    <template is="dom-if"
        if="[[isPolicySource(managedProperties_.source))]]">
      <cr-policy-indicator
          indicator-type="[[getIndicatorTypeForSource(
              managedProperties_.source)]]">
      </cr-policy-indicator>
    </template>
  </div>
  <cr-button id="signinButton" on-click="onSigninClick_"
      hidden$="[[!showSignin_(managedProperties_)]]"
      disabled="[[disableSignin_(managedProperties_, disabled_)]]">
    <iron-icon icon="cr:open-in-new" slot="prefix-icon"></iron-icon>
    $i18n{networkButtonSignin}
  </cr-button>
  <cr-button id="forgetButton" on-click="onForgetClick_"
      hidden$="[[!showForget_(managedProperties_)]]"
      disabled="[[disableForget_(managedProperties_,
          prefs.vpn_config_allowed, disabled_)]]">
    $i18n{networkButtonForget}
  </cr-button>
  <cr-button id="viewAccountButton"
      on-click="onViewAccountClick_"
      hidden$="[[!showViewAccount_(managedProperties_)]]"
      disabled="[[disabled_]]">
    $i18n{networkButtonViewAccount}
  </cr-button>
  <cr-button id="activateButton"
      on-click="onActivateClick_"
      hidden$="[[!showActivate_(managedProperties_)]]"
      disabled="[[disabled_]]">
    $i18n{networkButtonActivate}
  </cr-button>
  <cr-button id="configureButton" on-click="onConfigureClick_"
      hidden$="[[!showConfigure_(managedProperties_, globalPolicy,
          managedNetworkAvailable)]]"
      disabled="[[disableConfigure_(managedProperties_,
          prefs.vpn_config_allowed, disabled_)]]"
      deep-link-focus-id$="[[Setting.kConfigureEthernet]]">
    $i18n{networkButtonConfigure}
  </cr-button>
  <!-- Use policy properties from vpn_config_allowed to indicate when that
      pref disables buttons in this row. -->
  <controlled-button id="connectDisconnect" class="action-button"
      on-click="onConnectDisconnectClick_"
      hidden$="[[shouldConnectDisconnectButtonBeHidden_(
          managedProperties_, globalPolicy, managedNetworkAvailable,
          deviceState_)]]"
      disabled="[[shouldConnectDisconnectButtonBeDisabled_(
          managedProperties_, defaultNetwork, propertiesReceived_,
          outOfRange_, globalPolicy, managedNetworkAvailable,
          deviceState_, disabled_)]]"
      label="[[getConnectDisconnectButtonLabel_(managedProperties_,
          globalPolicy,managedNetworkAvailable, deviceState_)]]"
      pref="[[getFakeVpnConfigPrefForEnforcement_(managedProperties_,
          prefs.vpn_config_allowed)]]"
      deep-link-focus-id$="[[Setting.kDisconnectWifiNetwork]]
          [[Setting.kDisconnectCellularNetwork]]
          [[Setting.kDisconnectTetherNetwork]]">
  </controlled-button>
</div>


<!-- Start of NOTICES section. -->
<!-- If row ordering changes, messagesDividerClass_() must be updated. -->
<template is="dom-if" if="[[isBlockedByPolicy_(managedProperties_,
                            globalPolicy, managedNetworkAvailable)]]">
  <!-- Disabled by policy -->
  <div class="settings-box continuation">
    <iron-icon class="policy" icon="cr20:domain"></iron-icon>
    <div class="settings-box-text">$i18n{networkConnectNotAllowed}</div>
  </div>
</template>

<template is="dom-if" if="[[isSecondaryUser_]]">
  <!-- Non primary users. -->
  <div class$="settings-box single-column
              [[messagesDividerClass_('secondary', managedProperties_,
                  globalPolicy, managedNetworkAvailable,
                  isSecondaryUser_, isWifiSyncEnabled_, deviceState_)]]">
    <div class="layout horizontal center">
      <iron-icon class="policy" icon="cr:group"></iron-icon>
      <div class="settings-box-text">
        [[i18n('networkPrimaryUserControlled', primaryUserEmail_)]]
      </div>
    </div>
  </div>
</template>


<template is="dom-if"
    if="[[showShared_(managedProperties_, globalPolicy,
        managedNetworkAvailable, deviceState_)]]">
  <!-- Shared network. -->
  <div class$="settings-box settings-box-text
              [[messagesDividerClass_('shared', managedProperties_,
                  globalPolicy, managedNetworkAvailable,
                  isSecondaryUser_, isWifiSyncEnabled_, deviceState_)]]">
      [[sharedString_(managedProperties_)]]
  </div>
</template>
<template is="dom-if"
    if="[[showSynced_(managedProperties_, globalPolicy,
        managedNetworkAvailable, isWifiSyncEnabled_)]]">
  <!-- Synced network. -->
  <div class$="settings-box settings-box-text
              [[messagesDividerClass_('synced', managedProperties_,
                  globalPolicy, managedNetworkAvailable,
                  isSecondaryUser_, isWifiSyncEnabled_, deviceState_)]]">
      <localized-link
          localized-string="[[syncedString_(managedProperties_)]]">
      </localized-link>
  </div>
</template>
<template is="dom-if"
    if="[[isCarrierLockedActiveSim_(managedProperties_, deviceState_)]]">
  <!-- Carrier locked network. -->
  <div class$="settings-box settings-box-text
      [[messagesDividerClass_('carrierlocked', managedProperties_,
          globalPolicy, managedNetworkAvailable,
          isSecondaryUser_, isWifiSyncEnabled_, deviceState_)]]">
    <localized-link id="carrierLockedNoticeLink"
        localized-string="[[i18nAdvanced('networkCarrierLocked')]]">
    </localized-link>
  </div>
</template>
<!-- End of NOTICES section -->

<template is="dom-if" if="[[!isSecondaryUser_]]">
  <template is="dom-if" if="[[showConfigurableSections_]]"  restamp>
    <!-- Prefer this network. -->
    <template is="dom-if"
        if="[[showPreferNetwork_(managedProperties_, globalPolicy,
            managedNetworkAvailable)]]">
      <div id="preferNetworkToggleContainer" class="settings-box"
          on-click="onPreferNetworkRowClicked_"
          actionable$="[[!isNetworkPolicyEnforced(
              managedProperties_.priority)]]">
        <div id="preferNetworkToggleLabel" class="start settings-box-text">
          $i18n{networkPrefer}
          <div class="secondary">
            $i18n{networkPreferDescription}
          </div>
        </div>
        <cr-policy-network-indicator-mojo
            property="[[managedProperties_.priority]]">
        </cr-policy-network-indicator-mojo>
        <cr-toggle id="preferNetworkToggle" checked="{{preferNetwork_}}"
            disabled="[[shouldPreferNetworkToggleBeDisabled_(
                managedProperties_.priority, disabled_)]]"
            aria-labelledby="preferNetworkToggleLabel"
            deep-link-focus-id$="[[Setting.kPreferWifiNetwork]]">
        </cr-toggle>
      </div>
    </template>
    <!-- Autoconnect. -->
    <template is="dom-if"
        if="[[showAutoConnect_(managedProperties_, globalPolicy,
            managedNetworkAvailable)]]">
      <settings-toggle-button id="autoConnectToggle" class="hr"
          pref="{{autoConnectPref_}}"
          label="[[getAutoConnectToggleLabel_(managedProperties_)]]"
          deep-link-focus-id$="[[Setting.kWifiAutoConnectToNetwork]]
              [[Setting.kCellularAutoConnectToNetwork]]"
          disabled="[[disabled_]]">
      </settings-toggle-button>
      <!-- Hidden Network Warning -->
      <template is="dom-if"
          if="[[showHiddenNetworkWarning_(autoConnectPref_.*,
              managedProperties_)]]"
          restamp>
        <div class="warning">
          <iron-icon icon="cr:warning"></iron-icon>
          [[i18n('hiddenNetworkWarning')]]
        </div>
      </template>
    </template>
    <!-- Always-on VPN. -->
    <template is="dom-if"
        if="[[showAlwaysOnVpn_(managedProperties_)]]">
      <settings-toggle-button id="alwaysOnVpnToggle" class="hr"
          pref="{{alwaysOnVpn_}}"
          label="$i18n{networkAlwaysOnVpn}"
          disabled="[[disabled_]]">
      </settings-toggle-button>
    </template>
    <!-- Data roaming (Cellular only). -->
    <template is="dom-if" if="[[isCellular_(managedProperties_)]]">
      <cellular-roaming-toggle-button
        disabled="[[disabled_]]"
        managed-properties="[[managedProperties_]]"
        prefs="{{prefs}}">
      </cellular-roaming-toggle-button>
    </template>
    <!-- Public Key (WireGuard VPN only). -->
    <template is="dom-if" if="[[isWireGuard_(managedProperties_)]]">
      <div id="wgPublicKeyField"
          class="settings-box two-line single-column stretch settings-box-text">
        <div aria-hidden="true" id="wgPublicKeyLabel">
          $i18n{OncVPN-WireGuard-PublicKey}
        </div>
        <div class="secondary" aria-labelledby="wgPublicKeyLabel">
          [[managedProperties_.typeProperties.vpn.wireguard.publicKey.activeValue]]
        </div>
      </div>
    </template>
    <!-- IP Address. -->
    <div
      class="settings-box two-line single-column stretch settings-box-text"
      hidden$="[[!showIpAddress_(ipAddress_, managedProperties_)]]">
      <div>$i18n{networkIPAddress}</div>
      <div class="secondary">[[ipAddress_]]</div>
    </div>
    <!-- Properties to always show if present. -->
    <template is="dom-if" if="[[hasInfoFields_(managedProperties_)]]">
      <div class="settings-box single-column stretch">
        <network-property-list-mojo id="infoFields"
            fields="[[getInfoFields_(managedProperties_)]]"
            edit-field-types="[[getInfoEditFieldTypes_(
              managedProperties_)]]"
            property-dict="[[managedProperties_]]"
            on-property-change="onNetworkPropertyChange_"
            disabled="[[disabled_]]">
        </network-property-list-mojo>
      </div>
    </template>
  </template>

  <!-- APN row item -->
  <template is="dom-if" if="[[showConfigurableSections_]]" restamp>
    <template is="dom-if" if="[[shouldShowApnRow_(managedProperties_,
        isApnRevampEnabled_)]]">
      <cr-link-row
          id="apnSubpageButton"
          class="hr"
          label="$i18n{internetApnPageTitle}"
          sub-label="[[getApnRowSubLabel_(managedProperties_)]]"
          on-click="onApnRowClicked_"
          role-description="$i18n{subpageArrowRoleDescription}"
          warning$="[[showRestrictedConnectivity_(managedProperties_,
              deviceState_)]]"
          disabled="[[disabled_]]">
        <template is="dom-if" if="[[isApnManaged_(globalPolicy)]]">
          <cr-policy-indicator id="apnManagedIcon"
              indicator-type="devicePolicy"
              icon-aria-label="$i18n{internetApnPageTitle}">
          </cr-policy-indicator>
        </template>
      </cr-link-row>
    </template>
  </template>

  <!-- Passpoint provider link -->
  <template is="dom-if" if="[[shouldShowPasspointProviderRow_(
        managedProperties_)]]">
    <div id="passpointProviderRow" class="settings-box two-line"
        on-click="onPasspointRowClicked_">
      <div class="flex settings-box-text">
        <div>$i18n{passpointProviderLabel}</div>
        <div class="secondary">
          [[getPasspointSubscriptionName_(passpointSubscription_)]]
        </div>
      </div>
      <cr-icon-button class="subpage-arrow"
          aria-roledescription="$i18n{subpageArrowRoleDescription}">
      </cr-icon-button>
    </div>
  </template>

  <template is="dom-if" if="[[hasAdvancedSection_(managedProperties_,
                              propertiesReceived_, deviceState_)]]">
    <!-- Advanced toggle. -->
    <cr-expand-button
        id="advancedSectionToggle"
        aria-label="$i18n{networkSectionAdvancedA11yLabel}"
        class="settings-box"
        expanded="{{advancedExpanded_}}">
      $i18n{networkSectionAdvanced}
    </cr-expand-button>

    <!-- Advanced section -->
    <iron-collapse opened="[[advancedExpanded_]]">
      <div class="settings-box single-column stretch indented first">
          <!-- SIM Info (Cellular only). -->
        <template is="dom-if"
            if="[[showCellularSimUpdatedUi_(managedProperties_)]]" restamp>
          <div class="single-column stretch">
            <network-siminfo id="cellularSimInfoAdvanced"
                network-state="[[getNetworkState_(managedProperties_)]]"
                device-state="[[deviceState_]]"
                global-policy="[[globalPolicy]]"
                disabled="[[disabled_]]">
            </network-siminfo>
          </div>
        </template>

        <!-- Suppress Text Messages (Cellular only). -->
        <template is="dom-if"
            if="[[shouldShowSuppressTextMessagesToggle_(managedProperties_,
                  deviceState_)]]" restamp>
          <div class="single-column stretch">
            <network-config-toggle id="suppressTextMessagesToggle" policy-on-left
                property="[[managedProperties_.typeProperties.cellular.allowTextMessages]]"
                label="$i18n{networkSuppressTextMessages}"
                checked="{{suppressTextMessagesOverride_}}"
                on-checked-changed="suppressTextMessagesChanged_"
                disabled="[[disabled_]]">
            </network-config-toggle>
          </div>
        </template>

        <!-- Metered (WiFi and Cellular only). -->
        <template is="dom-if"
            if="[[showMetered_(managedProperties_)]]">
          <network-config-toggle id="meteredToggle" policy-on-left
              property="[[managedProperties_.metered]]"
              label="$i18n{networkMetered}"
              sub-label="$i18n{networkMeteredDesc}"
              checked="{{meteredOverride_}}"
              on-checked-changed="meteredChanged_"
              deep-link-focus-id$="[[Setting.kWifiMetered]]
                  [[Setting.kCellularMetered]]"
              disabled="[[disabled_]]">
          </network-config-toggle>
        </template>
        <!-- Advanced properties -->
        <template is="dom-if"
            if="[[hasAdvancedFields_(managedProperties_)]]">
          <network-property-list-mojo id="advancedFields"
              fields="[[getAdvancedFields_(managedProperties_)]]"
              property-dict="[[managedProperties_]]"
              disabled="[[disabled_]]">
          </network-property-list-mojo>
        </template>
        <!-- Device properties -->
        <template is="dom-if"
            if="[[hasDeviceFields_(managedProperties_, deviceState_)]]">
          <network-property-list-mojo id="deviceFields"
              fields="[[getDeviceFields_(managedProperties_,
                  deviceState_)]]"
              property-dict="[[managedProperties_]]"
              disabled="[[disabled_]]">
          </network-property-list-mojo>
        </template>
      </div>
    </iron-collapse>
  </template>

  <template is="dom-if" if="[[showDataUsage_(managedProperties_,
      trafficCountersAvailable_)]]">
    <!-- Data usage toggle. -->
    <cr-expand-button
        aria-label="$i18n{TrafficCountersDataUsageLabel}"
        class="settings-box"
        expanded="{{dataUsageExpanded_}}">
      $i18n{TrafficCountersDataUsageLabel}
    </cr-expand-button>

    <!-- Data usage section -->
    <iron-collapse opened="[[dataUsageExpanded_]]">
      <settings-traffic-counters id="settingsTrafficCounters"
          guid="[[guid]]"
          managed-properties="[[managedProperties_]]"
          on-reset-day-changed="computeTrafficCountersAvailable_"
          on-reset-data-usage-button-clicked="computeTrafficCountersAvailable_">
      </settings-traffic-counters>
    </iron-collapse>
  </template>

  <template is="dom-if" if="[[showConfigurableSections_]]"  restamp>
    <template is="dom-if" if="[[hasNetworkSection_(managedProperties_,
        globalPolicy, managedNetworkAvailable)]]">
      <!-- Network toggle -->
      <cr-expand-button
          id="configurableSections"
          aria-label="$i18n{networkSectionNetworkExpandA11yLabel}"
          class="settings-box"
          expanded="{{networkExpanded_}}">
        <div class="settings-row">
          <div class="start">
            $i18n{networkSectionNetwork}
          </div>
          <template is="dom-if" if="[[showScanningSpinner_(
              managedProperties_, deviceState_)]]">
            <paper-spinner-lite active
                title="$i18n{mobileNetworkScanningLabel}">
            </paper-spinner-lite>
          </template>
        </div>
      </cr-expand-button>

      <iron-collapse opened="[[networkExpanded_]]">
        <div class="settings-box single-column stretch indented first">
          <!-- Choose Mobile Network (Cellular only). -->
          <template is="dom-if"
              if="[[showCellularChooseNetwork_(managedProperties_)]]">
            <network-choose-mobile device-state="[[deviceState_]]"
                managed-properties="[[managedProperties_]]"
                disabled="[[disabled_]]">
            </network-choose-mobile>
          </template>

          <!-- APN -->
          <template is="dom-if" if="[[shouldShowApnList_(managedProperties_,
              isApnRevampEnabled_)]]">
            <network-apnlist on-apn-change="onApnChange_"
                managed-properties="[[managedProperties_]]"
                disabled="[[disabled_]]">
            </network-apnlist>
          </template>

          <!-- IP Config, Nameservers -->
          <template is="dom-if"
              if="[[isRememberedOrConnected_(managedProperties_)]]">
            <network-ip-config on-ip-change="onIpConfigChange_"
                managed-properties="[[managedProperties_]]"
                disabled="[[disabled_]]">
            </network-ip-config>
            <network-nameservers on-nameservers-change="onIpConfigChange_"
                managed-properties="[[managedProperties_]]"
                disabled="[[disabled_]]">
            </network-nameservers>
          </template>
        </div>

        <!-- MAC Address. -->
        <div class="settings-box two-line single-column stretch indented"
            id="mac-address-container"
            hidden$="[[!shouldShowMacAddress_(deviceState_)]]">
          <div>$i18n{OncMacAddress}</div>
          <div class="secondary">[[getMacAddress_(deviceState_)]]</div>
        </div>

        <!-- Hidden. -->
        <template is="dom-if"
            if="[[showHiddenNetworkToggle_(
                    globalPolicy,
                    managedNetworkAvailable,
                    managedProperties_)]]">
          <settings-toggle-button id="hiddenToggle"
              pref="{{hiddenPref_}}"
              label="$i18n{networkHidden}"
              sub-label="$i18n{networkHiddenSublabel}"
              sub-label-icon="cr20:warning"
              learn-more-url="$i18n{wifiHiddenNetworkLearnMoreUrl}"
              deep-link-focus-id$="[[Setting.kWifiHidden]]">
          </settings-toggle-button>
        </template>
      </iron-collapse>
    </template>

    <template is="dom-if" if="[[hasProxySection_(managedProperties_,
        globalPolicy, managedNetworkAvailable)]]">
      <!-- Proxy toggle -->
      <cr-expand-button
          id="proxySectionToggle"
          aria-label="$i18n{networkSectionProxyExpandA11yLabel}"
          class="settings-box"
          expanded="{{proxyExpanded_}}">
        $i18n{networkSectionProxy}
      </cr-expand-button>

      <iron-collapse opened="[[proxyExpanded_]]">
        <network-proxy-section prefs="{{prefs}}"
            on-proxy-change="onProxyChange_"
            managed-properties="[[managedProperties_]]"
            disabled="[[disabled_]]">
        </network-proxy-section>
      </iron-collapse>
    </template>
  </template>
</template>
<template is="dom-if" if="[[isTether_(managedProperties_)]]" restamp>
  <tether-connection-dialog id="tetherDialog"
      managed-properties="[[managedProperties_]]"
      on-tether-connect="onTetherConnect_"
      out-of-range="[[outOfRange_]]">
  </tether-connection-dialog>
</template>
<template is="dom-if" if="[[isPasspointWifi_(managedProperties_)]]" restamp>
  <!-- Passpoint subscription removal confirmation dialog -->
  <passpoint-remove-dialog id="passpointRemovalDialog"
      on-confirm="onPasspointRemovalDialogConfirm_">
  </passpoint-remove-dialog>
</template>
<!--_html_template_end_-->`;
}
