import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="internet-shared iron-flex">cr-policy-indicator{margin-inline-start:var(--cr-controlled-by-spacing)}</style>

<div class="settings-box first">
  <div class="settings-box-text">$i18n{knownNetworksMessage}</div>
</div>

<h2 class="settings-box">$i18n{knownNetworksPreferred}</h2>
<div class="list-frame vertical-list"
    hidden$="[[havePreferred_(networkStateList_)]]">
  <div class="list-item settings-box-text">
    $i18n{internetNoNetworks}
  </div>
</div>
<div id="preferredNetworkList" class="list-frame vertical-list"
    hidden$="[[!havePreferred_(networkStateList_)]]">
  <template is="dom-repeat" items="[[networkStateList_]]"
      filter="networkIsPreferred_">
    <div class="list-item">
      <cr-link-row embedded label="[[getNetworkDisplayName_(item)]]"
          on-click="fireShowDetails_"
          role-description="$i18n{subpageArrowRoleDescription}"
          deep-link-focus-id$="[[Setting.kForgetWifiNetwork]]">
        <template is="dom-if" if="[[isPolicySource(item.source))]]">
          <cr-policy-indicator on-click="doNothing_"
              indicator-type="[[getIndicatorTypeForSource(item.source)]]"
              icon-aria-label="[[getEnterpriseIconAriaLabel_(item)]]">
          </cr-policy-indicator>
        </template>
      </cr-link-row>
      <div class="separator"></div>
      <cr-icon-button class="icon-more-vert" tabindex$="[[tabindex]]"
          on-click="onMenuButtonClick_" title="[[getMenuButtonTitle_(item)]]">
      </cr-icon-button>
    </div>
  </template>
</div>

<h2 class="settings-box">$i18n{knownNetworksAll}</h2>
<div id="notPreferredNetworkList" class="list-frame vertical-list"
    hidden$="[[!haveNotPreferred_(networkStateList_)]]">
  <template is="dom-repeat" items="[[networkStateList_]]"
      filter="networkIsNotPreferred_">
    <div class="list-item">
      <cr-link-row embedded label="[[getNetworkDisplayName_(item)]]"
          on-click="fireShowDetails_"
          role-description="$i18n{subpageArrowRoleDescription}"
          deep-link-focus-id$="[[Setting.kPreferWifiNetwork]]
              [[Setting.kForgetWifiNetwork]]">
        <template is="dom-if" if="[[isPolicySource(item.source))]]">
          <cr-policy-indicator on-click="doNothing_"
              indicator-type="[[getIndicatorTypeForSource(item.source)]]"
              icon-aria-label="[[getEnterpriseIconAriaLabel_(item)]]">
          </cr-policy-indicator>
        </template>
      </cr-link-row>
      <div class="separator"></div>
      <cr-icon-button class="icon-more-vert" tabindex$="[[tabindex]]"
          on-click="onMenuButtonClick_" title="[[getMenuButtonTitle_(item)]]">
      </cr-icon-button>
    </div>
  </template>
</div>

<template is="dom-if"
    if="[[shouldShowPasspointSection_(passpointSubscriptionsList_)]]">
  <h2 class="settings-box">$i18n{passpointSectionLabel}</h2>
  <div id="passpointSubscriptionList" class="list-frame vertical-list">
    <template is="dom-repeat" items="[[passpointSubscriptionsList_]]">
      <div class="list-item">
        <cr-link-row id="subscriptionItem" embedded
            label="[[getSubscriptionDisplayName_(item)]]"
            on-click="onSubscriptionListItemClick_"
            role-description="$i18n{subpageArrowRoleDescription}">
        </cr-link-row>
        <div class="separator"></div>
        <cr-icon-button id="subscriptionMoreButton" class="icon-more-vert"
            tabindex$="[[tabindex]]" on-click="onSubscriptionMenuButtonClick_"
            title="[[getSubscriptionMenuButtonTitle_(item)]]">
        </cr-icon-button>
      </div>
    </template>
  </div>
</template>

<cr-action-menu id="dotsMenu" role-description="$i18n{menu}">
  <button class="dropdown-item" hidden="[[!showAddPreferred_]]"
      on-click="onAddPreferredClick_">
    $i18n{knownNetworksMenuAddPreferred}
  </button>
  <button class="dropdown-item"
      hidden="[[!showRemovePreferred_]]" on-click="onRemovePreferredClick_">
    $i18n{knownNetworksMenuRemovePreferred}
  </button>
  <button class="dropdown-item" disabled="[[!enableForget_]]"
      on-click="onForgetClick_">
    $i18n{knownNetworksMenuForget}
  </button>
</cr-action-menu>

<cr-action-menu id="subscriptionDotsMenu" role-description="$i18n{menu}">
  <button id="subscriptionForget" class="dropdown-item"
      on-click="onSubscriptionForgetClick_">
    $i18n{knownNetworksMenuForget}
  </button>
</cr-action-menu>
<!--_html_template_end_-->`;
}
