import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="os-settings-icons settings-shared">iron-icon.policy{height:24px;margin-inline-end:12px;margin-inline-start:4px;width:24px}cr-toast iron-icon{--iron-icon-fill-color:var(--cros-toast-icon-color-warning);margin-inline-end:16px}#apnTooltip{text-align:center}#hotspotSubtitle{color:var(--cr-secondary-text-color);font-size:inherit;padding-left:20px;padding-top:8px;max-width:560px}#apnSubpageTitleExtra{display:flex;align-items:center}</style>
<os-settings-animated-pages id="pages" section="[[section_]]">
  <div route-path="default">
    <settings-card header-text="$i18n{internetPageTitle}">
      <network-summary default-network="{{defaultNetwork}}"
          device-states="{{deviceStates}}"
          hotspot-info="{{hotspotInfo}}"
          on-active-networks-updated="attemptDeepLink">
      </network-summary>
      <template is="dom-if" if="[[allowAddConnection_(globalPolicy_,
          managedNetworkAvailable)]]">
        <cr-expand-button
            aria-label="$i18n{internetAddConnectionExpandA11yLabel}"
            class="settings-box two-line"
            expanded="{{addConnectionExpanded_}}"
            id="expandAddConnections">
          <span aria-hidden="true">
            $i18n{internetAddConnection}
          </span>
        </cr-expand-button>
        <template is="dom-if" if="[[addConnectionExpanded_]]">
          <div class="list-frame vertical-list">
            <template is="dom-if" if="[[shouldShowAddWiFiRow_(globalPolicy_,
                managedNetworkAvailable, deviceStates)]]">
              <div actionable class="list-item" on-click="onAddWiFiClick_">
                <div class="start settings-box-text"
                    id="add-wifi-label" aria-hidden="true">
                  $i18n{internetAddWiFi}
                </div>
                <cr-icon-button class="icon-add-wifi"
                    aria-labelledby="add-wifi-label"></cr-icon-button>
              </div>
            </template>
            <div actionable$="[[!isBuiltInVpnManagementBlocked_]]"
                class="list-item" on-click="onAddVpnClick_">
              <div class="start settings-box-text"
                  id="add-vpn-label" aria-hidden="true">
                $i18n{internetAddVPN}
              </div>
              <template is="dom-if" if="[[isBuiltInVpnManagementBlocked_]]">
                <cr-policy-indicator id="vpnPolicyIndicator"
                    icon-aria-label="$i18n{networkVpnBuiltin}"
                    indicator-type="devicePolicy"
                    on-click="doNothing_">
                </cr-policy-indicator>
              </template>
              <cr-icon-button id="add-vpn-button" class="icon-add-circle"
                  aria-labelledby="add-vpn-label"
                  disabled="[[isBuiltInVpnManagementBlocked_]]">
              </cr-icon-button>
            </div>
            <template is="dom-repeat" items="[[vpnProviders_]]">
              <div actionable class="list-item"
                  on-click="onAddThirdPartyVpnClick_">
                <div class="start settings-box-text">
                  [[getAddThirdPartyVpnLabel_(item)]]
                </div>
                <cr-icon-button class="icon-external"
                    aria-label$="[[getAddThirdPartyVpnLabel_(item)]]">
                </cr-icon-button>
              </div>
            </template>
          </div>
        </template>
      </template>
      <template is="dom-if" if="[[!allowAddConnection_(globalPolicy_,
          managedNetworkAvailable)]]">
        <div class="settings-box">
          <iron-icon class="policy" icon="cr20:domain"></iron-icon>
          <div class="settings-box-text">
            $i18n{internetAddConnectionNotAllowed}
          </div>
        </div>
      </template>
    </settings-card>
  </div>

  <template is="dom-if" route-path="/networkDetail" restamp>
    <os-settings-subpage page-title="$i18n{internetDetailPageTitle}">
      <settings-internet-detail-menu
          slot="subpage-title-extra"
          device-state="[[getDeviceState_(subpageType_, deviceStates)]]">
      </settings-internet-detail-menu>
      <settings-internet-detail-subpage prefs="{{prefs}}"
          default-network="[[defaultNetwork]]"
          global-policy="[[globalPolicy_]]"
          managed-network-available="[[managedNetworkAvailable]]">
      </settings-internet-detail-subpage>
    </os-settings-subpage>
  </template>

  <template is="dom-if" route-path="/knownNetworks" restamp>
    <os-settings-subpage page-title="$i18n{internetKnownNetworksPageTitle}">
      <settings-internet-known-networks-subpage
          network-type="[[knownNetworksType_]]">
      </settings-internet-known-networks-subpage>
    </os-settings-subpage>
  </template>

  <template is="dom-if" route-path="/apn" restamp>
    <os-settings-subpage page-title="$i18n{internetApnPageTitle}">
      <div id="apnSubpageTitleExtra" slot="subpage-title-extra">
        <template is="dom-if" if="[[shouldDisallowApnModification_(globalPolicy_)]]">
          <cr-tooltip-icon id="apnManagedIcon"
              tooltip-text="$i18n{controlledSettingPolicy}"
              icon-class="cr20:domain"
              tooltip-position="bottom">
          </cr-tooltip-icon>
        </template>
        <cr-icon-button id="apnActionMenuButton" class="icon-more-vert"
            on-click="onApnMenuButtonClicked_"
            focus-row-control focus-type="menu"
            deep-link-focus-id$="[[Setting.kCellularAddApn]]"
            title="$i18n{moreActions}"
            disabled="[[shouldDisallowApnModification_(globalPolicy_)]]">
        </cr-icon-button>
      </div>
      <apn-subpage id="apnSubpage"
          is-num-custom-apns-limit-reached="{{isNumCustomApnsLimitReached_}}"
          should-disallow-apn-modification="[[shouldDisallowApnModification_(globalPolicy_)]]"
      >
      </apn-subpage>
    </os-settings-subpage>
  </template>

  <template is="dom-if" route-path="/networks" restamp>
    <os-settings-subpage page-title="[[getNetworksPageTitle_(subpageType_)]]"
        show-spinner="[[showSpinner_]]"
        spinner-title="$i18n{networkScanningLabel}">
      <settings-internet-subpage-menu
          slot="subpage-title-extra"
          device-state="[[getDeviceState_(subpageType_, deviceStates)]]">
      </settings-internet-subpage-menu>
      <template is="dom-if" if="[[isDeviceUpdating_]]" restamp>
        <div class="settings-box first">
          <div id="flashingSubtitle" class="settings-box-text">
            $i18n{internetDeviceFlashing}
          </div>
        </div>
      </template>
      <template is="dom-if"
          if="[[isProviderLocked_]]" restamp>
        <!-- Carrier locked network. -->
        <div class="settings-box first">
          <div id="cellularSubtitle" class="settings-box-text">
            <localized-link
                localized-string="[[i18nAdvanced('cellularSubpageSubtitle')]]">
            </localized-link>
          </div>
        </div>
      </template>
      <settings-internet-subpage
          prefs="{{prefs}}"
          default-network="[[defaultNetwork]]"
          device-state="[[getDeviceState_(subpageType_, deviceStates)]]"
          tether-device-state="[[getTetherDeviceState_(deviceStates)]]"
          global-policy="[[globalPolicy_]]"
          vpn-providers="[[vpnProviders_]]"
          show-spinner="{{showSpinner_}}"
          is-connected-to-non-cellular-network="[[isConnectedToNonCellularNetwork_]]"
          is-cellular-setup-active="[[showCellularSetupDialog_]]"
          is-built-in-vpn-management-blocked=
              "[[isBuiltInVpnManagementBlocked_]]">
      </settings-internet-subpage>
    </os-settings-subpage>
  </template>

  <template is="dom-if" route-path="/hotspotDetail" restamp>
    <os-settings-subpage id="hotspotSubpage" page-title="$i18n{hotspotPageTitle}"
        show-spinner="[[showHotspotSpinner_(hotspotInfo.state)]]">
      <div id="hotspotSubtitle">
        <localized-link
            localized-string="[[i18nAdvanced('hotspotSubpageSubtitle')]]">
        </localized-link>
      </div>
      <settings-hotspot-subpage hotspot-info="[[hotspotInfo]]">
      </settings-hotspot-subpage>
    </os-settings-subpage>
  </template>

  <template is="dom-if" route-path="/passpointDetail" restamp>
    <os-settings-subpage
        page-title="[[getPasspointSubscriptionName_(passpointSubscription_)]]">
      <settings-passpoint-subpage>
      </settings-passpoint-subpage>
    </os-settings-subpage>
  </template>

</os-settings-animated-pages>

<template is="dom-if" if="[[showInternetConfig_]]" restamp>
  <internet-config id="configDialog" on-close="onInternetConfigClose_">
  </internet-config>
</template>

<template is="dom-if" if="[[showCellularSetupDialog_]]" restamp>
  <os-settings-cellular-setup-dialog id="cellularSetupDialog"
      on-close="onCloseCellularSetupDialog_"
      page-name="[[cellularSetupDialogPageName_]]">
  </os-settings-cellular-setup-dialog>
</template>

<template is="dom-if" if="[[showESimProfileRenameDialog_]]" restamp>
  <esim-rename-dialog id="esimRenameDialog"
      on-close="onCloseEsimProfileRenameDialog_"
      network-state="[[eSimNetworkState_]]"
      show-cellular-disconnect-warning="[[hasActiveCellularNetwork_]]">
  </esim-rename-dialog>
</template>

<template is="dom-if" if="[[showESimRemoveProfileDialog_]]" restamp>
  <esim-remove-profile-dialog id="esimRemoveProfileDialog"
      on-close="onCloseEsimRemoveProfileDialog_"
      on-show-error-toast="onShowErrorToast_"
      network-state="[[eSimNetworkState_]]"
      show-cellular-disconnect-warning="[[hasActiveCellularNetwork_]]">
  </esim-remove-profile-dialog>
</template>

<template is="dom-if" if="[[showSimLockDialog_]]" restamp>
  <sim-lock-dialogs
      global-policy="[[globalPolicy_]]"
      is-dialog-open="{{showSimLockDialog_}}"
      device-state="[[getDeviceState_(subpageType_, deviceStates)]]">
  </sim-lock-dialogs>
</template>

<template is="dom-if" if="[[showHotspotConfigDialog_]]" restamp>
  <hotspot-config-dialog id="hotspotConfigDialog"
      on-close="onCloseHotspotConfigDialog_"
      hotspot-info="[[hotspotInfo]]">
  </hotspot-config-dialog>
</template>

<cr-action-menu id="apnDotsMenu">
  <button id="discoverMoreApnsButton" class="dropdown-item"
      on-click="onDiscoverMoreApnsClicked_"
      disabled="[[isNumCustomApnsLimitReached_]]">
    $i18n{apnPageDiscoverMoreApns}
  </button>
  <button id="createCustomApnButton" class="dropdown-item"
      on-click="onCreateCustomApnClicked_"
      disabled="[[isNumCustomApnsLimitReached_]]">
    $i18n{apnPageCreateNewApn}
  </button>
</cr-action-menu>

<template is="dom-if" if="[[isNumCustomApnsLimitReached_]]" restamp>
  <!-- TODO(b/162365553) Add a11y support-->
  <paper-tooltip id="discoverMoreApnsTooltip"
      for="discoverMoreApnsButton"
      position="[[apnMenuTooltipsPosition_]]">
    $i18n{customApnLimitReached}
  </paper-tooltip>
  <paper-tooltip id="createCustomApnTooltip"
      for="createCustomApnButton"
      position="[[apnMenuTooltipsPosition_]]">
    $i18n{customApnLimitReached}
  </paper-tooltip>
</template>

<cr-toast id="errorToast" duration="5000">
  <span id="errorToastMessage">[[errorToastMessage_]]</span>
</cr-toast>
<!--_html_template_end_-->`;
}
