import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="cr-shared-style os-settings-icons settings-shared iron-flex">#networkListDiv{min-height:var(--cr-section-two-line-min-height)}:host(:not([is-showing-vpn_],[is-showing-tether_])) #networkListDiv{margin-top:var(--cr-section-vertical-margin)}#cellularNetworkList{margin-top:calc(-1*var(--cr-section-vertical-margin))}#instant-tether-notifications-toggle{border-bottom:var(--cr-separator-line);min-height:var(--cr-section-min-height)}#your-device-hotspots-header{color:var(--cros-text-color-primary);font:var(--cros-button-1-font);margin-bottom:5px}#networkListDiv>*{padding-inline-end:calc(var(--cr-section-padding) - var(--cr-icon-ripple-padding));padding-inline-start:var(--cr-section-padding)}.add-button{margin-inline-end:20px}.vpn-header{margin-bottom:8px;margin-inline-end:12px;margin-inline-start:4px;margin-top:8px}.no-networks{min-height:var(--cr-section-two-line-min-height)}network-list{flex:1}network-always-on-vpn{width:100%}#gmscore-notifications-container{border-top:var(--cr-separator-line);margin:10px 0;padding-bottom:var(--cr-section-padding);padding-top:var(--cr-section-padding)}#gmscore-notifications-container[no-networks-text-below]{border-bottom:var(--cr-separator-line);margin-top:0}#gmscore-notifications-device-string{margin-top:5px}#gmscore-notifications-instructions{margin:0;padding-inline-start:15px}#cellularNetworkList{padding-inline-end:0;padding-inline-start:0}</style>

<template is="dom-if" if="[[shouldShowBluetoothDisabledTetherErrorMessage_(deviceState)]]">
  <div id="networkListDiv" class="layout horizontal center">
    <localized-link
      localized-string="[[getBluetoothDisabledErrorMessageForTether_()]]">
    </localized-link>
  </div>
</template>

<template is="dom-if" if="[[enableToggleIsVisible_(deviceState)]]">
  <div class="settings-box first">
    <div class="primary-toggle start" on$="[[deviceIsEnabled_(deviceState)]]"
        aria-hidden="true">
      [[getOffOnString_(deviceState,
        '$i18nPolymer{deviceOn}', '$i18nPolymer{deviceOff}')]]
    </div>
    <!-- The add button in this row is only shown for WiFi networks. -->
    <cr-icon-button class="icon-add-wifi add-button" id="addWifiButton"
        hidden$="[[!showAddWifiButton_(deviceState, globalPolicy)]]"
        aria-label="$i18n{internetAddWiFi}" on-click="onAddWifiButtonClick_"
        tabindex$="[[tabindex]]"
        deep-link-focus-id$="[[Setting.kWifiAddNetwork]]">
    </cr-icon-button>
    <cr-toggle id="deviceEnabledButton"
        aria-label$="[[getToggleA11yString_(deviceState)]]"
        checked="[[deviceIsEnabled_(deviceState)]]"
        disabled="[[!enableToggleIsEnabled_(deviceState,
          deviceState.inhibitReason)]]"
        on-change="onDeviceEnabledChange_"
        deep-link-focus-id$="[[Setting.kWifiOnOff]]
            [[Setting.kMobileOnOff]]">
    </cr-toggle>
  </div>
</template>

<template is="dom-if" if="[[knownNetworksIsVisible_(deviceState)]]">
  <cr-link-row
      id="knownNetworksSubpageButton"
      class="hr"
      label="$i18n{knownNetworksButton}"
      on-click="onKnownNetworksClick_"
      role-description="$i18n{subpageArrowRoleDescription}">
  </cr-link-row>
</template>


<template is="dom-if" if="[[shouldShowTetherNotificationControl_(deviceState)]]">
  <settings-toggle-button
     id="instant-tether-notifications-toggle"
     label="$i18n{internetTetherNotificationControlTitle}"
     sub-label="$i18n{internetTetherNotificationControlDescription}"
     pref="{{prefs.tether.notifications_enabled}}">
  </settings-toggle-button>
</template>

<template is="dom-if" if="[[deviceIsEnabled_(deviceState)]]">
  <div id="networkListDiv" class="layout vertical flex">
    <!-- VPN only header for built-in VPNs. -->
    <template is="dom-if" if="[[isShowingVpn_]]">
      <div class="vpn-header layout horizontal center">
        <div class="flex settings-box-text">$i18n{networkVpnBuiltin}</div>
        <template is="dom-if" if="[[isBuiltInVpnManagementBlocked]]">
          <cr-policy-indicator indicator-type="devicePolicy">
          </cr-policy-indicator>
        </template>
        <cr-icon-button class="icon-add-circle"
            id="addBuiltInVpnButton"
            disabled="[[isBuiltInVpnManagementBlocked]]"
            aria-label="$i18n{internetAddVPN}"
            on-click="onAddVpnButtonClick_"
            tabindex$="[[tabindex]]">
        </cr-icon-button>
      </div>
    </template>

    <!-- List of networks (empty if no networks exist). -->
    <template is="dom-if"
        if="[[shouldShowNetworkList_(networkStateList_, deviceState)]]">
      <template is="dom-if" if="[[shouldShowTetherDeviceListHeader_(deviceState)]]">
          <div id="your-device-hotspots-title">$i18n{internetYourDeviceHotspots}</div>
      </template>
      <network-list id="networkList" show-buttons
          class="layout horizontal center"
          is-built-in-vpn-management-blocked="[[isBuiltInVpnManagementBlocked]]"
          show-technology-badge="[[showTechnologyBadge_]]"
          networks="[[networkStateList_]]"
          global-policy="[[globalPolicy]]"
          on-selected="onNetworkSelected_"
          device-state="[[deviceState]]">
      </network-list>
    </template>

    <!-- List of cellular and instant tethering networks -->
    <template is="dom-if"
        if="[[shouldShowCellularNetworkList_(networkStateList_,
                                              deviceState)]]">
      <cellular-networks-list id="cellularNetworkList"
          networks="[[networkStateList_]]"
          show-technology-badge="[[showTechnologyBadge_]]"
          on-selected="onNetworkSelected_"
          cellular-device-state="[[deviceState]]"
          tether-device-state="[[tetherDeviceState]]"
          global-policy="[[globalPolicy]]"
          is-connected-to-non-cellular-network="[[isConnectedToNonCellularNetwork]]"
          can-show-spinner="[[!isCellularSetupActive]]">
      </cellular-networks-list>
    </template>

    <!-- Instructions for how to enable "Google Play Services" notifications
        (needed for Instant Tethering). -->
    <template is="dom-if" if="[[showGmsCoreNotificationsSection_(
        notificationsDisabledDeviceNames_)]]">
      <div id="gmscore-notifications-container"
          no-networks-text-below$="[[!networkStateList_.length]]">
        <div>$i18n{gmscoreNotificationsTitle}</div>
        <div id="gmscore-notifications-device-string"
            class="cr-secondary-text">
          [[getGmsCoreNotificationsDevicesString_(
              notificationsDisabledDeviceNames_)]]
        </div>
        <ol id="gmscore-notifications-instructions"
            class="cr-secondary-text">
          <li>$i18n{gmscoreNotificationsFirstStep}</li>
          <li>$i18n{gmscoreNotificationsSecondStep}</li>
          <li>$i18n{gmscoreNotificationsThirdStep}</li>
          <li>$i18n{gmscoreNotificationsFourthStep}</li>
        </ol>
      </div>
    </template>

    <!-- Text shown if no networks exist. -->
    <template is="dom-if" if="[[!hideNoNetworksMessage_(networkStateList_, deviceState)]]">
      <div class="layout horizontal center no-networks">
        <localized-link
          localized-string="[[getNoNetworksInnerHtml_(deviceState, tetherDeviceState)]]">
        </localized-link>
      </div>
    </template>

    <template is="dom-if" if="[[isShowingVpn_]]">
      <!-- Third party VPNs. -->
      <template is="dom-repeat"
          items="[[getVpnProviders_(vpnProviders, thirdPartyVpns_)]]">
        <div id="[[item.providerName]]"
            class="vpn-header layout horizontal center">
          <div class="flex settings-box-text">[[item.providerName]]</div>
          <cr-icon-button class="icon-external"
              aria-label$="[[getAddThirdPartyVpnA11yString_(item)]]"
              on-click="onAddThirdPartyVpnClick_" tabindex$="[[tabindex]]">
          </cr-icon-button>
        </div>
        <network-list show-buttons
            hidden$="[[!haveThirdPartyVpnNetwork_(thirdPartyVpns_, item)]]"
            networks="[[getThirdPartyVpnNetworks_(thirdPartyVpns_, item)]]"
            on-selected="onNetworkSelected_">
        </network-list>
      </template>
    </template>
  </div>

  <template is="dom-if"
      if="[[shouldShowVpnPreferences_(isManaged_, isShowingVpn_)]]">
    <div class="settings-box first">
      <h2>$i18n{networkVpnPreferences}</h2>
    </div>
    <div class="settings-box first">
      <network-always-on-vpn id="alwaysOnVpnSelector"
          networks="[[getAlwaysOnVpnNetworks_(deviceState,
            networkStateList_, thirdPartyVpns_)]]"
          mode="{{alwaysOnVpnMode_}}"
          service="{{alwaysOnVpnService_}}">
      </network-always-on-vpn>
    </div>
  </template>
</template>
<!--_html_template_end_-->`;
}
