import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="settings-shared iron-flex">:host{--cr-dialog-body-padding-horizontal:24px;--cr-dialog-button-container-padding-bottom:20px;--cr-dialog-button-container-padding-horizontal:24px;--cr-dialog-width:416px;--cr-dialog-title-slot-padding-bottom:12px;--cr-dialog-title-slot-padding-end:24px;--cr-dialog-title-slot-padding-start:24px;--cr-dialog-title-font-size:calc(16 / 13 * 100%)}#qrCodeCanvas{background-color:white;display:block;margin:20px auto 20px auto;max-width:calc(var(--cr-dialog-width) - var(--cr-dialog-title-slot-padding-start) - var(--cr-dialog-title-slot-padding-end))}.info-container{padding-top:16px}#eidContainer{border-bottom:var(--cr-separator-line)}.info-label{font-weight:bold}.info-value{color:var(--cr-primary-text-color)}</style>
<cr-dialog id="deviceInfoDialog" show-on-attach>
  <div slot="title">$i18n{mobileDeviceInfoPopupTitle}</div>
  <div slot="body" id="body" aria-label="[[getA11yLabel_(deviceState, eid_)]]">
    <div id="dialogDescription" aria-hidden="true">
      $i18n{mobileDeviceInfoPopupDescription}
    </div>
    <template is="dom-if" if="[[shouldShowEidAndQrCode_(eid_)]]">
      <div class="info-container" id="eidContainer">
        <div class="info-label" aria-hidden="true">
          $i18n{deviceInfoPopupEidLabel}
        </div>
        <div class="info-value" id="eid" aria-hidden="true">[[eid_]]</div>
        <canvas id="qrCodeCanvas"
            width="[[canvasSize_]]"
            height="[[canvasSize_]]">
        </canvas>
      </div>
    </template>
    <template is="dom-if" if="[[shouldShowImei_(deviceState)]]">
      <div class="info-container">
        <div class="info-label" aria-hidden="true">
          $i18n{deviceInfoPopupImeiLabel}
        </div>
        <div id="imei" class="info-value" aria-hidden="true">
          [[deviceState.imei]]
        </div>
      </div>
    </template>
    <template is="dom-if" if="[[shouldShowSerial_(deviceState)]]">
      <div class="info-container">
        <div class="info-label" aria-hidden="true">
          $i18n{deviceInfoPopupSerialLabel}
        </div>
        <div id="serialLabel" class="info-value" aria-hidden="true">
          [[deviceState.serial]]
        </div>
      </div>
    </template>
  </div>
  <div slot="button-container">
    <cr-button id="done" class="action-button"
        on-click="onDonePressed_">
      $i18n{done}
    </cr-button>
  </div>
</cr-dialog>
<!--_html_template_end_-->`;
}
