import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="internet-shared cr-hidden-style iron-flex
    iron-flex-alignment">cr-policy-network-indicator-mojo{margin-inline-end:10px}extension-controlled-indicator{margin-inline-start:0;width:100%}.settings-box:first-of-type{border-top:none}</style>

<!-- Policy indicator. Only one dom-if below will be shown. -->
<template is="dom-if"
    if="[[shouldShowNetworkPolicyIndicator_(managedProperties)]]">
  <div class="settings-box">
    <div class="layout horizontal center">
      <cr-policy-network-indicator-mojo
          property="[[managedProperties.proxySettings.type]]"
          no-extension-indicator>
      </cr-policy-network-indicator-mojo>
      <div>$i18n{networkProxyEnforcedPolicy}</div>
    </div>
  </div>
</template>

<template is="dom-if" if="[[isProxySetByExtension_(managedProperties)]]">
  <div class="settings-box">
    <extension-controlled-indicator
        extension-id="[[extensionInfo_.id]]"
        extension-name="[[extensionInfo_.name]]"
        extension-can-be-disabled="[[extensionInfo_.canBeDisabled]]">
    </extension-controlled-indicator>
  </div>
</template>

<!-- Allow shared proxies -->
<settings-toggle-button id="allowShared" class="indented"
    hidden$="[[!shouldShowAllowShared_(managedProperties.source)]]"
    pref="{{prefs.settings.use_shared_proxies}}"
    label="$i18n{networkProxyAllowShared}"
    on-settings-boolean-control-change="onAllowSharedProxiesChange_"
    no-set-pref
    disabled="[[disabled]]">
</settings-toggle-button>

<div class="settings-box single-column stretch continuation indented">
  <network-proxy editable="[[!disabled]]"
      managed-properties="[[managedProperties]]"
      use-shared-proxies="[[useSharedProxies_]]">
  </network-proxy>
</div>

<!-- Confirm Allow shared proxies dialog -->
<cr-dialog id="confirmAllowSharedDialog"
    close-text="$i18n{close}" on-cancel="onAllowSharedDialogCancel_"
    on-close="onAllowSharedDialogClose_">
  <div slot="title">
    [[getAllowSharedDialogTitle_(prefs.settings.use_shared_proxies.value)]]
  </div>
  <div slot="body">
    $i18n{networkProxyAllowSharedWarningMessage}
  </div>
  <div slot="button-container">
    <cr-button class="cancel-button"
        on-click="onAllowSharedDialogCancel_">
      $i18n{cancel}
    </cr-button>
    <cr-button class="action-button"
        on-click="onAllowSharedDialogConfirm_">
      $i18n{confirm}
    </cr-button>
  </div>
</cr-dialog>
<!--_html_template_end_-->`;
}
