import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="internet-shared iron-flex">.settings-box{border-top:var(--network-summary-item-border-top,var(--cr-separator-line))}#outerBox{padding:0 var(--cr-section-padding)}#details{align-items:center;display:flex;flex:auto}.network-state{color:var(--cr-secondary-text-color);font-size:inherit}.warning-message{color:var(--cros-text-color-warning);font-size:inherit}#networkIcon{--network-icon-fill-color:var(--cros-sys-primary);padding-inline-end:16px;padding-inline-start:0}</style>
<div class="settings-box two-line no-padding">
  <div id="networkSummaryItemRow"
      actionable$="[[isItemActionable_(activeNetworkState,
                        deviceState, networkStateList)]]"
      class="flex layout horizontal center link-wrapper"
      on-click="onShowDetailsClick_">
    <div id="details" aria-hidden="true">
      <network-icon
          id="networkIcon"
          show-technology-badge="[[showTechnologyBadge_]]"
          network-state="[[activeNetworkState]]"
          device-state="[[deviceState]]">
      </network-icon>
      <div class="flex settings-box-text">
        <div id="networkTitleText">
          [[getTitleText_(activeNetworkState, deviceState)]]
        </div>
        <div id="networkState"
            class$="[[getNetworkStateClass_(activeNetworkState)]]">
          [[getNetworkStateText_(activeNetworkState, deviceState.*)]]
        </div>
      </div>
    </div>

    <template is="dom-if" if="[[showPolicyIndicator_(activeNetworkState)]]">
      <cr-policy-indicator id="policyIndicator"
          icon-aria-label="[[getTitleText_(activeNetworkState, deviceState)]]"
          indicator-type="[[getPolicyIndicatorType_(activeNetworkState)]]"
          on-click="doNothing_">
      </cr-policy-indicator>
    </template>

    <template is="dom-if" if="[[showArrowButton_(activeNetworkState,
                                  deviceState, networkStateList)]]">
      <cr-icon-button id="networkSummaryItemRowArrowIcon"
          class="subpage-arrow"
          aria-labelledby="networkTitleText"
          aria-describedby="networkState networkIcon"
          aria-roledescription="$i18n{subpageArrowRoleDescription}"
          on-click="onShowDetailsArrowClick_">
      </cr-icon-button>
    </template>
  </div>

  <template is="dom-if" if="[[enableToggleIsVisible_(deviceState)]]">
    <div class="separator"></div>
    <cr-toggle id="deviceEnabledButton"
        class="margin-matches-padding"
        aria-label$="[[getToggleA11yString_(deviceState)]]"
        aria-describedby$="[[getToggleA11yDescribedBy_(deviceState)]]"
        checked="[[deviceIsEnabledOrEnabling_(deviceState)]]"
        disabled="[[!enableToggleIsEnabled_(deviceState)]]"
        on-change="onDeviceEnabledChange_">
    </cr-toggle>
  </template>
</div>
<!--_html_template_end_-->`;
}
