import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="settings-shared">#description{margin-bottom:var(--cr-section-vertical-margin)}</style>
<cr-dialog id="dialog" close-text="$i18n{close}">
  <div slot="title">
    $i18n{networkSectionPasspointGoToSubscriptionTitle}
  </div>
  <div slot="body">
    <span id="information">
      $i18n{networkSectionPasspointGoToSubscriptionInformation}
      <a href="$i18nRaw{wifiPasspointLearnMoreUrl}" target="_blank"
          aria-label="$i18n{passpointLearnMoreA11yLabel}">
        $i18n{learnMoreLabel}
      </a>
    </span>
  </div>
  <div slot="button-container">
    <cr-button id="cancelButton" class="cancel-button"
        aria-label="$i18n{passpointRemoveCancelA11yLabel}"
        on-click="onCancelClick_">
      $i18n{cancel}
    </cr-button>
    <cr-button id="confirmButton" class="action-button"
        aria-label="$i18n{passpointRemoveGoToSubscriptionButtonA11yLabel}"
        on-click="onConfirmClick_">
      $i18n{networkSectionPasspointGoToSubscriptionButtonLabel}
    </cr-button>
  </div>
</cr-dialog>
<!--_html_template_end_-->`;
}
