import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="settings-shared network-shared">#headlineLink{margin-inline-start:36px}</style>
<div class="settings-box first two-line">
  <localized-link id="headlineLink" class="secondary"
      localized-string="$i18n{passpointHeadlineText}"
      link-url="$i18nRaw{wifiPasspointLearnMoreUrl}">
  </localized-link>
  <cr-button id="removeButton" on-click="onForgetClick_">
    $i18n{passpointRemoveButton}
  </cr-button>
</div>
<template is="dom-if" if="[[hasExpirationDate_(subscription_)]]">
  <div class="settings-box first two-line single-column">
    <div id="passpointExpirationLabel">
      $i18n{passpointSubscriptionExpirationLabel}
    </div>
    <div id="passpointExpirationDate" class="secondary">
      [[getExpirationDate_(subscription_)]]
    </div>
  </div>
</template>
<div class="settings-box two-line single-column">
  <div id="passpointSourceLabel">
    $i18n{passpointSourceLabel}
  </div>
  <div id="passpointSourceText" class="secondary">
    [[providerName_]]
  </div>
</div>
<div class="settings-box two-line single-column">
  <div id="passpointTrustedCALabel">
    $i18n{passpointTrustedCALabel}
  </div>
  <div id="passpointCertificateName" class="secondary">
    [[certificateAuthorityName_]]
  </div>
</div>
<template is="dom-if" if="[[hasNetworks_(networks_)]]">
  <h2 class="settings-box">$i18n{passpointAssociatedWifiNetworks}</h2>
  <div id="passpointNetworksList" class="list-frame vertical-list">
    <template is="dom-repeat" items="[[networks_]]">
      <div class="list-item">
        <cr-link-row embedded label="[[getNetworkDisplayName_(item)]]"
            on-click="onAssociatedNetworkClicked_"
            role-description="$i18n{subpageArrowRoleDescription}">
        </cr-link-row>
      </div>
    </template>
  </div>
</template>
<cr-expand-button aria-label="$i18n{passpointDomainsA11yLabel}"
    class="settings-box" expanded="{{domainsExpanded_}}">
  $i18n{passpointDomainsLabel}
</cr-expand-button>
<div id="passpointDomainsList" class="list-frame vertical-list">
  <iron-collapse opened="[[domainsExpanded_]]">
    <template is="dom-repeat"
        items="[[getPasspointDomainsList_(subscription_)]]">
      <div id="domainName" class="list-item secondary">
        [[item]]
      </div>
    </template>
  </iron-collapse>
</div>
<!-- Removal dialog triggered by the "forget" button -->
<template is="dom-if" if="[[showForgetDialog_]]" restamp>
  <cr-dialog id="removalDialog" close-text="$i18n{close}" show-on-attach>
    <div slot="title">
      $i18nPolymer{passpointRemovalTitle}
    </div>
    <div slot="body">
      <localized-link
          localized-string="[[getRemovalDialogDescription_(subscription_)]]"
          link-url="$i18nRaw{wifiPasspointLearnMoreUrl}">
      </localized-link>
    </div>
    <div slot="button-container">
      <cr-button id="removalCancelButton" class="cancel-button"
          on-click="onRemovalDialogCancel_">
        $i18n{cancel}
      </cr-button>
      <cr-button id="removalConfirmButton" class="action-button"
          on-click="onRemovalDialogConfirm_">
        $i18n{confirm}
      </cr-button>
    </div>
  </cr-dialog>
</template>
<!--_html_template_end_-->`;
}
