import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="internet-shared settings-shared iron-flex md-select">#data-usage-wrapper{align-items:center;display:flex}#resetDayHelpTooltip{margin-inline-end:15px}</style>
<div class="settings-box single-column stretch first">
  [[i18n('TrafficCountersDataUsageDifferentFromProviderLabel')]]
</div>
<div class="settings-box single-column stretch indented first">
  <div id="data-usage-wrapper">
    <div class="start settings-box-text">
      <div id="dataUsageLabel" class="label">
        [[date_]]
      </div>
      <div id="dataUsageSubLabel" class="secondary label">
        [[value_]]
      </div>
    </div>
    <cr-button id="resetDataUsageButton"
      aria-labelledby="dataUsageLabel"
      aria-describedby="dataUsageSubLabel"
      aria-roledescription="$i18n{TrafficCountersDataUsageResetLabel}"
      on-click="onResetDataUsageClick_">
      [[i18n('TrafficCountersDataUsageResetButtonLabel')]]
    </cr-button>
  </div>
  <div id="data-usage-wrapper">
    <div class="start settings-box-text">
      <div id="daySelectionLabel" class="label">
        [[i18n('TrafficCountersDataUsageAutoResetDayOfMonthLabel')]]
      </div>
      <div id="daySelectionSubLabel" class="secondary label">
        [[i18n('TrafficCountersDataUsageAutoResetDayOfMonthSubLabel')]]
      </div>
    </div>
    <cr-tooltip-icon id="resetDayHelpTooltip"
      icon-aria-label="$i18n{TrafficCountersDataUsageResetDayTooltipA11yLabel}"
      icon-class="cr:help-outline"
      tooltip-text="[[i18n('TrafficCountersDataUsageResetDayTooltipText')]]">
    </cr-tooltip-icon>
    <select class="md-select" id="resetDayList"
      aria-labelledby="daySelectionLabel"
      aria-describedby="daySelectionSubLabel"
      on-change="onResetDaySelected_">
      <template is="dom-repeat" items="[[getDaysList_()]]" as="day">
        <option value="[[day]]" selected$="[[isSelected_(day, resetDay_)]]">
          [[day]]
        </option>
      </template>
    </select>
  </div>
</div>
<!--_html_template_end_-->`;
}
