import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="settings-shared iron-flex">:host{--section-padding:24px;--bottom-padding:20px;--cr-dialog-title-slot-padding-top:var(--section-padding);--cr-dialog-title-slot-padding-bottom:var(--section-padding);--cr-dialog-title-slot-padding-start:var(--section-padding);--cr-dialog-title-slot-padding-end:var(--section-padding);--cr-dialog-button-container-padding-horizontal:var(--section-padding);--cr-dialog-button-container-padding-bottom:var(--bottom-padding)}[slot=body]>*{margin-inline-start:5px}iron-icon{--iron-icon-fill-color:var(--cros-icon-color-prominent)}#host-device-text-container{display:flex;flex-direction:column;margin-inline-start:18px}#availability-title{color:var(--cros-text-color-secondary);margin-top:5px}#host-device-container{align-items:center;display:flex;margin-top:12px;min-height:46px}#tether-explanation,#tether-carrier-warning,#tether-description-title{margin-top:var(--cr-section-vertical-margin)}#tether-carrier-warning{font-weight:600}#tether-description-list{padding-inline-start:16px}#host-device-lost-container{color:var(--cros-text-color-alert);font-weight:500}#host-device-lost-container iron-icon{--iron-icon-fill-color:var(--cros-icon-color-alert)}</style>
<cr-dialog id="dialog" close-text="$i18n{close}">
  <div slot="title">$i18n{tetherConnectionDialogTitle}</div>
  <div slot="body">
    <span id="availability-title">
      $i18n{tetherConnectionAvailableDeviceTitle}
    </span>
    <div id="host-device-container">
      <iron-icon id="host-device-signal-strength-icon"
          icon="[[getSignalStrengthIconName_(managedProperties)]]"
          aria-label$="[[getSignalStrengthLabel_(managedProperties)]]">
      </iron-icon>
      <div id="host-device-text-container">
        <span id="host-device-text-name"
            aria-describedby="host-device-signal-strength-icon
            hostDeviceTextBattery">
          [[getDeviceName_(managedProperties)]]
        </span>
        <span id="hostDeviceTextBattery" class="secondary"
            aria-hidden="true">
          [[getBatteryPercentageString_(managedProperties)]]
        </span>
      </div>
      <div class="flex"></div>
      <div id="host-device-lost-container" hidden$="[[!outOfRange]]">
        <iron-icon icon="os-settings:alert-device-out-of-range">
        </iron-icon>
        $i18n{tetherPhoneOutOfRange}
      </div>
    </div>
    <div id="tether-explanation">
      [[getExplanation_(managedProperties)]]
    </div>
    <div id="tether-carrier-warning">
      $i18n{tetherConnectionCarrierWarning}
    </div>
    <div id="tether-description-title">
      [[getDescriptionTitle_(managedProperties)]]
    </div>
    <ul id="tether-description-list">
      <li>$i18n{tetherConnectionDescriptionMobileData}</li>
      <li>[[getBatteryDescription_(managedProperties)]]</li>
      <li hidden$="[[!shouldShowDisconnectFromWifi_(managedProperties)]]">
        $i18n{tetherConnectionDescriptionWiFi}
      </li>
    </ul>
  </div>
  <div slot="button-container">
    <cr-button class="cancel-button" on-click="onNotNowClick_">
      $i18n{tetherConnectionNotNowButton}
    </cr-button>
    <cr-button id="connectButton" class="action-button"
        on-click="onConnectClick_" disabled="[[outOfRange]]">
      $i18n{tetherConnectionConnectButton}
    </cr-button>
  </div>
</cr-dialog>
<!--_html_template_end_-->`;
}
