import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="settings-shared iron-flex iron-flex-alignment">.account-icon{background:center no-repeat;border-radius:20px;flex-shrink:0;height:40px;width:40px}#outer{margin-inline-end:var(--cr-section-padding);margin-inline-start:60px}#account-list-header{padding-bottom:1em}.account-toolbar,#remove-account-policy-indicator{margin-inline-start:1em}#add-account-policy-indicator{margin-inline-end:1em}#addAccountIcon{-webkit-mask-image:url(chrome://resources/images/add.svg);background-color:currentColor;height:24px;width:24px}#remove-account-container{align-items:center;display:flex}.error-badge{left:60%;position:relative;top:60%}.warning{color:var(--cros-text-color-alert)}:host-context([dir='rtl']) .error-badge{left:auto;right:60%}</style>

<iron-media-query query="(prefers-color-scheme: dark)"
  query-matches="{{isDarkModeActive_}}">
</iron-media-query>

<div class="settings-box first">
  <h2 class="first">
    <!-- Inner div needed to get spacing right in front of 'Learn more'. -->
    <div inner-h-t-m-l="[[i18nAdvanced('kerberosAccountsDescription')]]">
    </div>
  </h2>
</div>

<div class="settings-box first">
  <div id="account-list-header" class="flex">
    <h2>$i18n{kerberosAccountsListHeader}</h2>
  </div>
  <template is="dom-if" if="[[!addAccountsAllowed_]]">
    <cr-policy-indicator id="add-account-policy-indicator"
        indicator-type="userPolicy">
    </cr-policy-indicator>
  </template>
  <cr-button id="add-account-button" on-click="onAddAccountClick_"
      disabled="[[!addAccountsAllowed_]]"
      deep-link-focus-id$="[[Setting.kAddKerberosTicketV2]]">
    <div id="addAccountIcon" slot="prefix-icon"></div>
    $i18n{kerberosAccountsAddAccountLabel}
  </cr-button>
</div>

<div id="outer" class="layout vertical nowrap">
  <template is="dom-repeat" id="account-list" items="[[accounts_]]">
    <div class="settings-box account-list-item">

      <div class="account-icon"
          style="background-image: [[getIconImageSet_(item.pic)]]">
        <img class="error-badge" hidden$="[[item.isSignedIn]]"
            src="[[getErrorBadgeIcon_(isDarkModeActive_)]]">
      </div>

      <div class="middle two-line no-min-width">
        <div class="flex text-elide">
          <span>[[item.principalName]]</span>

          <div class="secondary signed-in" hidden$="[[!item.isSignedIn]]">
            [[i18n('kerberosAccountsSignedIn', item.validForDuration)]]
          </div>
          <div class="secondary warning signed-out"
              hidden$="[[item.isSignedIn]]">
            $i18n{kerberosAccountsSignedOut}
          </div>
        </div>
      </div>

      <div class="secondary account-toolbar active-indicator"
          hidden$="[[!item.isActive]]">
        $i18n{kerberosAccountsTicketActive}
      </div>

      <cr-button class="account-toolbar reauth-button"
          hidden$="[[item.isSignedIn]]"
          on-click="onReauthenticationClick_">
        $i18n{kerberosAccountsReauthenticationLabel}
      </cr-button>

      <template is="dom-if" if="[[item.isManaged]]">
        <cr-policy-indicator indicator-type="userPolicy"
            class="account-toolbar account-policy-indicator">
        </cr-policy-indicator>
      </template>

      <!-- Hamburger menu -->
      <cr-icon-button class="icon-more-vert more-actions"
          title="$i18n{moreActions}"
          on-click="onAccountActionsMenuButtonClick_"
          deep-link-focus-id$="[[Setting.kRemoveKerberosTicketV2]]
              [[Setting.kSetActiveKerberosTicketV2]]">
      </cr-icon-button>
    </div>
  </template>

  <div class="clear settings-box"></div>

  <cr-action-menu role-description="$i18n{menu}">
  <button class="dropdown-item" on-click="onRefreshNowClick_">
    $i18n{kerberosAccountsRefreshNowLabel}
  </button>
  <button class="dropdown-item" on-click="onSetAsActiveAccountClick_">
    $i18n{kerberosAccountsSetAsActiveAccountLabel}
  </button>
  <button class="dropdown-item" on-click="onRemoveAccountClick_"
      disabled="[[selectedAccount_.isManaged]]">
    <div id="remove-account-container">
      $i18n{kerberosAccountsRemoveAccountLabel}
      <template is="dom-if" if="[[selectedAccount_.isManaged]]">
        <cr-policy-indicator id="remove-account-policy-indicator"
            indicator-type="userPolicy">
        </cr-policy-indicator>
      </template>
    </div>
  </button>
  </cr-action-menu>
</div>

<cr-toast id="account-toast" duration="3000">
  <!-- Gets displayed with black font without div and id :-/ -->
  <div id="account-toast-label">[[accountToastText_]]</div>
</cr-toast>

<template is="dom-if" if="[[showAddAccountDialog_]]" restamp>
  <kerberos-add-account-dialog preset-account="[[selectedAccount_]]"
    on-close="onAddAccountDialogClosed_">
  </kerberos-add-account-dialog>
</template>
<!--_html_template_end_-->`;
}
