import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="settings-shared action-link">#advancedConfigDesc{align-items:center;display:flex}#advancedConfigPolicyIndicator{margin-inline-start:1em}#credentials{margin-top:16px}#credentials>*:not(:last-child){margin-bottom:var(--cr-form-field-bottom-spacing)}#general-error-container{display:flex;height:56px}#config-error-container{display:flex;height:40px;margin-top:16px}#general-error-message,#config-error-message{color:var(--settings-error-color)}iron-icon[icon='cr:error']{fill:var(--settings-error-color);margin-inline-end:8px}#rememberPasswordContainer{align-items:center;display:flex;margin-bottom:32px}#rememberPassword{margin-inline-end:1em}#kerberosDomain{color:var(--cros-text-color-primary);padding-inline-end:8px;white-space:nowrap}h3{font-size:inherit;font-weight:500;margin-block-end:12px;margin-block-start:0}</style>

<cr-dialog id="addDialog" hidden="[[showAdvancedConfig_]]">
  <div slot="title">[[title_]]</div>

  <div slot="body" spellcheck="false">
    <h3 class="start first">
      $i18n{addKerberosAccountDescription}
    </h3>

    <div id="general-error-container"
        hidden="[[!showError_(generalErrorText_)]]">
      <iron-icon id="error-icon" icon="cr:error"></iron-icon>
      <div id="general-error-message">[[generalErrorText_]]</div>
    </div>

    <div id="credentials">
      <cr-input id="username" label="$i18n{kerberosUsername}"
          value="{{username_}}" invalid="[[showError_(usernameErrorText_)]]"
          placeholder="[[computePlaceholder_(prefillDomain_)]]"
          error-message="[[usernameErrorText_]]">
          <span id ="kerberosDomain" slot="inline-suffix">
            [[computeDomain_(username_, prefillDomain_)]]
          </span>
      </cr-input>

      <cr-input id="password" type="password"
          label="$i18n{kerberosPassword}" value="{{password_}}"
          invalid="[[showError_(passwordErrorText_)]]"
          error-message="[[passwordErrorText_]]"
          on-input="onPasswordInput_">
      </cr-input>

      <div id="rememberPasswordContainer" hidden="[[isGuestMode_]]">
        <cr-checkbox id="rememberPassword"
            checked="{{rememberPasswordChecked_}}"
            disabled="[[!rememberPasswordEnabledByPolicy_]]">
          $i18n{addKerberosAccountRememberPassword}
        </cr-checkbox>
        <template is="dom-if" if="[[!rememberPasswordEnabledByPolicy_]]">
          <cr-policy-indicator id="rememberPasswordPolicyIndicator"
              indicator-type="userPolicy">
          </cr-policy-indicator>
        </template>
      </div>

      <a is="action-link" id="advancedConfigButton"
          on-click="onAdvancedConfigClick_">
        $i18n{kerberosAccountsAdvancedConfigLabel}
      </a>
    </div>
  </div>

  <div slot="button-container">
    <cr-button class="cancel-button" on-click="onCancel_" id="cancel">
      $i18n{cancel}
    </cr-button>
    <cr-button class="action-button" on-click="onAdd_"
        disabled="[[inProgress_]]">
      [[actionButtonLabel_]]
    </cr-button>
  </div>
</cr-dialog>

<template is="dom-if" if="[[showAdvancedConfig_]]" restamp>
  <cr-dialog id="advancedConfigDialog" on-close="onAdvancedConfigClose_">
    <div slot="title">$i18n{kerberosAdvancedConfigTitle}</div>

    <div slot="body">
      <h3 class="first" id="advancedConfigDesc">
        $i18n{kerberosAdvancedConfigDesc}
        <template is="dom-if" if="[[isManaged_]]">
          <cr-policy-indicator id="advancedConfigPolicyIndicator"
              indicator-type="userPolicy">
          </cr-policy-indicator>
        </template>
      </h3>

      <cr-textarea id="config" value="{{editableConfig_}}" rows=12
          spellcheck="false" disabled="[[isManaged_]]">
      </cr-textarea>

      <div id="config-error-container"
          hidden="[[!showError_(configErrorText_)]]">
        <iron-icon id="error-icon" icon="cr:error"></iron-icon>
        <div id="config-error-message">[[configErrorText_]]</div>
      </div>
    </div>

    <div slot="button-container">
      <cr-button class="cancel-button"
          on-click="onAdvancedConfigCancel_">
        $i18n{cancel}
      </cr-button>
      <cr-button class="action-button" on-click="onAdvancedConfigSave_"
          disabled="[[inProgress_]]">
        $i18n{save}
      </cr-button>
    </div>
  </cr-dialog>
</template>
<!--_html_template_end_-->`;
}
