import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="cr-hidden-style settings-shared">:host{--page-backdrop-bg-color:var(--cros-sys-surface1);background-color:var(--page-backdrop-bg-color);border-radius:20px;box-sizing:border-box;display:block;padding-bottom:16px;padding-inline-end:16px;padding-inline-start:16px;position:relative}@media (prefers-color-scheme:dark){:host{--page-backdrop-bg-color:var(--cros-sys-app_base)}}:host(:not(.showing-subpage)){padding-top:8px}:host([is-subpage-animating]){overflow:hidden}:host(.showing-subpage) page-displayer:not([active]){display:none}.banner{align-items:center;background-color:var(--cros-bg-color);border:var(--cr-hairline);border-radius:var(--cr-card-border-radius);display:flex;margin-bottom:var(--cr-section-vertical-margin);margin-top:var(--cr-section-vertical-margin)}.eol-warning-icon{align-items:center;background:rgba(var(--cros-icon-color-warning-rgb),var(--cros-second-tone-opacity));border-radius:50%;display:flex;flex:0 0 auto;height:40px;justify-content:center;margin-inline-end:var(--cr-section-padding);width:40px}.eol-warning-icon iron-icon{--iron-icon-fill-color:var(--cros-icon-color-warning);margin:0}#openInNewBrowserSettingsIcon{fill:var(--cros-link-color);margin-inline-start:0}#secondaryUserIcon{align-items:center;background:rgba(var(--cros-icon-color-prominent-rgb),var(--cros-second-tone-opacity));border-radius:50%;display:flex;flex:0 0 auto;height:40px;justify-content:center;margin-inline-end:var(--cr-section-padding);width:40px}#secondaryUserIcon iron-icon{--iron-icon-fill-color:var(--cros-icon-color-prominent);margin:0}#toggleContainer{align-items:center;color:var(--cros-text-color-primary);display:flex;font:inherit;justify-content:center;margin-bottom:0;margin-top:0;padding:0}#toggleSpacer{padding-top:33px}iron-icon{margin-inline-start:16px}</style>

<!-- Singleton element for languages data and API. -->
<settings-languages
    prefs="{{prefs}}"
    languages="{{languages_}}"
    language-helper="{{languageHelper_}}">
</settings-languages>

<div id="mainPageContainer">
  <template is="dom-if" if="[[computeShowUpdateRequiredEolBanner_(
      isShowingSubpage_, showUpdateRequiredEolBanner_)]]">
    <div id="updateRequiredEolBanner"
        class="settings-box two-line banner">
      <div class="eol-warning-icon">
        <iron-icon icon="cr20:banner-warning"></iron-icon>
      </div>
      <localized-link id="bannerText" class="start"
          localized-string="$i18n{updateRequiredEolBannerText}">
      </localized-link>
      <cr-icon-button title="$i18n{close}" id="closeUpdateRequiredEol"
          class="icon-clear" on-click="onCloseEolBannerClicked_"
          aria-describedby="bannerText">
      </cr-icon-button>
    </div>
  </template>
  <div id="secondaryUserBanner" class="settings-box two-line banner"
      hidden="[[!showSecondaryUserBanner_]]">
    <div id="secondaryUserIcon">
      <iron-icon icon="os-settings:social-group"></iron-icon>
    </div>
    <div class="flex">$i18n{secondaryUserBannerText}</div>
  </div>

  <template is="dom-if"
      if="[[shouldStampPage_(pageAvailability, SectionEnum_.kNetwork)]]"
      restamp>
    <page-displayer section="[[SectionEnum_.kNetwork]]"
        aria-label="$i18n{internetPageTitle}">
      <settings-internet-page prefs="{{prefs}}">
      </settings-internet-page>
    </page-displayer>
  </template>
  <template is="dom-if"
      if="[[shouldStampPage_(pageAvailability, SectionEnum_.kBluetooth)]]"
      restamp>
    <page-displayer section="[[SectionEnum_.kBluetooth]]"
        aria-label="$i18n{bluetoothPageTitle}">
      <os-settings-bluetooth-page prefs="{{prefs}}">
      </os-settings-bluetooth-page>
    </page-displayer>
  </template>
  <template is="dom-if"
      if="[[shouldStampPage_(pageAvailability, SectionEnum_.kMultiDevice)]]"
      restamp>
    <page-displayer section="[[SectionEnum_.kMultiDevice]]"
        aria-label="$i18n{multidevicePageTitle}">
      <settings-multidevice-page prefs="{{prefs}}">
      </settings-multidevice-page>
    </page-displayer>
  </template>
  <template is="dom-if"
      if="[[shouldStampPage_(pageAvailability, SectionEnum_.kPeople)]]"
      restamp>
    <page-displayer section="[[SectionEnum_.kPeople]]"
        aria-label="$i18n{osPeoplePageTitle}">
      <os-settings-people-page prefs="{{prefs}}">
      </os-settings-people-page>
    </page-displayer>
  </template>
  <template is="dom-if"
      if="[[shouldStampPage_(pageAvailability, SectionEnum_.kKerberos)]]"
      restamp>
    <page-displayer section="[[SectionEnum_.kKerberos]]"
        aria-label="$i18n{kerberosPageTitle}">
      <settings-kerberos-page></settings-kerberos-page>
    </page-displayer>
  </template>
  <template is="dom-if"
      if="[[shouldStampPage_(pageAvailability, SectionEnum_.kDevice)]]"
      restamp>
    <page-displayer section="[[SectionEnum_.kDevice]]"
        aria-label="$i18n{devicePageTitle}">
      <settings-device-page prefs="{{prefs}}"
          languages="[[languages_]]"
          language-helper="[[languageHelper_]]">
      </settings-device-page>
    </page-displayer>
  </template>
  <template is="dom-if"
      if="[[shouldStampPage_(pageAvailability, SectionEnum_.kPersonalization)]]"
      restamp>
    <page-displayer section="[[SectionEnum_.kPersonalization]]"
        aria-label="$i18n{personalizationPageTitle}">
      <settings-personalization-page prefs="{{prefs}}">
      </settings-personalization-page>
    </page-displayer>
  </template>
  <template is="dom-if"
      if="[[shouldStampPage_(pageAvailability, SectionEnum_.kPrivacyAndSecurity)]]"
      restamp>
    <page-displayer section="[[SectionEnum_.kPrivacyAndSecurity]]"
        aria-label="$i18n{privacyPageTitle}">
      <os-settings-privacy-page prefs="{{prefs}}">
      </os-settings-privacy-page>
    </page-displayer>
  </template>
  <template is="dom-if"
      if="[[shouldStampPage_(pageAvailability, SectionEnum_.kApps)]]"
      restamp>
    <page-displayer section="[[SectionEnum_.kApps]]"
        aria-label="$i18n{appsPageTitle}">
      <os-settings-apps-page
          prefs="{{prefs}}"
          android-apps-info="[[androidAppsInfo]]">
      </os-settings-apps-page>
    </page-displayer>
  </template>
  <template is="dom-if"
      if="[[shouldStampPage_(pageAvailability, SectionEnum_.kAccessibility)]]"
      restamp>
    <page-displayer section="[[SectionEnum_.kAccessibility]]"
        aria-label="$i18n{a11yPageTitle}">
      <os-settings-a11y-page prefs="{{prefs}}"
          languages="[[languages_]]"
          language-helper="[[languageHelper_]]">
      </os-settings-a11y-page>
    </page-displayer>
  </template>
  <template is="dom-if"
      if="[[shouldStampPage_(pageAvailability, SectionEnum_.kSystemPreferences)]]"
      restamp>
    <page-displayer section="[[SectionEnum_.kSystemPreferences]]"
        aria-label="$i18n{systemPreferencesTitle}">
      <settings-system-preferences-page prefs="{{prefs}}"
          languages="[[languages_]]"
          language-helper="[[languageHelper_]]">
      </settings-system-preferences-page>
    </page-displayer>
  </template>
  <template is="dom-if"
      if="[[shouldStampPage_(pageAvailability, SectionEnum_.kAboutChromeOs)]]"
      restamp>
    <page-displayer section="[[SectionEnum_.kAboutChromeOs]]"
        aria-label="$i18n{aboutOsPageTitle}">
      <os-about-page prefs="{{prefs}}"></os-about-page>
    </page-displayer>
  </template>
</div>
<!--_html_template_end_-->`;
}
