// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { assert } from 'chrome://resources/js/assert.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
import { Section } from '../mojom-webui/routes.mojom-webui.js';
import { getTemplate } from './page_displayer.html.js';
export class PageDisplayerElement extends PolymerElement {
    static get is() {
        return 'page-displayer';
    }
    static get template() {
        return getTemplate();
    }
    static get properties() {
        return {
            active: {
                type: Boolean,
                value: false,
                reflectToAttribute: true,
            },
            section: {
                type: Number,
                reflectToAttribute: true,
            },
            ariaLabel: String,
        };
    }
    ready() {
        super.ready();
        assert(this.section in Section, `Invalid section: ${this.section}.`);
    }
    focus() {
        // Since the focus host contains the whole page content, it should not cause
        // a scroll jump when focused.
        this.shadowRoot.getElementById('focusHost').focus({ preventScroll: true });
    }
}
customElements.define(PageDisplayerElement.is, PageDisplayerElement);
