// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { UserActionRecorder } from './mojom-webui/user_action_recorder.mojom-webui.js';
let userActionRecorder = null;
export function setUserActionRecorderForTesting(testRecorder) {
    userActionRecorder = testRecorder;
}
function getRecorder() {
    if (userActionRecorder) {
        return userActionRecorder;
    }
    userActionRecorder = UserActionRecorder.getRemote();
    return userActionRecorder;
}
export function recordPageFocus() {
    getRecorder().recordPageFocus();
}
export function recordPageBlur() {
    getRecorder().recordPageBlur();
}
export function recordClick() {
    getRecorder().recordClick();
}
export function recordNavigation() {
    getRecorder().recordNavigation();
}
export function recordSearch() {
    getRecorder().recordSearch();
}
/**
 * This function is reserved only for pref-based setting changes that have no
 * corresponding entry in `metrics_utils.ts`. This function should not be used
 * in any new code.
 */
export function recordSettingChangeForUnmappedPref() {
    getRecorder().recordSettingChange();
}
/**
 * Records when a `setting` is changed and, if applicable, its updated `value`.
 */
export function recordSettingChange(setting, value) {
    getRecorder().recordSettingChangeWithDetails(setting, value || null);
}
