// ash/webui/common/mojom/accelerator_fetcher.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { mojo } from '//resources/mojo/mojo/public/js/bindings.js';
import { AcceleratorActionSpec as ash_mojom_AcceleratorActionSpec } from './accelerator_actions.mojom-webui.js';
import { StandardAcceleratorPropertiesSpec as ash_mojom_StandardAcceleratorPropertiesSpec } from './accelerator_info.mojom-webui.js';
import { MetaKeySpec as ui_mojom_MetaKeySpec } from './meta_key.mojom-webui.js';
export class AcceleratorFetcherObserverPendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.common.mojom.AcceleratorFetcherObserver', scope);
    }
}
export class AcceleratorFetcherObserverRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(AcceleratorFetcherObserverPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    onAcceleratorsUpdated(actionId, accelerators) {
        this.proxy.sendMessage(0, AcceleratorFetcherObserver_OnAcceleratorsUpdated_ParamsSpec.$, null, [
            actionId,
            accelerators
        ], false);
    }
}
;
/**
 * An object which receives request messages for the AcceleratorFetcherObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class AcceleratorFetcherObserverReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(AcceleratorFetcherObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, AcceleratorFetcherObserver_OnAcceleratorsUpdated_ParamsSpec.$, null, impl.onAcceleratorsUpdated.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class AcceleratorFetcherObserver {
    static get $interfaceName() {
        return "ash.common.mojom.AcceleratorFetcherObserver";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new AcceleratorFetcherObserverRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the AcceleratorFetcherObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class AcceleratorFetcherObserverCallbackRouter {
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(AcceleratorFetcherObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.onAcceleratorsUpdated =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, AcceleratorFetcherObserver_OnAcceleratorsUpdated_ParamsSpec.$, null, this.onAcceleratorsUpdated.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class AcceleratorFetcherPendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.common.mojom.AcceleratorFetcher', scope);
    }
}
export class AcceleratorFetcherRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(AcceleratorFetcherPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    observeAcceleratorChanges(actionIds, observer) {
        this.proxy.sendMessage(0, AcceleratorFetcher_ObserveAcceleratorChanges_ParamsSpec.$, null, [
            actionIds,
            observer
        ], false);
    }
    getMetaKeyToDisplay() {
        return this.proxy.sendMessage(1, AcceleratorFetcher_GetMetaKeyToDisplay_ParamsSpec.$, AcceleratorFetcher_GetMetaKeyToDisplay_ResponseParamsSpec.$, [], false);
    }
}
;
/**
 * An object which receives request messages for the AcceleratorFetcher
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class AcceleratorFetcherReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(AcceleratorFetcherRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, AcceleratorFetcher_ObserveAcceleratorChanges_ParamsSpec.$, null, impl.observeAcceleratorChanges.bind(impl), false);
        this.helper_internal_.registerHandler(1, AcceleratorFetcher_GetMetaKeyToDisplay_ParamsSpec.$, AcceleratorFetcher_GetMetaKeyToDisplay_ResponseParamsSpec.$, impl.getMetaKeyToDisplay.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class AcceleratorFetcher {
    static get $interfaceName() {
        return "ash.common.mojom.AcceleratorFetcher";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new AcceleratorFetcherRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the AcceleratorFetcher
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class AcceleratorFetcherCallbackRouter {
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(AcceleratorFetcherRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.observeAcceleratorChanges =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, AcceleratorFetcher_ObserveAcceleratorChanges_ParamsSpec.$, null, this.observeAcceleratorChanges.createReceiverHandler(false /* expectsResponse */), false);
        this.getMetaKeyToDisplay =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, AcceleratorFetcher_GetMetaKeyToDisplay_ParamsSpec.$, AcceleratorFetcher_GetMetaKeyToDisplay_ResponseParamsSpec.$, this.getMetaKeyToDisplay.createReceiverHandler(true /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export const AcceleratorFetcherObserver_OnAcceleratorsUpdated_ParamsSpec = { $: {} };
export const AcceleratorFetcher_ObserveAcceleratorChanges_ParamsSpec = { $: {} };
export const AcceleratorFetcher_GetMetaKeyToDisplay_ParamsSpec = { $: {} };
export const AcceleratorFetcher_GetMetaKeyToDisplay_ResponseParamsSpec = { $: {} };
mojo.internal.Struct(AcceleratorFetcherObserver_OnAcceleratorsUpdated_ParamsSpec.$, 'AcceleratorFetcherObserver_OnAcceleratorsUpdated_Params', [
    mojo.internal.StructField('actionId', 0, 0, ash_mojom_AcceleratorActionSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('accelerators', 8, 0, mojo.internal.Array(ash_mojom_StandardAcceleratorPropertiesSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(AcceleratorFetcher_ObserveAcceleratorChanges_ParamsSpec.$, 'AcceleratorFetcher_ObserveAcceleratorChanges_Params', [
    mojo.internal.StructField('actionIds', 0, 0, mojo.internal.Array(ash_mojom_AcceleratorActionSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('observer', 8, 0, mojo.internal.InterfaceProxy(AcceleratorFetcherObserverRemote), null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(AcceleratorFetcher_GetMetaKeyToDisplay_ParamsSpec.$, 'AcceleratorFetcher_GetMetaKeyToDisplay_Params', [], [[0, 8],]);
mojo.internal.Struct(AcceleratorFetcher_GetMetaKeyToDisplay_ResponseParamsSpec.$, 'AcceleratorFetcher_GetMetaKeyToDisplay_ResponseParams', [
    mojo.internal.StructField('metaKey', 0, 0, ui_mojom_MetaKeySpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
