// chrome/browser/ui/webui/ash/settings/pages/apps/mojom/app_notification_handler.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { mojo } from '//resources/mojo/mojo/public/js/bindings.js';
import { PermissionSpec as appManagement_mojom_PermissionSpec } from '//resources/cr_components/app_management/app_management.mojom-webui.js';
export const ReadinessSpec = { $: mojo.internal.Enum() };
export var Readiness;
(function (Readiness) {
    Readiness[Readiness["MIN_VALUE"] = 0] = "MIN_VALUE";
    Readiness[Readiness["MAX_VALUE"] = 9] = "MAX_VALUE";
    Readiness[Readiness["kUnknown"] = 0] = "kUnknown";
    Readiness[Readiness["kReady"] = 1] = "kReady";
    Readiness[Readiness["kDisabledByBlocklist"] = 2] = "kDisabledByBlocklist";
    Readiness[Readiness["kDisabledByPolicy"] = 3] = "kDisabledByPolicy";
    Readiness[Readiness["kDisabledByUser"] = 4] = "kDisabledByUser";
    Readiness[Readiness["kTerminated"] = 5] = "kTerminated";
    Readiness[Readiness["kUninstalledByUser"] = 6] = "kUninstalledByUser";
    Readiness[Readiness["kRemoved"] = 7] = "kRemoved";
    Readiness[Readiness["kUninstalledByNonUser"] = 8] = "kUninstalledByNonUser";
    Readiness[Readiness["kDisabledByLocalSettings"] = 9] = "kDisabledByLocalSettings";
})(Readiness || (Readiness = {}));
export class AppNotificationsHandlerPendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.settings.app_notification.mojom.AppNotificationsHandler', scope);
    }
}
export class AppNotificationsHandlerRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(AppNotificationsHandlerPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    setQuietMode(enabled) {
        this.proxy.sendMessage(0, AppNotificationsHandler_SetQuietMode_ParamsSpec.$, null, [
            enabled
        ], false);
    }
    addObserver(observer) {
        this.proxy.sendMessage(1, AppNotificationsHandler_AddObserver_ParamsSpec.$, null, [
            observer
        ], false);
    }
    setNotificationPermission(appId, permission) {
        this.proxy.sendMessage(2, AppNotificationsHandler_SetNotificationPermission_ParamsSpec.$, null, [
            appId,
            permission
        ], false);
    }
    getApps() {
        return this.proxy.sendMessage(3, AppNotificationsHandler_GetApps_ParamsSpec.$, AppNotificationsHandler_GetApps_ResponseParamsSpec.$, [], false);
    }
    getQuietMode() {
        return this.proxy.sendMessage(4, AppNotificationsHandler_GetQuietMode_ParamsSpec.$, AppNotificationsHandler_GetQuietMode_ResponseParamsSpec.$, [], false);
    }
    openBrowserNotificationSettings() {
        this.proxy.sendMessage(5, AppNotificationsHandler_OpenBrowserNotificationSettings_ParamsSpec.$, null, [], false);
    }
}
;
/**
 * An object which receives request messages for the AppNotificationsHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class AppNotificationsHandlerReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(AppNotificationsHandlerRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, AppNotificationsHandler_SetQuietMode_ParamsSpec.$, null, impl.setQuietMode.bind(impl), false);
        this.helper_internal_.registerHandler(1, AppNotificationsHandler_AddObserver_ParamsSpec.$, null, impl.addObserver.bind(impl), false);
        this.helper_internal_.registerHandler(2, AppNotificationsHandler_SetNotificationPermission_ParamsSpec.$, null, impl.setNotificationPermission.bind(impl), false);
        this.helper_internal_.registerHandler(3, AppNotificationsHandler_GetApps_ParamsSpec.$, AppNotificationsHandler_GetApps_ResponseParamsSpec.$, impl.getApps.bind(impl), false);
        this.helper_internal_.registerHandler(4, AppNotificationsHandler_GetQuietMode_ParamsSpec.$, AppNotificationsHandler_GetQuietMode_ResponseParamsSpec.$, impl.getQuietMode.bind(impl), false);
        this.helper_internal_.registerHandler(5, AppNotificationsHandler_OpenBrowserNotificationSettings_ParamsSpec.$, null, impl.openBrowserNotificationSettings.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class AppNotificationsHandler {
    static get $interfaceName() {
        return "ash.settings.app_notification.mojom.AppNotificationsHandler";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new AppNotificationsHandlerRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the AppNotificationsHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class AppNotificationsHandlerCallbackRouter {
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(AppNotificationsHandlerRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.setQuietMode =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, AppNotificationsHandler_SetQuietMode_ParamsSpec.$, null, this.setQuietMode.createReceiverHandler(false /* expectsResponse */), false);
        this.addObserver =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, AppNotificationsHandler_AddObserver_ParamsSpec.$, null, this.addObserver.createReceiverHandler(false /* expectsResponse */), false);
        this.setNotificationPermission =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, AppNotificationsHandler_SetNotificationPermission_ParamsSpec.$, null, this.setNotificationPermission.createReceiverHandler(false /* expectsResponse */), false);
        this.getApps =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(3, AppNotificationsHandler_GetApps_ParamsSpec.$, AppNotificationsHandler_GetApps_ResponseParamsSpec.$, this.getApps.createReceiverHandler(true /* expectsResponse */), false);
        this.getQuietMode =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(4, AppNotificationsHandler_GetQuietMode_ParamsSpec.$, AppNotificationsHandler_GetQuietMode_ResponseParamsSpec.$, this.getQuietMode.createReceiverHandler(true /* expectsResponse */), false);
        this.openBrowserNotificationSettings =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(5, AppNotificationsHandler_OpenBrowserNotificationSettings_ParamsSpec.$, null, this.openBrowserNotificationSettings.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class AppNotificationsObserverPendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.settings.app_notification.mojom.AppNotificationsObserver', scope);
    }
}
export class AppNotificationsObserverRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(AppNotificationsObserverPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    onNotificationAppChanged(app) {
        this.proxy.sendMessage(0, AppNotificationsObserver_OnNotificationAppChanged_ParamsSpec.$, null, [
            app
        ], false);
    }
    onQuietModeChanged(enabled) {
        this.proxy.sendMessage(1, AppNotificationsObserver_OnQuietModeChanged_ParamsSpec.$, null, [
            enabled
        ], false);
    }
}
;
/**
 * An object which receives request messages for the AppNotificationsObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class AppNotificationsObserverReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(AppNotificationsObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, AppNotificationsObserver_OnNotificationAppChanged_ParamsSpec.$, null, impl.onNotificationAppChanged.bind(impl), false);
        this.helper_internal_.registerHandler(1, AppNotificationsObserver_OnQuietModeChanged_ParamsSpec.$, null, impl.onQuietModeChanged.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class AppNotificationsObserver {
    static get $interfaceName() {
        return "ash.settings.app_notification.mojom.AppNotificationsObserver";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new AppNotificationsObserverRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the AppNotificationsObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class AppNotificationsObserverCallbackRouter {
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(AppNotificationsObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.onNotificationAppChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, AppNotificationsObserver_OnNotificationAppChanged_ParamsSpec.$, null, this.onNotificationAppChanged.createReceiverHandler(false /* expectsResponse */), false);
        this.onQuietModeChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, AppNotificationsObserver_OnQuietModeChanged_ParamsSpec.$, null, this.onQuietModeChanged.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export const AppSpec = { $: {} };
export const AppNotificationsHandler_SetQuietMode_ParamsSpec = { $: {} };
export const AppNotificationsHandler_AddObserver_ParamsSpec = { $: {} };
export const AppNotificationsHandler_SetNotificationPermission_ParamsSpec = { $: {} };
export const AppNotificationsHandler_GetApps_ParamsSpec = { $: {} };
export const AppNotificationsHandler_GetApps_ResponseParamsSpec = { $: {} };
export const AppNotificationsHandler_GetQuietMode_ParamsSpec = { $: {} };
export const AppNotificationsHandler_GetQuietMode_ResponseParamsSpec = { $: {} };
export const AppNotificationsHandler_OpenBrowserNotificationSettings_ParamsSpec = { $: {} };
export const AppNotificationsObserver_OnNotificationAppChanged_ParamsSpec = { $: {} };
export const AppNotificationsObserver_OnQuietModeChanged_ParamsSpec = { $: {} };
mojo.internal.Struct(AppSpec.$, 'App', [
    mojo.internal.StructField('id', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('title', 8, 0, mojo.internal.String, null, true /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('readiness', 16, 0, ReadinessSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('notificationPermission', 24, 0, appManagement_mojom_PermissionSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 40],]);
mojo.internal.Struct(AppNotificationsHandler_SetQuietMode_ParamsSpec.$, 'AppNotificationsHandler_SetQuietMode_Params', [
    mojo.internal.StructField('enabled', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(AppNotificationsHandler_AddObserver_ParamsSpec.$, 'AppNotificationsHandler_AddObserver_Params', [
    mojo.internal.StructField('observer', 0, 0, mojo.internal.InterfaceProxy(AppNotificationsObserverRemote), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(AppNotificationsHandler_SetNotificationPermission_ParamsSpec.$, 'AppNotificationsHandler_SetNotificationPermission_Params', [
    mojo.internal.StructField('appId', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('permission', 8, 0, appManagement_mojom_PermissionSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(AppNotificationsHandler_GetApps_ParamsSpec.$, 'AppNotificationsHandler_GetApps_Params', [], [[0, 8],]);
mojo.internal.Struct(AppNotificationsHandler_GetApps_ResponseParamsSpec.$, 'AppNotificationsHandler_GetApps_ResponseParams', [
    mojo.internal.StructField('apps', 0, 0, mojo.internal.Array(AppSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(AppNotificationsHandler_GetQuietMode_ParamsSpec.$, 'AppNotificationsHandler_GetQuietMode_Params', [], [[0, 8],]);
mojo.internal.Struct(AppNotificationsHandler_GetQuietMode_ResponseParamsSpec.$, 'AppNotificationsHandler_GetQuietMode_ResponseParams', [
    mojo.internal.StructField('enabled', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(AppNotificationsHandler_OpenBrowserNotificationSettings_ParamsSpec.$, 'AppNotificationsHandler_OpenBrowserNotificationSettings_Params', [], [[0, 8],]);
mojo.internal.Struct(AppNotificationsObserver_OnNotificationAppChanged_ParamsSpec.$, 'AppNotificationsObserver_OnNotificationAppChanged_Params', [
    mojo.internal.StructField('app', 0, 0, AppSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(AppNotificationsObserver_OnQuietModeChanged_ParamsSpec.$, 'AppNotificationsObserver_OnQuietModeChanged_Params', [
    mojo.internal.StructField('enabled', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
