// chrome/browser/ui/webui/ash/settings/pages/apps/mojom/app_parental_controls_handler.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { mojo } from '//resources/mojo/mojo/public/js/bindings.js';
export const PinValidationResultSpec = { $: mojo.internal.Enum() };
export var PinValidationResult;
(function (PinValidationResult) {
    PinValidationResult[PinValidationResult["MIN_VALUE"] = 0] = "MIN_VALUE";
    PinValidationResult[PinValidationResult["MAX_VALUE"] = 2] = "MAX_VALUE";
    PinValidationResult[PinValidationResult["kPinValidationSuccess"] = 0] = "kPinValidationSuccess";
    PinValidationResult[PinValidationResult["kPinLengthError"] = 1] = "kPinLengthError";
    PinValidationResult[PinValidationResult["kPinNumericError"] = 2] = "kPinNumericError";
})(PinValidationResult || (PinValidationResult = {}));
export class AppParentalControlsHandlerPendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.settings.app_parental_controls.mojom.AppParentalControlsHandler', scope);
    }
}
export class AppParentalControlsHandlerRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(AppParentalControlsHandlerPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    getApps() {
        return this.proxy.sendMessage(0, AppParentalControlsHandler_GetApps_ParamsSpec.$, AppParentalControlsHandler_GetApps_ResponseParamsSpec.$, [], false);
    }
    updateApp(appId, isBlocked) {
        this.proxy.sendMessage(1, AppParentalControlsHandler_UpdateApp_ParamsSpec.$, null, [
            appId,
            isBlocked
        ], false);
    }
    addObserver(observer) {
        this.proxy.sendMessage(2, AppParentalControlsHandler_AddObserver_ParamsSpec.$, null, [
            observer
        ], false);
    }
    onControlsDisabled() {
        this.proxy.sendMessage(3, AppParentalControlsHandler_OnControlsDisabled_ParamsSpec.$, null, [], false);
    }
    validatePin(pin) {
        return this.proxy.sendMessage(4, AppParentalControlsHandler_ValidatePin_ParamsSpec.$, AppParentalControlsHandler_ValidatePin_ResponseParamsSpec.$, [
            pin
        ], false);
    }
    setUpPin(pin) {
        return this.proxy.sendMessage(5, AppParentalControlsHandler_SetUpPin_ParamsSpec.$, AppParentalControlsHandler_SetUpPin_ResponseParamsSpec.$, [
            pin
        ], false);
    }
    verifyPin(pin) {
        return this.proxy.sendMessage(6, AppParentalControlsHandler_VerifyPin_ParamsSpec.$, AppParentalControlsHandler_VerifyPin_ResponseParamsSpec.$, [
            pin
        ], false);
    }
    isSetupCompleted() {
        return this.proxy.sendMessage(7, AppParentalControlsHandler_IsSetupCompleted_ParamsSpec.$, AppParentalControlsHandler_IsSetupCompleted_ResponseParamsSpec.$, [], false);
    }
}
;
/**
 * An object which receives request messages for the AppParentalControlsHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class AppParentalControlsHandlerReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(AppParentalControlsHandlerRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, AppParentalControlsHandler_GetApps_ParamsSpec.$, AppParentalControlsHandler_GetApps_ResponseParamsSpec.$, impl.getApps.bind(impl), false);
        this.helper_internal_.registerHandler(1, AppParentalControlsHandler_UpdateApp_ParamsSpec.$, null, impl.updateApp.bind(impl), false);
        this.helper_internal_.registerHandler(2, AppParentalControlsHandler_AddObserver_ParamsSpec.$, null, impl.addObserver.bind(impl), false);
        this.helper_internal_.registerHandler(3, AppParentalControlsHandler_OnControlsDisabled_ParamsSpec.$, null, impl.onControlsDisabled.bind(impl), false);
        this.helper_internal_.registerHandler(4, AppParentalControlsHandler_ValidatePin_ParamsSpec.$, AppParentalControlsHandler_ValidatePin_ResponseParamsSpec.$, impl.validatePin.bind(impl), false);
        this.helper_internal_.registerHandler(5, AppParentalControlsHandler_SetUpPin_ParamsSpec.$, AppParentalControlsHandler_SetUpPin_ResponseParamsSpec.$, impl.setUpPin.bind(impl), false);
        this.helper_internal_.registerHandler(6, AppParentalControlsHandler_VerifyPin_ParamsSpec.$, AppParentalControlsHandler_VerifyPin_ResponseParamsSpec.$, impl.verifyPin.bind(impl), false);
        this.helper_internal_.registerHandler(7, AppParentalControlsHandler_IsSetupCompleted_ParamsSpec.$, AppParentalControlsHandler_IsSetupCompleted_ResponseParamsSpec.$, impl.isSetupCompleted.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class AppParentalControlsHandler {
    static get $interfaceName() {
        return "ash.settings.app_parental_controls.mojom.AppParentalControlsHandler";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new AppParentalControlsHandlerRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the AppParentalControlsHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class AppParentalControlsHandlerCallbackRouter {
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(AppParentalControlsHandlerRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.getApps =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, AppParentalControlsHandler_GetApps_ParamsSpec.$, AppParentalControlsHandler_GetApps_ResponseParamsSpec.$, this.getApps.createReceiverHandler(true /* expectsResponse */), false);
        this.updateApp =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, AppParentalControlsHandler_UpdateApp_ParamsSpec.$, null, this.updateApp.createReceiverHandler(false /* expectsResponse */), false);
        this.addObserver =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, AppParentalControlsHandler_AddObserver_ParamsSpec.$, null, this.addObserver.createReceiverHandler(false /* expectsResponse */), false);
        this.onControlsDisabled =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(3, AppParentalControlsHandler_OnControlsDisabled_ParamsSpec.$, null, this.onControlsDisabled.createReceiverHandler(false /* expectsResponse */), false);
        this.validatePin =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(4, AppParentalControlsHandler_ValidatePin_ParamsSpec.$, AppParentalControlsHandler_ValidatePin_ResponseParamsSpec.$, this.validatePin.createReceiverHandler(true /* expectsResponse */), false);
        this.setUpPin =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(5, AppParentalControlsHandler_SetUpPin_ParamsSpec.$, AppParentalControlsHandler_SetUpPin_ResponseParamsSpec.$, this.setUpPin.createReceiverHandler(true /* expectsResponse */), false);
        this.verifyPin =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(6, AppParentalControlsHandler_VerifyPin_ParamsSpec.$, AppParentalControlsHandler_VerifyPin_ResponseParamsSpec.$, this.verifyPin.createReceiverHandler(true /* expectsResponse */), false);
        this.isSetupCompleted =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(7, AppParentalControlsHandler_IsSetupCompleted_ParamsSpec.$, AppParentalControlsHandler_IsSetupCompleted_ResponseParamsSpec.$, this.isSetupCompleted.createReceiverHandler(true /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class AppParentalControlsObserverPendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.settings.app_parental_controls.mojom.AppParentalControlsObserver', scope);
    }
}
export class AppParentalControlsObserverRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(AppParentalControlsObserverPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    onAppInstalledOrUpdated(app) {
        this.proxy.sendMessage(0, AppParentalControlsObserver_OnAppInstalledOrUpdated_ParamsSpec.$, null, [
            app
        ], false);
    }
    onAppUninstalled(app) {
        this.proxy.sendMessage(1, AppParentalControlsObserver_OnAppUninstalled_ParamsSpec.$, null, [
            app
        ], false);
    }
}
;
/**
 * An object which receives request messages for the AppParentalControlsObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class AppParentalControlsObserverReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(AppParentalControlsObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, AppParentalControlsObserver_OnAppInstalledOrUpdated_ParamsSpec.$, null, impl.onAppInstalledOrUpdated.bind(impl), false);
        this.helper_internal_.registerHandler(1, AppParentalControlsObserver_OnAppUninstalled_ParamsSpec.$, null, impl.onAppUninstalled.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class AppParentalControlsObserver {
    static get $interfaceName() {
        return "ash.settings.app_parental_controls.mojom.AppParentalControlsObserver";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new AppParentalControlsObserverRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the AppParentalControlsObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class AppParentalControlsObserverCallbackRouter {
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(AppParentalControlsObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.onAppInstalledOrUpdated =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, AppParentalControlsObserver_OnAppInstalledOrUpdated_ParamsSpec.$, null, this.onAppInstalledOrUpdated.createReceiverHandler(false /* expectsResponse */), false);
        this.onAppUninstalled =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, AppParentalControlsObserver_OnAppUninstalled_ParamsSpec.$, null, this.onAppUninstalled.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export const AppSpec = { $: {} };
export const AppParentalControlsHandler_GetApps_ParamsSpec = { $: {} };
export const AppParentalControlsHandler_GetApps_ResponseParamsSpec = { $: {} };
export const AppParentalControlsHandler_UpdateApp_ParamsSpec = { $: {} };
export const AppParentalControlsHandler_AddObserver_ParamsSpec = { $: {} };
export const AppParentalControlsHandler_OnControlsDisabled_ParamsSpec = { $: {} };
export const AppParentalControlsHandler_ValidatePin_ParamsSpec = { $: {} };
export const AppParentalControlsHandler_ValidatePin_ResponseParamsSpec = { $: {} };
export const AppParentalControlsHandler_SetUpPin_ParamsSpec = { $: {} };
export const AppParentalControlsHandler_SetUpPin_ResponseParamsSpec = { $: {} };
export const AppParentalControlsHandler_VerifyPin_ParamsSpec = { $: {} };
export const AppParentalControlsHandler_VerifyPin_ResponseParamsSpec = { $: {} };
export const AppParentalControlsHandler_IsSetupCompleted_ParamsSpec = { $: {} };
export const AppParentalControlsHandler_IsSetupCompleted_ResponseParamsSpec = { $: {} };
export const AppParentalControlsObserver_OnAppInstalledOrUpdated_ParamsSpec = { $: {} };
export const AppParentalControlsObserver_OnAppUninstalled_ParamsSpec = { $: {} };
mojo.internal.Struct(AppSpec.$, 'App', [
    mojo.internal.StructField('id', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('title', 8, 0, mojo.internal.String, null, true /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('isBlocked', 16, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 32],]);
mojo.internal.Struct(AppParentalControlsHandler_GetApps_ParamsSpec.$, 'AppParentalControlsHandler_GetApps_Params', [], [[0, 8],]);
mojo.internal.Struct(AppParentalControlsHandler_GetApps_ResponseParamsSpec.$, 'AppParentalControlsHandler_GetApps_ResponseParams', [
    mojo.internal.StructField('apps', 0, 0, mojo.internal.Array(AppSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(AppParentalControlsHandler_UpdateApp_ParamsSpec.$, 'AppParentalControlsHandler_UpdateApp_Params', [
    mojo.internal.StructField('appId', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('isBlocked', 8, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(AppParentalControlsHandler_AddObserver_ParamsSpec.$, 'AppParentalControlsHandler_AddObserver_Params', [
    mojo.internal.StructField('observer', 0, 0, mojo.internal.InterfaceProxy(AppParentalControlsObserverRemote), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(AppParentalControlsHandler_OnControlsDisabled_ParamsSpec.$, 'AppParentalControlsHandler_OnControlsDisabled_Params', [], [[0, 8],]);
mojo.internal.Struct(AppParentalControlsHandler_ValidatePin_ParamsSpec.$, 'AppParentalControlsHandler_ValidatePin_Params', [
    mojo.internal.StructField('pin', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(AppParentalControlsHandler_ValidatePin_ResponseParamsSpec.$, 'AppParentalControlsHandler_ValidatePin_ResponseParams', [
    mojo.internal.StructField('result', 0, 0, PinValidationResultSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(AppParentalControlsHandler_SetUpPin_ParamsSpec.$, 'AppParentalControlsHandler_SetUpPin_Params', [
    mojo.internal.StructField('pin', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(AppParentalControlsHandler_SetUpPin_ResponseParamsSpec.$, 'AppParentalControlsHandler_SetUpPin_ResponseParams', [
    mojo.internal.StructField('isSuccess', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(AppParentalControlsHandler_VerifyPin_ParamsSpec.$, 'AppParentalControlsHandler_VerifyPin_Params', [
    mojo.internal.StructField('pin', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(AppParentalControlsHandler_VerifyPin_ResponseParamsSpec.$, 'AppParentalControlsHandler_VerifyPin_ResponseParams', [
    mojo.internal.StructField('isSuccess', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(AppParentalControlsHandler_IsSetupCompleted_ParamsSpec.$, 'AppParentalControlsHandler_IsSetupCompleted_Params', [], [[0, 8],]);
mojo.internal.Struct(AppParentalControlsHandler_IsSetupCompleted_ResponseParamsSpec.$, 'AppParentalControlsHandler_IsSetupCompleted_ResponseParams', [
    mojo.internal.StructField('isCompleted', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(AppParentalControlsObserver_OnAppInstalledOrUpdated_ParamsSpec.$, 'AppParentalControlsObserver_OnAppInstalledOrUpdated_Params', [
    mojo.internal.StructField('app', 0, 0, AppSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(AppParentalControlsObserver_OnAppUninstalled_ParamsSpec.$, 'AppParentalControlsObserver_OnAppUninstalled_Params', [
    mojo.internal.StructField('app', 0, 0, AppSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
