// chrome/browser/ui/webui/ash/settings/pages/privacy/mojom/app_permission_handler.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { mojo } from '//resources/mojo/mojo/public/js/bindings.js';
import { AppTypeSpec as appManagement_mojom_AppTypeSpec, PermissionTypeSpec as appManagement_mojom_PermissionTypeSpec, PermissionSpec as appManagement_mojom_PermissionSpec } from '//resources/cr_components/app_management/app_management.mojom-webui.js';
export class AppPermissionsHandlerPendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.settings.app_permission.mojom.AppPermissionsHandler', scope);
    }
}
export class AppPermissionsHandlerRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(AppPermissionsHandlerPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    addObserver(observer) {
        this.proxy.sendMessage(0, AppPermissionsHandler_AddObserver_ParamsSpec.$, null, [
            observer
        ], false);
    }
    getApps() {
        return this.proxy.sendMessage(1, AppPermissionsHandler_GetApps_ParamsSpec.$, AppPermissionsHandler_GetApps_ResponseParamsSpec.$, [], false);
    }
    getSystemAppsThatUseCamera() {
        return this.proxy.sendMessage(2, AppPermissionsHandler_GetSystemAppsThatUseCamera_ParamsSpec.$, AppPermissionsHandler_GetSystemAppsThatUseCamera_ResponseParamsSpec.$, [], false);
    }
    getSystemAppsThatUseMicrophone() {
        return this.proxy.sendMessage(3, AppPermissionsHandler_GetSystemAppsThatUseMicrophone_ParamsSpec.$, AppPermissionsHandler_GetSystemAppsThatUseMicrophone_ResponseParamsSpec.$, [], false);
    }
    openBrowserPermissionSettings(permissionType) {
        this.proxy.sendMessage(4, AppPermissionsHandler_OpenBrowserPermissionSettings_ParamsSpec.$, null, [
            permissionType
        ], false);
    }
    openNativeSettings(appId) {
        this.proxy.sendMessage(5, AppPermissionsHandler_OpenNativeSettings_ParamsSpec.$, null, [
            appId
        ], false);
    }
    setPermission(appId, permission) {
        this.proxy.sendMessage(6, AppPermissionsHandler_SetPermission_ParamsSpec.$, null, [
            appId,
            permission
        ], false);
    }
}
;
/**
 * An object which receives request messages for the AppPermissionsHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class AppPermissionsHandlerReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(AppPermissionsHandlerRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, AppPermissionsHandler_AddObserver_ParamsSpec.$, null, impl.addObserver.bind(impl), false);
        this.helper_internal_.registerHandler(1, AppPermissionsHandler_GetApps_ParamsSpec.$, AppPermissionsHandler_GetApps_ResponseParamsSpec.$, impl.getApps.bind(impl), false);
        this.helper_internal_.registerHandler(2, AppPermissionsHandler_GetSystemAppsThatUseCamera_ParamsSpec.$, AppPermissionsHandler_GetSystemAppsThatUseCamera_ResponseParamsSpec.$, impl.getSystemAppsThatUseCamera.bind(impl), false);
        this.helper_internal_.registerHandler(3, AppPermissionsHandler_GetSystemAppsThatUseMicrophone_ParamsSpec.$, AppPermissionsHandler_GetSystemAppsThatUseMicrophone_ResponseParamsSpec.$, impl.getSystemAppsThatUseMicrophone.bind(impl), false);
        this.helper_internal_.registerHandler(4, AppPermissionsHandler_OpenBrowserPermissionSettings_ParamsSpec.$, null, impl.openBrowserPermissionSettings.bind(impl), false);
        this.helper_internal_.registerHandler(5, AppPermissionsHandler_OpenNativeSettings_ParamsSpec.$, null, impl.openNativeSettings.bind(impl), false);
        this.helper_internal_.registerHandler(6, AppPermissionsHandler_SetPermission_ParamsSpec.$, null, impl.setPermission.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class AppPermissionsHandler {
    static get $interfaceName() {
        return "ash.settings.app_permission.mojom.AppPermissionsHandler";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new AppPermissionsHandlerRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the AppPermissionsHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class AppPermissionsHandlerCallbackRouter {
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(AppPermissionsHandlerRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.addObserver =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, AppPermissionsHandler_AddObserver_ParamsSpec.$, null, this.addObserver.createReceiverHandler(false /* expectsResponse */), false);
        this.getApps =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, AppPermissionsHandler_GetApps_ParamsSpec.$, AppPermissionsHandler_GetApps_ResponseParamsSpec.$, this.getApps.createReceiverHandler(true /* expectsResponse */), false);
        this.getSystemAppsThatUseCamera =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, AppPermissionsHandler_GetSystemAppsThatUseCamera_ParamsSpec.$, AppPermissionsHandler_GetSystemAppsThatUseCamera_ResponseParamsSpec.$, this.getSystemAppsThatUseCamera.createReceiverHandler(true /* expectsResponse */), false);
        this.getSystemAppsThatUseMicrophone =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(3, AppPermissionsHandler_GetSystemAppsThatUseMicrophone_ParamsSpec.$, AppPermissionsHandler_GetSystemAppsThatUseMicrophone_ResponseParamsSpec.$, this.getSystemAppsThatUseMicrophone.createReceiverHandler(true /* expectsResponse */), false);
        this.openBrowserPermissionSettings =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(4, AppPermissionsHandler_OpenBrowserPermissionSettings_ParamsSpec.$, null, this.openBrowserPermissionSettings.createReceiverHandler(false /* expectsResponse */), false);
        this.openNativeSettings =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(5, AppPermissionsHandler_OpenNativeSettings_ParamsSpec.$, null, this.openNativeSettings.createReceiverHandler(false /* expectsResponse */), false);
        this.setPermission =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(6, AppPermissionsHandler_SetPermission_ParamsSpec.$, null, this.setPermission.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class AppPermissionsObserverPendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.settings.app_permission.mojom.AppPermissionsObserver', scope);
    }
}
export class AppPermissionsObserverRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(AppPermissionsObserverPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    onAppRemoved(appId) {
        this.proxy.sendMessage(0, AppPermissionsObserver_OnAppRemoved_ParamsSpec.$, null, [
            appId
        ], false);
    }
    onAppUpdated(app) {
        this.proxy.sendMessage(1, AppPermissionsObserver_OnAppUpdated_ParamsSpec.$, null, [
            app
        ], false);
    }
}
;
/**
 * An object which receives request messages for the AppPermissionsObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class AppPermissionsObserverReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(AppPermissionsObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, AppPermissionsObserver_OnAppRemoved_ParamsSpec.$, null, impl.onAppRemoved.bind(impl), false);
        this.helper_internal_.registerHandler(1, AppPermissionsObserver_OnAppUpdated_ParamsSpec.$, null, impl.onAppUpdated.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class AppPermissionsObserver {
    static get $interfaceName() {
        return "ash.settings.app_permission.mojom.AppPermissionsObserver";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new AppPermissionsObserverRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the AppPermissionsObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class AppPermissionsObserverCallbackRouter {
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(AppPermissionsObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.onAppRemoved =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, AppPermissionsObserver_OnAppRemoved_ParamsSpec.$, null, this.onAppRemoved.createReceiverHandler(false /* expectsResponse */), false);
        this.onAppUpdated =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, AppPermissionsObserver_OnAppUpdated_ParamsSpec.$, null, this.onAppUpdated.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export const AppSpec = { $: {} };
export const AppPermissionsHandler_AddObserver_ParamsSpec = { $: {} };
export const AppPermissionsHandler_GetApps_ParamsSpec = { $: {} };
export const AppPermissionsHandler_GetApps_ResponseParamsSpec = { $: {} };
export const AppPermissionsHandler_GetSystemAppsThatUseCamera_ParamsSpec = { $: {} };
export const AppPermissionsHandler_GetSystemAppsThatUseCamera_ResponseParamsSpec = { $: {} };
export const AppPermissionsHandler_GetSystemAppsThatUseMicrophone_ParamsSpec = { $: {} };
export const AppPermissionsHandler_GetSystemAppsThatUseMicrophone_ResponseParamsSpec = { $: {} };
export const AppPermissionsHandler_OpenBrowserPermissionSettings_ParamsSpec = { $: {} };
export const AppPermissionsHandler_OpenNativeSettings_ParamsSpec = { $: {} };
export const AppPermissionsHandler_SetPermission_ParamsSpec = { $: {} };
export const AppPermissionsObserver_OnAppRemoved_ParamsSpec = { $: {} };
export const AppPermissionsObserver_OnAppUpdated_ParamsSpec = { $: {} };
mojo.internal.Struct(AppSpec.$, 'App', [
    mojo.internal.StructField('id', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('name', 8, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('type', 16, 0, appManagement_mojom_AppTypeSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('permissions', 24, 0, mojo.internal.Map(appManagement_mojom_PermissionTypeSpec.$, appManagement_mojom_PermissionSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 40],]);
mojo.internal.Struct(AppPermissionsHandler_AddObserver_ParamsSpec.$, 'AppPermissionsHandler_AddObserver_Params', [
    mojo.internal.StructField('observer', 0, 0, mojo.internal.InterfaceProxy(AppPermissionsObserverRemote), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(AppPermissionsHandler_GetApps_ParamsSpec.$, 'AppPermissionsHandler_GetApps_Params', [], [[0, 8],]);
mojo.internal.Struct(AppPermissionsHandler_GetApps_ResponseParamsSpec.$, 'AppPermissionsHandler_GetApps_ResponseParams', [
    mojo.internal.StructField('apps', 0, 0, mojo.internal.Array(AppSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(AppPermissionsHandler_GetSystemAppsThatUseCamera_ParamsSpec.$, 'AppPermissionsHandler_GetSystemAppsThatUseCamera_Params', [], [[0, 8],]);
mojo.internal.Struct(AppPermissionsHandler_GetSystemAppsThatUseCamera_ResponseParamsSpec.$, 'AppPermissionsHandler_GetSystemAppsThatUseCamera_ResponseParams', [
    mojo.internal.StructField('apps', 0, 0, mojo.internal.Array(AppSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(AppPermissionsHandler_GetSystemAppsThatUseMicrophone_ParamsSpec.$, 'AppPermissionsHandler_GetSystemAppsThatUseMicrophone_Params', [], [[0, 8],]);
mojo.internal.Struct(AppPermissionsHandler_GetSystemAppsThatUseMicrophone_ResponseParamsSpec.$, 'AppPermissionsHandler_GetSystemAppsThatUseMicrophone_ResponseParams', [
    mojo.internal.StructField('apps', 0, 0, mojo.internal.Array(AppSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(AppPermissionsHandler_OpenBrowserPermissionSettings_ParamsSpec.$, 'AppPermissionsHandler_OpenBrowserPermissionSettings_Params', [
    mojo.internal.StructField('permissionType', 0, 0, appManagement_mojom_PermissionTypeSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(AppPermissionsHandler_OpenNativeSettings_ParamsSpec.$, 'AppPermissionsHandler_OpenNativeSettings_Params', [
    mojo.internal.StructField('appId', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(AppPermissionsHandler_SetPermission_ParamsSpec.$, 'AppPermissionsHandler_SetPermission_Params', [
    mojo.internal.StructField('appId', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('permission', 8, 0, appManagement_mojom_PermissionSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(AppPermissionsObserver_OnAppRemoved_ParamsSpec.$, 'AppPermissionsObserver_OnAppRemoved_Params', [
    mojo.internal.StructField('appId', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(AppPermissionsObserver_OnAppUpdated_ParamsSpec.$, 'AppPermissionsObserver_OnAppUpdated_Params', [
    mojo.internal.StructField('app', 0, 0, AppSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
