// chromeos/ash/components/audio/public/mojom/cros_audio_config.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { mojo } from '//resources/mojo/mojo/public/js/bindings.js';
export const AudioDeviceTypeSpec = { $: mojo.internal.Enum() };
export var AudioDeviceType;
(function (AudioDeviceType) {
    AudioDeviceType[AudioDeviceType["MIN_VALUE"] = 0] = "MIN_VALUE";
    AudioDeviceType[AudioDeviceType["MAX_VALUE"] = 16] = "MAX_VALUE";
    AudioDeviceType[AudioDeviceType["kHeadphone"] = 0] = "kHeadphone";
    AudioDeviceType[AudioDeviceType["kMic"] = 1] = "kMic";
    AudioDeviceType[AudioDeviceType["kUsb"] = 2] = "kUsb";
    AudioDeviceType[AudioDeviceType["kBluetooth"] = 3] = "kBluetooth";
    AudioDeviceType[AudioDeviceType["kBluetoothNbMic"] = 4] = "kBluetoothNbMic";
    AudioDeviceType[AudioDeviceType["kHdmi"] = 5] = "kHdmi";
    AudioDeviceType[AudioDeviceType["kInternalSpeaker"] = 6] = "kInternalSpeaker";
    AudioDeviceType[AudioDeviceType["kInternalMic"] = 7] = "kInternalMic";
    AudioDeviceType[AudioDeviceType["kFrontMic"] = 8] = "kFrontMic";
    AudioDeviceType[AudioDeviceType["kRearMic"] = 9] = "kRearMic";
    AudioDeviceType[AudioDeviceType["kKeyboardMic"] = 10] = "kKeyboardMic";
    AudioDeviceType[AudioDeviceType["kHotword"] = 11] = "kHotword";
    AudioDeviceType[AudioDeviceType["kPostDspLoopback"] = 12] = "kPostDspLoopback";
    AudioDeviceType[AudioDeviceType["kPostMixLoopback"] = 13] = "kPostMixLoopback";
    AudioDeviceType[AudioDeviceType["kLineout"] = 14] = "kLineout";
    AudioDeviceType[AudioDeviceType["kAlsaLoopback"] = 15] = "kAlsaLoopback";
    AudioDeviceType[AudioDeviceType["kOther"] = 16] = "kOther";
})(AudioDeviceType || (AudioDeviceType = {}));
export const AudioEffectStateSpec = { $: mojo.internal.Enum() };
export var AudioEffectState;
(function (AudioEffectState) {
    AudioEffectState[AudioEffectState["MIN_VALUE"] = 0] = "MIN_VALUE";
    AudioEffectState[AudioEffectState["MAX_VALUE"] = 2] = "MAX_VALUE";
    AudioEffectState[AudioEffectState["kNotSupported"] = 0] = "kNotSupported";
    AudioEffectState[AudioEffectState["kNotEnabled"] = 1] = "kNotEnabled";
    AudioEffectState[AudioEffectState["kEnabled"] = 2] = "kEnabled";
})(AudioEffectState || (AudioEffectState = {}));
export const MuteStateSpec = { $: mojo.internal.Enum() };
export var MuteState;
(function (MuteState) {
    MuteState[MuteState["MIN_VALUE"] = 0] = "MIN_VALUE";
    MuteState[MuteState["MAX_VALUE"] = 3] = "MAX_VALUE";
    MuteState[MuteState["kNotMuted"] = 0] = "kNotMuted";
    MuteState[MuteState["kMutedByUser"] = 1] = "kMutedByUser";
    MuteState[MuteState["kMutedByPolicy"] = 2] = "kMutedByPolicy";
    MuteState[MuteState["kMutedExternally"] = 3] = "kMutedExternally";
})(MuteState || (MuteState = {}));
export const AudioEffectTypeSpec = { $: mojo.internal.Enum() };
export var AudioEffectType;
(function (AudioEffectType) {
    AudioEffectType[AudioEffectType["MIN_VALUE"] = 0] = "MIN_VALUE";
    AudioEffectType[AudioEffectType["MAX_VALUE"] = 8] = "MAX_VALUE";
    AudioEffectType[AudioEffectType["kNone"] = 0] = "kNone";
    AudioEffectType[AudioEffectType["kNoiseCancellation"] = 1] = "kNoiseCancellation";
    AudioEffectType[AudioEffectType["kHfpMicSr"] = 2] = "kHfpMicSr";
    AudioEffectType[AudioEffectType["kStyleTransfer"] = 4] = "kStyleTransfer";
    AudioEffectType[AudioEffectType["kBeamforming"] = 8] = "kBeamforming";
})(AudioEffectType || (AudioEffectType = {}));
export class AudioSystemPropertiesObserverPendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.audio_config.mojom.AudioSystemPropertiesObserver', scope);
    }
}
export class AudioSystemPropertiesObserverRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(AudioSystemPropertiesObserverPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    onPropertiesUpdated(properties) {
        this.proxy.sendMessage(0, AudioSystemPropertiesObserver_OnPropertiesUpdated_ParamsSpec.$, null, [
            properties
        ], false);
    }
}
;
/**
 * An object which receives request messages for the AudioSystemPropertiesObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class AudioSystemPropertiesObserverReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(AudioSystemPropertiesObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, AudioSystemPropertiesObserver_OnPropertiesUpdated_ParamsSpec.$, null, impl.onPropertiesUpdated.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class AudioSystemPropertiesObserver {
    static get $interfaceName() {
        return "ash.audio_config.mojom.AudioSystemPropertiesObserver";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new AudioSystemPropertiesObserverRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the AudioSystemPropertiesObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class AudioSystemPropertiesObserverCallbackRouter {
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(AudioSystemPropertiesObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.onPropertiesUpdated =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, AudioSystemPropertiesObserver_OnPropertiesUpdated_ParamsSpec.$, null, this.onPropertiesUpdated.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class CrosAudioConfigPendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.audio_config.mojom.CrosAudioConfig', scope);
    }
}
export class CrosAudioConfigRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(CrosAudioConfigPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    observeAudioSystemProperties(observer) {
        this.proxy.sendMessage(0, CrosAudioConfig_ObserveAudioSystemProperties_ParamsSpec.$, null, [
            observer
        ], false);
    }
    setOutputMuted(muted) {
        this.proxy.sendMessage(1, CrosAudioConfig_SetOutputMuted_ParamsSpec.$, null, [
            muted
        ], false);
    }
    setOutputVolumePercent(volume) {
        this.proxy.sendMessage(2, CrosAudioConfig_SetOutputVolumePercent_ParamsSpec.$, null, [
            volume
        ], false);
    }
    setInputGainPercent(gain) {
        this.proxy.sendMessage(3, CrosAudioConfig_SetInputGainPercent_ParamsSpec.$, null, [
            gain
        ], false);
    }
    setActiveDevice(device) {
        this.proxy.sendMessage(4, CrosAudioConfig_SetActiveDevice_ParamsSpec.$, null, [
            device
        ], false);
    }
    setInputMuted(muted) {
        this.proxy.sendMessage(5, CrosAudioConfig_SetInputMuted_ParamsSpec.$, null, [
            muted
        ], false);
    }
    recordVoiceIsolationEnabledChange() {
        this.proxy.sendMessage(6, CrosAudioConfig_RecordVoiceIsolationEnabledChange_ParamsSpec.$, null, [], false);
    }
    recordVoiceIsolationPreferredEffectChange(preferredEffect) {
        this.proxy.sendMessage(7, CrosAudioConfig_RecordVoiceIsolationPreferredEffectChange_ParamsSpec.$, null, [
            preferredEffect
        ], false);
    }
    setNoiseCancellationEnabled(enabled) {
        this.proxy.sendMessage(8, CrosAudioConfig_SetNoiseCancellationEnabled_ParamsSpec.$, null, [
            enabled
        ], false);
    }
    setStyleTransferEnabled(enabled) {
        this.proxy.sendMessage(9, CrosAudioConfig_SetStyleTransferEnabled_ParamsSpec.$, null, [
            enabled
        ], false);
    }
    setForceRespectUiGainsEnabled(enabled) {
        this.proxy.sendMessage(10, CrosAudioConfig_SetForceRespectUiGainsEnabled_ParamsSpec.$, null, [
            enabled
        ], false);
    }
    setHfpMicSrEnabled(enabled) {
        this.proxy.sendMessage(11, CrosAudioConfig_SetHfpMicSrEnabled_ParamsSpec.$, null, [
            enabled
        ], false);
    }
    setSpatialAudioEnabled(enabled) {
        this.proxy.sendMessage(12, CrosAudioConfig_SetSpatialAudioEnabled_ParamsSpec.$, null, [
            enabled
        ], false);
    }
}
;
/**
 * An object which receives request messages for the CrosAudioConfig
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class CrosAudioConfigReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(CrosAudioConfigRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, CrosAudioConfig_ObserveAudioSystemProperties_ParamsSpec.$, null, impl.observeAudioSystemProperties.bind(impl), false);
        this.helper_internal_.registerHandler(1, CrosAudioConfig_SetOutputMuted_ParamsSpec.$, null, impl.setOutputMuted.bind(impl), false);
        this.helper_internal_.registerHandler(2, CrosAudioConfig_SetOutputVolumePercent_ParamsSpec.$, null, impl.setOutputVolumePercent.bind(impl), false);
        this.helper_internal_.registerHandler(3, CrosAudioConfig_SetInputGainPercent_ParamsSpec.$, null, impl.setInputGainPercent.bind(impl), false);
        this.helper_internal_.registerHandler(4, CrosAudioConfig_SetActiveDevice_ParamsSpec.$, null, impl.setActiveDevice.bind(impl), false);
        this.helper_internal_.registerHandler(5, CrosAudioConfig_SetInputMuted_ParamsSpec.$, null, impl.setInputMuted.bind(impl), false);
        this.helper_internal_.registerHandler(6, CrosAudioConfig_RecordVoiceIsolationEnabledChange_ParamsSpec.$, null, impl.recordVoiceIsolationEnabledChange.bind(impl), false);
        this.helper_internal_.registerHandler(7, CrosAudioConfig_RecordVoiceIsolationPreferredEffectChange_ParamsSpec.$, null, impl.recordVoiceIsolationPreferredEffectChange.bind(impl), false);
        this.helper_internal_.registerHandler(8, CrosAudioConfig_SetNoiseCancellationEnabled_ParamsSpec.$, null, impl.setNoiseCancellationEnabled.bind(impl), false);
        this.helper_internal_.registerHandler(9, CrosAudioConfig_SetStyleTransferEnabled_ParamsSpec.$, null, impl.setStyleTransferEnabled.bind(impl), false);
        this.helper_internal_.registerHandler(10, CrosAudioConfig_SetForceRespectUiGainsEnabled_ParamsSpec.$, null, impl.setForceRespectUiGainsEnabled.bind(impl), false);
        this.helper_internal_.registerHandler(11, CrosAudioConfig_SetHfpMicSrEnabled_ParamsSpec.$, null, impl.setHfpMicSrEnabled.bind(impl), false);
        this.helper_internal_.registerHandler(12, CrosAudioConfig_SetSpatialAudioEnabled_ParamsSpec.$, null, impl.setSpatialAudioEnabled.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class CrosAudioConfig {
    static get $interfaceName() {
        return "ash.audio_config.mojom.CrosAudioConfig";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new CrosAudioConfigRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the CrosAudioConfig
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class CrosAudioConfigCallbackRouter {
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(CrosAudioConfigRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.observeAudioSystemProperties =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, CrosAudioConfig_ObserveAudioSystemProperties_ParamsSpec.$, null, this.observeAudioSystemProperties.createReceiverHandler(false /* expectsResponse */), false);
        this.setOutputMuted =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, CrosAudioConfig_SetOutputMuted_ParamsSpec.$, null, this.setOutputMuted.createReceiverHandler(false /* expectsResponse */), false);
        this.setOutputVolumePercent =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, CrosAudioConfig_SetOutputVolumePercent_ParamsSpec.$, null, this.setOutputVolumePercent.createReceiverHandler(false /* expectsResponse */), false);
        this.setInputGainPercent =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(3, CrosAudioConfig_SetInputGainPercent_ParamsSpec.$, null, this.setInputGainPercent.createReceiverHandler(false /* expectsResponse */), false);
        this.setActiveDevice =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(4, CrosAudioConfig_SetActiveDevice_ParamsSpec.$, null, this.setActiveDevice.createReceiverHandler(false /* expectsResponse */), false);
        this.setInputMuted =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(5, CrosAudioConfig_SetInputMuted_ParamsSpec.$, null, this.setInputMuted.createReceiverHandler(false /* expectsResponse */), false);
        this.recordVoiceIsolationEnabledChange =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(6, CrosAudioConfig_RecordVoiceIsolationEnabledChange_ParamsSpec.$, null, this.recordVoiceIsolationEnabledChange.createReceiverHandler(false /* expectsResponse */), false);
        this.recordVoiceIsolationPreferredEffectChange =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(7, CrosAudioConfig_RecordVoiceIsolationPreferredEffectChange_ParamsSpec.$, null, this.recordVoiceIsolationPreferredEffectChange.createReceiverHandler(false /* expectsResponse */), false);
        this.setNoiseCancellationEnabled =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(8, CrosAudioConfig_SetNoiseCancellationEnabled_ParamsSpec.$, null, this.setNoiseCancellationEnabled.createReceiverHandler(false /* expectsResponse */), false);
        this.setStyleTransferEnabled =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(9, CrosAudioConfig_SetStyleTransferEnabled_ParamsSpec.$, null, this.setStyleTransferEnabled.createReceiverHandler(false /* expectsResponse */), false);
        this.setForceRespectUiGainsEnabled =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(10, CrosAudioConfig_SetForceRespectUiGainsEnabled_ParamsSpec.$, null, this.setForceRespectUiGainsEnabled.createReceiverHandler(false /* expectsResponse */), false);
        this.setHfpMicSrEnabled =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(11, CrosAudioConfig_SetHfpMicSrEnabled_ParamsSpec.$, null, this.setHfpMicSrEnabled.createReceiverHandler(false /* expectsResponse */), false);
        this.setSpatialAudioEnabled =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(12, CrosAudioConfig_SetSpatialAudioEnabled_ParamsSpec.$, null, this.setSpatialAudioEnabled.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export const VoiceIsolationUIAppearanceSpec = { $: {} };
export const AudioDeviceSpec = { $: {} };
export const AudioSystemPropertiesSpec = { $: {} };
export const AudioSystemPropertiesObserver_OnPropertiesUpdated_ParamsSpec = { $: {} };
export const CrosAudioConfig_ObserveAudioSystemProperties_ParamsSpec = { $: {} };
export const CrosAudioConfig_SetOutputMuted_ParamsSpec = { $: {} };
export const CrosAudioConfig_SetOutputVolumePercent_ParamsSpec = { $: {} };
export const CrosAudioConfig_SetInputGainPercent_ParamsSpec = { $: {} };
export const CrosAudioConfig_SetActiveDevice_ParamsSpec = { $: {} };
export const CrosAudioConfig_SetInputMuted_ParamsSpec = { $: {} };
export const CrosAudioConfig_RecordVoiceIsolationEnabledChange_ParamsSpec = { $: {} };
export const CrosAudioConfig_RecordVoiceIsolationPreferredEffectChange_ParamsSpec = { $: {} };
export const CrosAudioConfig_SetNoiseCancellationEnabled_ParamsSpec = { $: {} };
export const CrosAudioConfig_SetStyleTransferEnabled_ParamsSpec = { $: {} };
export const CrosAudioConfig_SetForceRespectUiGainsEnabled_ParamsSpec = { $: {} };
export const CrosAudioConfig_SetHfpMicSrEnabled_ParamsSpec = { $: {} };
export const CrosAudioConfig_SetSpatialAudioEnabled_ParamsSpec = { $: {} };
mojo.internal.Struct(VoiceIsolationUIAppearanceSpec.$, 'VoiceIsolationUIAppearance', [
    mojo.internal.StructField('toggleType', 0, 0, AudioEffectTypeSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('effectModeOptions', 4, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('showEffectFallbackMessage', 8, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(AudioDeviceSpec.$, 'AudioDevice', [
    mojo.internal.StructField('id', 0, 0, mojo.internal.Uint64, BigInt(0), false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('displayName', 8, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('isActive', 16, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('deviceType', 20, 0, AudioDeviceTypeSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('noiseCancellationState', 24, 0, AudioEffectStateSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('styleTransferState', 28, 0, AudioEffectStateSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('forceRespectUiGainsState', 32, 0, AudioEffectStateSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('hfpMicSrState', 36, 0, AudioEffectStateSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('spatialAudioState', 40, 0, AudioEffectStateSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 56],]);
mojo.internal.Struct(AudioSystemPropertiesSpec.$, 'AudioSystemProperties', [
    mojo.internal.StructField('outputDevices', 0, 0, mojo.internal.Array(AudioDeviceSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('outputVolumePercent', 8, 0, mojo.internal.Uint8, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('inputGainPercent', 9, 0, mojo.internal.Uint8, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('outputMuteState', 12, 0, MuteStateSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('inputDevices', 16, 0, mojo.internal.Array(AudioDeviceSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('inputMuteState', 24, 0, MuteStateSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('voiceIsolationUiAppearance', 32, 0, VoiceIsolationUIAppearanceSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 48],]);
mojo.internal.Struct(AudioSystemPropertiesObserver_OnPropertiesUpdated_ParamsSpec.$, 'AudioSystemPropertiesObserver_OnPropertiesUpdated_Params', [
    mojo.internal.StructField('properties', 0, 0, AudioSystemPropertiesSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(CrosAudioConfig_ObserveAudioSystemProperties_ParamsSpec.$, 'CrosAudioConfig_ObserveAudioSystemProperties_Params', [
    mojo.internal.StructField('observer', 0, 0, mojo.internal.InterfaceProxy(AudioSystemPropertiesObserverRemote), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(CrosAudioConfig_SetOutputMuted_ParamsSpec.$, 'CrosAudioConfig_SetOutputMuted_Params', [
    mojo.internal.StructField('muted', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(CrosAudioConfig_SetOutputVolumePercent_ParamsSpec.$, 'CrosAudioConfig_SetOutputVolumePercent_Params', [
    mojo.internal.StructField('volume', 0, 0, mojo.internal.Int8, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(CrosAudioConfig_SetInputGainPercent_ParamsSpec.$, 'CrosAudioConfig_SetInputGainPercent_Params', [
    mojo.internal.StructField('gain', 0, 0, mojo.internal.Uint8, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(CrosAudioConfig_SetActiveDevice_ParamsSpec.$, 'CrosAudioConfig_SetActiveDevice_Params', [
    mojo.internal.StructField('device', 0, 0, mojo.internal.Uint64, BigInt(0), false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(CrosAudioConfig_SetInputMuted_ParamsSpec.$, 'CrosAudioConfig_SetInputMuted_Params', [
    mojo.internal.StructField('muted', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(CrosAudioConfig_RecordVoiceIsolationEnabledChange_ParamsSpec.$, 'CrosAudioConfig_RecordVoiceIsolationEnabledChange_Params', [], [[0, 8],]);
mojo.internal.Struct(CrosAudioConfig_RecordVoiceIsolationPreferredEffectChange_ParamsSpec.$, 'CrosAudioConfig_RecordVoiceIsolationPreferredEffectChange_Params', [
    mojo.internal.StructField('preferredEffect', 0, 0, AudioEffectTypeSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(CrosAudioConfig_SetNoiseCancellationEnabled_ParamsSpec.$, 'CrosAudioConfig_SetNoiseCancellationEnabled_Params', [
    mojo.internal.StructField('enabled', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(CrosAudioConfig_SetStyleTransferEnabled_ParamsSpec.$, 'CrosAudioConfig_SetStyleTransferEnabled_Params', [
    mojo.internal.StructField('enabled', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(CrosAudioConfig_SetForceRespectUiGainsEnabled_ParamsSpec.$, 'CrosAudioConfig_SetForceRespectUiGainsEnabled_Params', [
    mojo.internal.StructField('enabled', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(CrosAudioConfig_SetHfpMicSrEnabled_ParamsSpec.$, 'CrosAudioConfig_SetHfpMicSrEnabled_Params', [
    mojo.internal.StructField('enabled', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(CrosAudioConfig_SetSpatialAudioEnabled_ParamsSpec.$, 'CrosAudioConfig_SetSpatialAudioEnabled_Params', [
    mojo.internal.StructField('enabled', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
