// chrome/browser/ui/webui/ash/settings/pages/device/display_settings/display_settings_provider.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { mojo } from '//resources/mojo/mojo/public/js/bindings.js';
export const DisplaySettingsTypeSpec = { $: mojo.internal.Enum() };
export var DisplaySettingsType;
(function (DisplaySettingsType) {
    DisplaySettingsType[DisplaySettingsType["MIN_VALUE"] = 0] = "MIN_VALUE";
    DisplaySettingsType[DisplaySettingsType["MAX_VALUE"] = 10] = "MAX_VALUE";
    DisplaySettingsType[DisplaySettingsType["kResolution"] = 0] = "kResolution";
    DisplaySettingsType[DisplaySettingsType["kRefreshRate"] = 1] = "kRefreshRate";
    DisplaySettingsType[DisplaySettingsType["kScaling"] = 2] = "kScaling";
    DisplaySettingsType[DisplaySettingsType["kOrientation"] = 3] = "kOrientation";
    DisplaySettingsType[DisplaySettingsType["kOverscan"] = 4] = "kOverscan";
    DisplaySettingsType[DisplaySettingsType["kNightLight"] = 5] = "kNightLight";
    DisplaySettingsType[DisplaySettingsType["kNightLightSchedule"] = 6] = "kNightLightSchedule";
    DisplaySettingsType[DisplaySettingsType["kDisplayPage"] = 7] = "kDisplayPage";
    DisplaySettingsType[DisplaySettingsType["kMirrorMode"] = 8] = "kMirrorMode";
    DisplaySettingsType[DisplaySettingsType["kUnifiedMode"] = 9] = "kUnifiedMode";
    DisplaySettingsType[DisplaySettingsType["kPrimaryDisplay"] = 10] = "kPrimaryDisplay";
})(DisplaySettingsType || (DisplaySettingsType = {}));
export const DisplaySettingsNightLightScheduleOptionSpec = { $: mojo.internal.Enum() };
export var DisplaySettingsNightLightScheduleOption;
(function (DisplaySettingsNightLightScheduleOption) {
    DisplaySettingsNightLightScheduleOption[DisplaySettingsNightLightScheduleOption["MIN_VALUE"] = 0] = "MIN_VALUE";
    DisplaySettingsNightLightScheduleOption[DisplaySettingsNightLightScheduleOption["MAX_VALUE"] = 2] = "MAX_VALUE";
    DisplaySettingsNightLightScheduleOption[DisplaySettingsNightLightScheduleOption["kNever"] = 0] = "kNever";
    DisplaySettingsNightLightScheduleOption[DisplaySettingsNightLightScheduleOption["kSunsetToSunrise"] = 1] = "kSunsetToSunrise";
    DisplaySettingsNightLightScheduleOption[DisplaySettingsNightLightScheduleOption["kCustom"] = 2] = "kCustom";
})(DisplaySettingsNightLightScheduleOption || (DisplaySettingsNightLightScheduleOption = {}));
export const DisplaySettingsOrientationOptionSpec = { $: mojo.internal.Enum() };
export var DisplaySettingsOrientationOption;
(function (DisplaySettingsOrientationOption) {
    DisplaySettingsOrientationOption[DisplaySettingsOrientationOption["MIN_VALUE"] = 0] = "MIN_VALUE";
    DisplaySettingsOrientationOption[DisplaySettingsOrientationOption["MAX_VALUE"] = 4] = "MAX_VALUE";
    DisplaySettingsOrientationOption[DisplaySettingsOrientationOption["kAuto"] = 0] = "kAuto";
    DisplaySettingsOrientationOption[DisplaySettingsOrientationOption["k0Degree"] = 1] = "k0Degree";
    DisplaySettingsOrientationOption[DisplaySettingsOrientationOption["k90Degree"] = 2] = "k90Degree";
    DisplaySettingsOrientationOption[DisplaySettingsOrientationOption["k180Degree"] = 3] = "k180Degree";
    DisplaySettingsOrientationOption[DisplaySettingsOrientationOption["k270Degree"] = 4] = "k270Degree";
})(DisplaySettingsOrientationOption || (DisplaySettingsOrientationOption = {}));
export class TabletModeObserverPendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.settings.mojom.TabletModeObserver', scope);
    }
}
export class TabletModeObserverRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(TabletModeObserverPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    onTabletModeChanged(isTabletMode) {
        this.proxy.sendMessage(0, TabletModeObserver_OnTabletModeChanged_ParamsSpec.$, null, [
            isTabletMode
        ], false);
    }
}
;
/**
 * An object which receives request messages for the TabletModeObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class TabletModeObserverReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(TabletModeObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, TabletModeObserver_OnTabletModeChanged_ParamsSpec.$, null, impl.onTabletModeChanged.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class TabletModeObserver {
    static get $interfaceName() {
        return "ash.settings.mojom.TabletModeObserver";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new TabletModeObserverRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the TabletModeObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class TabletModeObserverCallbackRouter {
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(TabletModeObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.onTabletModeChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, TabletModeObserver_OnTabletModeChanged_ParamsSpec.$, null, this.onTabletModeChanged.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class DisplayConfigurationObserverPendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.settings.mojom.DisplayConfigurationObserver', scope);
    }
}
export class DisplayConfigurationObserverRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(DisplayConfigurationObserverPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    onDisplayConfigurationChanged() {
        this.proxy.sendMessage(0, DisplayConfigurationObserver_OnDisplayConfigurationChanged_ParamsSpec.$, null, [], false);
    }
}
;
/**
 * An object which receives request messages for the DisplayConfigurationObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class DisplayConfigurationObserverReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(DisplayConfigurationObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, DisplayConfigurationObserver_OnDisplayConfigurationChanged_ParamsSpec.$, null, impl.onDisplayConfigurationChanged.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class DisplayConfigurationObserver {
    static get $interfaceName() {
        return "ash.settings.mojom.DisplayConfigurationObserver";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new DisplayConfigurationObserverRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the DisplayConfigurationObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class DisplayConfigurationObserverCallbackRouter {
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(DisplayConfigurationObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.onDisplayConfigurationChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, DisplayConfigurationObserver_OnDisplayConfigurationChanged_ParamsSpec.$, null, this.onDisplayConfigurationChanged.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class DisplayBrightnessSettingsObserverPendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.settings.mojom.DisplayBrightnessSettingsObserver', scope);
    }
}
export class DisplayBrightnessSettingsObserverRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(DisplayBrightnessSettingsObserverPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    onDisplayBrightnessChanged(brightnessPercent, triggeredByAls) {
        this.proxy.sendMessage(0, DisplayBrightnessSettingsObserver_OnDisplayBrightnessChanged_ParamsSpec.$, null, [
            brightnessPercent,
            triggeredByAls
        ], false);
    }
}
;
/**
 * An object which receives request messages for the DisplayBrightnessSettingsObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class DisplayBrightnessSettingsObserverReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(DisplayBrightnessSettingsObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, DisplayBrightnessSettingsObserver_OnDisplayBrightnessChanged_ParamsSpec.$, null, impl.onDisplayBrightnessChanged.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class DisplayBrightnessSettingsObserver {
    static get $interfaceName() {
        return "ash.settings.mojom.DisplayBrightnessSettingsObserver";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new DisplayBrightnessSettingsObserverRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the DisplayBrightnessSettingsObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class DisplayBrightnessSettingsObserverCallbackRouter {
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(DisplayBrightnessSettingsObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.onDisplayBrightnessChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, DisplayBrightnessSettingsObserver_OnDisplayBrightnessChanged_ParamsSpec.$, null, this.onDisplayBrightnessChanged.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class AmbientLightSensorObserverPendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.settings.mojom.AmbientLightSensorObserver', scope);
    }
}
export class AmbientLightSensorObserverRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(AmbientLightSensorObserverPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    onAmbientLightSensorEnabledChanged(isAmbientLightSensorEnabled) {
        this.proxy.sendMessage(0, AmbientLightSensorObserver_OnAmbientLightSensorEnabledChanged_ParamsSpec.$, null, [
            isAmbientLightSensorEnabled
        ], false);
    }
}
;
/**
 * An object which receives request messages for the AmbientLightSensorObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class AmbientLightSensorObserverReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(AmbientLightSensorObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, AmbientLightSensorObserver_OnAmbientLightSensorEnabledChanged_ParamsSpec.$, null, impl.onAmbientLightSensorEnabledChanged.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class AmbientLightSensorObserver {
    static get $interfaceName() {
        return "ash.settings.mojom.AmbientLightSensorObserver";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new AmbientLightSensorObserverRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the AmbientLightSensorObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class AmbientLightSensorObserverCallbackRouter {
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(AmbientLightSensorObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.onAmbientLightSensorEnabledChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, AmbientLightSensorObserver_OnAmbientLightSensorEnabledChanged_ParamsSpec.$, null, this.onAmbientLightSensorEnabledChanged.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class DisplaySettingsProviderPendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.settings.mojom.DisplaySettingsProvider', scope);
    }
}
export class DisplaySettingsProviderRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(DisplaySettingsProviderPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    observeTabletMode(observer) {
        return this.proxy.sendMessage(0, DisplaySettingsProvider_ObserveTabletMode_ParamsSpec.$, DisplaySettingsProvider_ObserveTabletMode_ResponseParamsSpec.$, [
            observer
        ], false);
    }
    observeDisplayConfiguration(observer) {
        this.proxy.sendMessage(1, DisplaySettingsProvider_ObserveDisplayConfiguration_ParamsSpec.$, null, [
            observer
        ], false);
    }
    observeDisplayBrightnessSettings(observer) {
        return this.proxy.sendMessage(2, DisplaySettingsProvider_ObserveDisplayBrightnessSettings_ParamsSpec.$, DisplaySettingsProvider_ObserveDisplayBrightnessSettings_ResponseParamsSpec.$, [
            observer
        ], false);
    }
    observeAmbientLightSensor(observer) {
        return this.proxy.sendMessage(3, DisplaySettingsProvider_ObserveAmbientLightSensor_ParamsSpec.$, DisplaySettingsProvider_ObserveAmbientLightSensor_ResponseParamsSpec.$, [
            observer
        ], false);
    }
    recordChangingDisplaySettings(type, value) {
        this.proxy.sendMessage(4, DisplaySettingsProvider_RecordChangingDisplaySettings_ParamsSpec.$, null, [
            type,
            value
        ], false);
    }
    setShinyPerformance(enabled) {
        this.proxy.sendMessage(5, DisplaySettingsProvider_SetShinyPerformance_ParamsSpec.$, null, [
            enabled
        ], false);
    }
    setInternalDisplayScreenBrightness(percent) {
        this.proxy.sendMessage(6, DisplaySettingsProvider_SetInternalDisplayScreenBrightness_ParamsSpec.$, null, [
            percent
        ], false);
    }
    setInternalDisplayAmbientLightSensorEnabled(enabled) {
        this.proxy.sendMessage(7, DisplaySettingsProvider_SetInternalDisplayAmbientLightSensorEnabled_ParamsSpec.$, null, [
            enabled
        ], false);
    }
    startNativeTouchscreenMappingExperience() {
        this.proxy.sendMessage(8, DisplaySettingsProvider_StartNativeTouchscreenMappingExperience_ParamsSpec.$, null, [], false);
    }
    hasAmbientLightSensor() {
        return this.proxy.sendMessage(9, DisplaySettingsProvider_HasAmbientLightSensor_ParamsSpec.$, DisplaySettingsProvider_HasAmbientLightSensor_ResponseParamsSpec.$, [], false);
    }
}
;
/**
 * An object which receives request messages for the DisplaySettingsProvider
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class DisplaySettingsProviderReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(DisplaySettingsProviderRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, DisplaySettingsProvider_ObserveTabletMode_ParamsSpec.$, DisplaySettingsProvider_ObserveTabletMode_ResponseParamsSpec.$, impl.observeTabletMode.bind(impl), false);
        this.helper_internal_.registerHandler(1, DisplaySettingsProvider_ObserveDisplayConfiguration_ParamsSpec.$, null, impl.observeDisplayConfiguration.bind(impl), false);
        this.helper_internal_.registerHandler(2, DisplaySettingsProvider_ObserveDisplayBrightnessSettings_ParamsSpec.$, DisplaySettingsProvider_ObserveDisplayBrightnessSettings_ResponseParamsSpec.$, impl.observeDisplayBrightnessSettings.bind(impl), false);
        this.helper_internal_.registerHandler(3, DisplaySettingsProvider_ObserveAmbientLightSensor_ParamsSpec.$, DisplaySettingsProvider_ObserveAmbientLightSensor_ResponseParamsSpec.$, impl.observeAmbientLightSensor.bind(impl), false);
        this.helper_internal_.registerHandler(4, DisplaySettingsProvider_RecordChangingDisplaySettings_ParamsSpec.$, null, impl.recordChangingDisplaySettings.bind(impl), false);
        this.helper_internal_.registerHandler(5, DisplaySettingsProvider_SetShinyPerformance_ParamsSpec.$, null, impl.setShinyPerformance.bind(impl), false);
        this.helper_internal_.registerHandler(6, DisplaySettingsProvider_SetInternalDisplayScreenBrightness_ParamsSpec.$, null, impl.setInternalDisplayScreenBrightness.bind(impl), false);
        this.helper_internal_.registerHandler(7, DisplaySettingsProvider_SetInternalDisplayAmbientLightSensorEnabled_ParamsSpec.$, null, impl.setInternalDisplayAmbientLightSensorEnabled.bind(impl), false);
        this.helper_internal_.registerHandler(8, DisplaySettingsProvider_StartNativeTouchscreenMappingExperience_ParamsSpec.$, null, impl.startNativeTouchscreenMappingExperience.bind(impl), false);
        this.helper_internal_.registerHandler(9, DisplaySettingsProvider_HasAmbientLightSensor_ParamsSpec.$, DisplaySettingsProvider_HasAmbientLightSensor_ResponseParamsSpec.$, impl.hasAmbientLightSensor.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class DisplaySettingsProvider {
    static get $interfaceName() {
        return "ash.settings.mojom.DisplaySettingsProvider";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new DisplaySettingsProviderRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the DisplaySettingsProvider
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class DisplaySettingsProviderCallbackRouter {
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(DisplaySettingsProviderRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.observeTabletMode =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, DisplaySettingsProvider_ObserveTabletMode_ParamsSpec.$, DisplaySettingsProvider_ObserveTabletMode_ResponseParamsSpec.$, this.observeTabletMode.createReceiverHandler(true /* expectsResponse */), false);
        this.observeDisplayConfiguration =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, DisplaySettingsProvider_ObserveDisplayConfiguration_ParamsSpec.$, null, this.observeDisplayConfiguration.createReceiverHandler(false /* expectsResponse */), false);
        this.observeDisplayBrightnessSettings =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, DisplaySettingsProvider_ObserveDisplayBrightnessSettings_ParamsSpec.$, DisplaySettingsProvider_ObserveDisplayBrightnessSettings_ResponseParamsSpec.$, this.observeDisplayBrightnessSettings.createReceiverHandler(true /* expectsResponse */), false);
        this.observeAmbientLightSensor =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(3, DisplaySettingsProvider_ObserveAmbientLightSensor_ParamsSpec.$, DisplaySettingsProvider_ObserveAmbientLightSensor_ResponseParamsSpec.$, this.observeAmbientLightSensor.createReceiverHandler(true /* expectsResponse */), false);
        this.recordChangingDisplaySettings =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(4, DisplaySettingsProvider_RecordChangingDisplaySettings_ParamsSpec.$, null, this.recordChangingDisplaySettings.createReceiverHandler(false /* expectsResponse */), false);
        this.setShinyPerformance =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(5, DisplaySettingsProvider_SetShinyPerformance_ParamsSpec.$, null, this.setShinyPerformance.createReceiverHandler(false /* expectsResponse */), false);
        this.setInternalDisplayScreenBrightness =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(6, DisplaySettingsProvider_SetInternalDisplayScreenBrightness_ParamsSpec.$, null, this.setInternalDisplayScreenBrightness.createReceiverHandler(false /* expectsResponse */), false);
        this.setInternalDisplayAmbientLightSensorEnabled =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(7, DisplaySettingsProvider_SetInternalDisplayAmbientLightSensorEnabled_ParamsSpec.$, null, this.setInternalDisplayAmbientLightSensorEnabled.createReceiverHandler(false /* expectsResponse */), false);
        this.startNativeTouchscreenMappingExperience =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(8, DisplaySettingsProvider_StartNativeTouchscreenMappingExperience_ParamsSpec.$, null, this.startNativeTouchscreenMappingExperience.createReceiverHandler(false /* expectsResponse */), false);
        this.hasAmbientLightSensor =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(9, DisplaySettingsProvider_HasAmbientLightSensor_ParamsSpec.$, DisplaySettingsProvider_HasAmbientLightSensor_ResponseParamsSpec.$, this.hasAmbientLightSensor.createReceiverHandler(true /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export const DisplaySettingsValueSpec = { $: {} };
export const TabletModeObserver_OnTabletModeChanged_ParamsSpec = { $: {} };
export const DisplayConfigurationObserver_OnDisplayConfigurationChanged_ParamsSpec = { $: {} };
export const DisplayBrightnessSettingsObserver_OnDisplayBrightnessChanged_ParamsSpec = { $: {} };
export const AmbientLightSensorObserver_OnAmbientLightSensorEnabledChanged_ParamsSpec = { $: {} };
export const DisplaySettingsProvider_ObserveTabletMode_ParamsSpec = { $: {} };
export const DisplaySettingsProvider_ObserveTabletMode_ResponseParamsSpec = { $: {} };
export const DisplaySettingsProvider_ObserveDisplayConfiguration_ParamsSpec = { $: {} };
export const DisplaySettingsProvider_ObserveDisplayBrightnessSettings_ParamsSpec = { $: {} };
export const DisplaySettingsProvider_ObserveDisplayBrightnessSettings_ResponseParamsSpec = { $: {} };
export const DisplaySettingsProvider_ObserveAmbientLightSensor_ParamsSpec = { $: {} };
export const DisplaySettingsProvider_ObserveAmbientLightSensor_ResponseParamsSpec = { $: {} };
export const DisplaySettingsProvider_RecordChangingDisplaySettings_ParamsSpec = { $: {} };
export const DisplaySettingsProvider_SetShinyPerformance_ParamsSpec = { $: {} };
export const DisplaySettingsProvider_SetInternalDisplayScreenBrightness_ParamsSpec = { $: {} };
export const DisplaySettingsProvider_SetInternalDisplayAmbientLightSensorEnabled_ParamsSpec = { $: {} };
export const DisplaySettingsProvider_StartNativeTouchscreenMappingExperience_ParamsSpec = { $: {} };
export const DisplaySettingsProvider_HasAmbientLightSensor_ParamsSpec = { $: {} };
export const DisplaySettingsProvider_HasAmbientLightSensor_ResponseParamsSpec = { $: {} };
mojo.internal.Struct(DisplaySettingsValueSpec.$, 'DisplaySettingsValue', [
    mojo.internal.StructField('is_internal_display_$flag', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, {
        isPrimary: true,
        linkedValueFieldName: "is_internal_display_$value",
        originalFieldName: "isInternalDisplay",
    }, undefined),
    mojo.internal.StructField('is_internal_display_$value', 0, 1, mojo.internal.Bool, false, false /* nullable */, 0, {
        isPrimary: false,
        originalFieldName: "isInternalDisplay",
    }, undefined),
    mojo.internal.StructField('display_id_$flag', 0, 2, mojo.internal.Bool, false, false /* nullable */, 0, {
        isPrimary: true,
        linkedValueFieldName: "display_id_$value",
        originalFieldName: "displayId",
    }, undefined),
    mojo.internal.StructField('display_id_$value', 8, 0, mojo.internal.Int64, BigInt(0), false /* nullable */, 0, {
        isPrimary: false,
        originalFieldName: "displayId",
    }, undefined),
    mojo.internal.StructField('orientation_$flag', 0, 3, mojo.internal.Bool, false, false /* nullable */, 0, {
        isPrimary: true,
        linkedValueFieldName: "orientation_$value",
        originalFieldName: "orientation",
    }, undefined),
    mojo.internal.StructField('orientation_$value', 4, 0, DisplaySettingsOrientationOptionSpec.$, 0, false /* nullable */, 0, {
        isPrimary: false,
        originalFieldName: "orientation",
    }, undefined),
    mojo.internal.StructField('night_light_status_$flag', 0, 4, mojo.internal.Bool, false, false /* nullable */, 0, {
        isPrimary: true,
        linkedValueFieldName: "night_light_status_$value",
        originalFieldName: "nightLightStatus",
    }, undefined),
    mojo.internal.StructField('night_light_status_$value', 0, 5, mojo.internal.Bool, false, false /* nullable */, 0, {
        isPrimary: false,
        originalFieldName: "nightLightStatus",
    }, undefined),
    mojo.internal.StructField('night_light_schedule_$flag', 0, 6, mojo.internal.Bool, false, false /* nullable */, 0, {
        isPrimary: true,
        linkedValueFieldName: "night_light_schedule_$value",
        originalFieldName: "nightLightSchedule",
    }, undefined),
    mojo.internal.StructField('night_light_schedule_$value', 16, 0, DisplaySettingsNightLightScheduleOptionSpec.$, 0, false /* nullable */, 0, {
        isPrimary: false,
        originalFieldName: "nightLightSchedule",
    }, undefined),
    mojo.internal.StructField('mirror_mode_status_$flag', 0, 7, mojo.internal.Bool, false, false /* nullable */, 0, {
        isPrimary: true,
        linkedValueFieldName: "mirror_mode_status_$value",
        originalFieldName: "mirrorModeStatus",
    }, undefined),
    mojo.internal.StructField('mirror_mode_status_$value', 1, 0, mojo.internal.Bool, false, false /* nullable */, 0, {
        isPrimary: false,
        originalFieldName: "mirrorModeStatus",
    }, undefined),
    mojo.internal.StructField('unified_mode_status_$flag', 1, 1, mojo.internal.Bool, false, false /* nullable */, 0, {
        isPrimary: true,
        linkedValueFieldName: "unified_mode_status_$value",
        originalFieldName: "unifiedModeStatus",
    }, undefined),
    mojo.internal.StructField('unified_mode_status_$value', 1, 2, mojo.internal.Bool, false, false /* nullable */, 0, {
        isPrimary: false,
        originalFieldName: "unifiedModeStatus",
    }, undefined),
], [[0, 32],]);
mojo.internal.Struct(TabletModeObserver_OnTabletModeChanged_ParamsSpec.$, 'TabletModeObserver_OnTabletModeChanged_Params', [
    mojo.internal.StructField('isTabletMode', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(DisplayConfigurationObserver_OnDisplayConfigurationChanged_ParamsSpec.$, 'DisplayConfigurationObserver_OnDisplayConfigurationChanged_Params', [], [[0, 8],]);
mojo.internal.Struct(DisplayBrightnessSettingsObserver_OnDisplayBrightnessChanged_ParamsSpec.$, 'DisplayBrightnessSettingsObserver_OnDisplayBrightnessChanged_Params', [
    mojo.internal.StructField('brightnessPercent', 0, 0, mojo.internal.Double, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('triggeredByAls', 8, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(AmbientLightSensorObserver_OnAmbientLightSensorEnabledChanged_ParamsSpec.$, 'AmbientLightSensorObserver_OnAmbientLightSensorEnabledChanged_Params', [
    mojo.internal.StructField('isAmbientLightSensorEnabled', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(DisplaySettingsProvider_ObserveTabletMode_ParamsSpec.$, 'DisplaySettingsProvider_ObserveTabletMode_Params', [
    mojo.internal.StructField('observer', 0, 0, mojo.internal.InterfaceProxy(TabletModeObserverRemote), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(DisplaySettingsProvider_ObserveTabletMode_ResponseParamsSpec.$, 'DisplaySettingsProvider_ObserveTabletMode_ResponseParams', [
    mojo.internal.StructField('isTabletMode', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(DisplaySettingsProvider_ObserveDisplayConfiguration_ParamsSpec.$, 'DisplaySettingsProvider_ObserveDisplayConfiguration_Params', [
    mojo.internal.StructField('observer', 0, 0, mojo.internal.InterfaceProxy(DisplayConfigurationObserverRemote), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(DisplaySettingsProvider_ObserveDisplayBrightnessSettings_ParamsSpec.$, 'DisplaySettingsProvider_ObserveDisplayBrightnessSettings_Params', [
    mojo.internal.StructField('observer', 0, 0, mojo.internal.InterfaceProxy(DisplayBrightnessSettingsObserverRemote), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(DisplaySettingsProvider_ObserveDisplayBrightnessSettings_ResponseParamsSpec.$, 'DisplaySettingsProvider_ObserveDisplayBrightnessSettings_ResponseParams', [
    mojo.internal.StructField('brightnessPercent', 0, 0, mojo.internal.Double, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(DisplaySettingsProvider_ObserveAmbientLightSensor_ParamsSpec.$, 'DisplaySettingsProvider_ObserveAmbientLightSensor_Params', [
    mojo.internal.StructField('observer', 0, 0, mojo.internal.InterfaceProxy(AmbientLightSensorObserverRemote), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(DisplaySettingsProvider_ObserveAmbientLightSensor_ResponseParamsSpec.$, 'DisplaySettingsProvider_ObserveAmbientLightSensor_ResponseParams', [
    mojo.internal.StructField('isAmbientLightSensorEnabled', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(DisplaySettingsProvider_RecordChangingDisplaySettings_ParamsSpec.$, 'DisplaySettingsProvider_RecordChangingDisplaySettings_Params', [
    mojo.internal.StructField('type', 0, 0, DisplaySettingsTypeSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('value', 8, 0, DisplaySettingsValueSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(DisplaySettingsProvider_SetShinyPerformance_ParamsSpec.$, 'DisplaySettingsProvider_SetShinyPerformance_Params', [
    mojo.internal.StructField('enabled', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(DisplaySettingsProvider_SetInternalDisplayScreenBrightness_ParamsSpec.$, 'DisplaySettingsProvider_SetInternalDisplayScreenBrightness_Params', [
    mojo.internal.StructField('percent', 0, 0, mojo.internal.Double, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(DisplaySettingsProvider_SetInternalDisplayAmbientLightSensorEnabled_ParamsSpec.$, 'DisplaySettingsProvider_SetInternalDisplayAmbientLightSensorEnabled_Params', [
    mojo.internal.StructField('enabled', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(DisplaySettingsProvider_StartNativeTouchscreenMappingExperience_ParamsSpec.$, 'DisplaySettingsProvider_StartNativeTouchscreenMappingExperience_Params', [], [[0, 8],]);
mojo.internal.Struct(DisplaySettingsProvider_HasAmbientLightSensor_ParamsSpec.$, 'DisplaySettingsProvider_HasAmbientLightSensor_Params', [], [[0, 8],]);
mojo.internal.Struct(DisplaySettingsProvider_HasAmbientLightSensor_ResponseParamsSpec.$, 'DisplaySettingsProvider_HasAmbientLightSensor_ResponseParams', [
    mojo.internal.StructField('hasAmbientLightSensor', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
