// chrome/browser/ui/webui/ash/settings/pages/files/mojom/google_drive_handler.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { mojo } from '//resources/mojo/mojo/public/js/bindings.js';
import { StageSpec as drivefs_pinningManagerTypes_mojom_StageSpec } from './pinning_manager_types.mojom-webui.js';
export class PageHandlerFactoryPendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.settings.google_drive.mojom.PageHandlerFactory', scope);
    }
}
export class PageHandlerFactoryRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(PageHandlerFactoryPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    createPageHandler(page, handler) {
        this.proxy.sendMessage(0, PageHandlerFactory_CreatePageHandler_ParamsSpec.$, null, [
            page,
            handler
        ], false);
    }
}
;
/**
 * An object which receives request messages for the PageHandlerFactory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageHandlerFactoryReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageHandlerFactoryRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, PageHandlerFactory_CreatePageHandler_ParamsSpec.$, null, impl.createPageHandler.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class PageHandlerFactory {
    static get $interfaceName() {
        return "ash.settings.google_drive.mojom.PageHandlerFactory";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new PageHandlerFactoryRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the PageHandlerFactory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageHandlerFactoryCallbackRouter {
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageHandlerFactoryRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.createPageHandler =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, PageHandlerFactory_CreatePageHandler_ParamsSpec.$, null, this.createPageHandler.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class PageHandlerPendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.settings.google_drive.mojom.PageHandler', scope);
    }
}
export class PageHandlerRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(PageHandlerPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    calculateRequiredSpace() {
        this.proxy.sendMessage(0, PageHandler_CalculateRequiredSpace_ParamsSpec.$, null, [], false);
    }
    getContentCacheSize() {
        return this.proxy.sendMessage(1, PageHandler_GetContentCacheSize_ParamsSpec.$, PageHandler_GetContentCacheSize_ResponseParamsSpec.$, [], false);
    }
    clearPinnedFiles() {
        return this.proxy.sendMessage(2, PageHandler_ClearPinnedFiles_ParamsSpec.$, PageHandler_ClearPinnedFiles_ResponseParamsSpec.$, [], false);
    }
    recordBulkPinningEnabledMetric() {
        this.proxy.sendMessage(3, PageHandler_RecordBulkPinningEnabledMetric_ParamsSpec.$, null, [], false);
    }
}
;
/**
 * An object which receives request messages for the PageHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageHandlerReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageHandlerRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, PageHandler_CalculateRequiredSpace_ParamsSpec.$, null, impl.calculateRequiredSpace.bind(impl), false);
        this.helper_internal_.registerHandler(1, PageHandler_GetContentCacheSize_ParamsSpec.$, PageHandler_GetContentCacheSize_ResponseParamsSpec.$, impl.getContentCacheSize.bind(impl), false);
        this.helper_internal_.registerHandler(2, PageHandler_ClearPinnedFiles_ParamsSpec.$, PageHandler_ClearPinnedFiles_ResponseParamsSpec.$, impl.clearPinnedFiles.bind(impl), false);
        this.helper_internal_.registerHandler(3, PageHandler_RecordBulkPinningEnabledMetric_ParamsSpec.$, null, impl.recordBulkPinningEnabledMetric.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class PageHandler {
    static get $interfaceName() {
        return "ash.settings.google_drive.mojom.PageHandler";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new PageHandlerRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the PageHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageHandlerCallbackRouter {
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageHandlerRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.calculateRequiredSpace =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, PageHandler_CalculateRequiredSpace_ParamsSpec.$, null, this.calculateRequiredSpace.createReceiverHandler(false /* expectsResponse */), false);
        this.getContentCacheSize =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, PageHandler_GetContentCacheSize_ParamsSpec.$, PageHandler_GetContentCacheSize_ResponseParamsSpec.$, this.getContentCacheSize.createReceiverHandler(true /* expectsResponse */), false);
        this.clearPinnedFiles =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, PageHandler_ClearPinnedFiles_ParamsSpec.$, PageHandler_ClearPinnedFiles_ResponseParamsSpec.$, this.clearPinnedFiles.createReceiverHandler(true /* expectsResponse */), false);
        this.recordBulkPinningEnabledMetric =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(3, PageHandler_RecordBulkPinningEnabledMetric_ParamsSpec.$, null, this.recordBulkPinningEnabledMetric.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class PagePendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.settings.google_drive.mojom.Page', scope);
    }
}
export class PageRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(PagePendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    onServiceUnavailable() {
        this.proxy.sendMessage(0, Page_OnServiceUnavailable_ParamsSpec.$, null, [], false);
    }
    onProgress(status) {
        this.proxy.sendMessage(1, Page_OnProgress_ParamsSpec.$, null, [
            status
        ], false);
    }
}
;
/**
 * An object which receives request messages for the Page
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, Page_OnServiceUnavailable_ParamsSpec.$, null, impl.onServiceUnavailable.bind(impl), false);
        this.helper_internal_.registerHandler(1, Page_OnProgress_ParamsSpec.$, null, impl.onProgress.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class Page {
    static get $interfaceName() {
        return "ash.settings.google_drive.mojom.Page";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new PageRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the Page
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageCallbackRouter {
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.onServiceUnavailable =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, Page_OnServiceUnavailable_ParamsSpec.$, null, this.onServiceUnavailable.createReceiverHandler(false /* expectsResponse */), false);
        this.onProgress =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, Page_OnProgress_ParamsSpec.$, null, this.onProgress.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export const StatusSpec = { $: {} };
export const PageHandlerFactory_CreatePageHandler_ParamsSpec = { $: {} };
export const PageHandler_CalculateRequiredSpace_ParamsSpec = { $: {} };
export const PageHandler_GetContentCacheSize_ParamsSpec = { $: {} };
export const PageHandler_GetContentCacheSize_ResponseParamsSpec = { $: {} };
export const PageHandler_ClearPinnedFiles_ParamsSpec = { $: {} };
export const PageHandler_ClearPinnedFiles_ResponseParamsSpec = { $: {} };
export const PageHandler_RecordBulkPinningEnabledMetric_ParamsSpec = { $: {} };
export const Page_OnServiceUnavailable_ParamsSpec = { $: {} };
export const Page_OnProgress_ParamsSpec = { $: {} };
mojo.internal.Struct(StatusSpec.$, 'Status', [
    mojo.internal.StructField('requiredSpace', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('freeSpace', 8, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('stage', 16, 0, drivefs_pinningManagerTypes_mojom_StageSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('listedFiles', 24, 0, mojo.internal.Uint64, BigInt(0), false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('isError', 20, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 40],]);
mojo.internal.Struct(PageHandlerFactory_CreatePageHandler_ParamsSpec.$, 'PageHandlerFactory_CreatePageHandler_Params', [
    mojo.internal.StructField('page', 0, 0, mojo.internal.InterfaceProxy(PageRemote), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('handler', 8, 0, mojo.internal.InterfaceRequest(PageHandlerPendingReceiver), null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(PageHandler_CalculateRequiredSpace_ParamsSpec.$, 'PageHandler_CalculateRequiredSpace_Params', [], [[0, 8],]);
mojo.internal.Struct(PageHandler_GetContentCacheSize_ParamsSpec.$, 'PageHandler_GetContentCacheSize_Params', [], [[0, 8],]);
mojo.internal.Struct(PageHandler_GetContentCacheSize_ResponseParamsSpec.$, 'PageHandler_GetContentCacheSize_ResponseParams', [
    mojo.internal.StructField('size', 0, 0, mojo.internal.String, null, true /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_ClearPinnedFiles_ParamsSpec.$, 'PageHandler_ClearPinnedFiles_Params', [], [[0, 8],]);
mojo.internal.Struct(PageHandler_ClearPinnedFiles_ResponseParamsSpec.$, 'PageHandler_ClearPinnedFiles_ResponseParams', [], [[0, 8],]);
mojo.internal.Struct(PageHandler_RecordBulkPinningEnabledMetric_ParamsSpec.$, 'PageHandler_RecordBulkPinningEnabledMetric_Params', [], [[0, 8],]);
mojo.internal.Struct(Page_OnServiceUnavailable_ParamsSpec.$, 'Page_OnServiceUnavailable_Params', [], [[0, 8],]);
mojo.internal.Struct(Page_OnProgress_ParamsSpec.$, 'Page_OnProgress_Params', [
    mojo.internal.StructField('status', 0, 0, StatusSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
