// chrome/browser/ui/webui/ash/settings/pages/device/input_device_settings/input_device_settings_provider.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { mojo } from '//resources/mojo/mojo/public/js/bindings.js';
import { AcceleratorActionSpec as ash_mojom_AcceleratorActionSpec } from './accelerator_actions.mojom-webui.js';
import { StaticShortcutActionSpec as ash_mojom_StaticShortcutActionSpec, GraphicsTabletSpec as ash_mojom_GraphicsTabletSpec, GraphicsTabletSettingsSpec as ash_mojom_GraphicsTabletSettingsSpec, KeyboardSpec as ash_mojom_KeyboardSpec, KeyboardPoliciesSpec as ash_mojom_KeyboardPoliciesSpec, KeyboardSettingsSpec as ash_mojom_KeyboardSettingsSpec, MouseSpec as ash_mojom_MouseSpec, MousePoliciesSpec as ash_mojom_MousePoliciesSpec, MouseSettingsSpec as ash_mojom_MouseSettingsSpec, PointingStickSpec as ash_mojom_PointingStickSpec, PointingStickSettingsSpec as ash_mojom_PointingStickSettingsSpec, TouchpadSpec as ash_mojom_TouchpadSpec, TouchpadSettingsSpec as ash_mojom_TouchpadSettingsSpec, ButtonSpec as ash_mojom_ButtonSpec } from './input_device_settings.mojom-webui.js';
import { MetaKeySpec as ui_mojom_MetaKeySpec } from './meta_key.mojom-webui.js';
export class KeyboardSettingsObserverPendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.settings.mojom.KeyboardSettingsObserver', scope);
    }
}
export class KeyboardSettingsObserverRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(KeyboardSettingsObserverPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    onKeyboardListUpdated(keyboards) {
        this.proxy.sendMessage(0, KeyboardSettingsObserver_OnKeyboardListUpdated_ParamsSpec.$, null, [
            keyboards
        ], false);
    }
    onKeyboardPoliciesUpdated(policies) {
        this.proxy.sendMessage(1, KeyboardSettingsObserver_OnKeyboardPoliciesUpdated_ParamsSpec.$, null, [
            policies
        ], false);
    }
}
;
/**
 * An object which receives request messages for the KeyboardSettingsObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class KeyboardSettingsObserverReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(KeyboardSettingsObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, KeyboardSettingsObserver_OnKeyboardListUpdated_ParamsSpec.$, null, impl.onKeyboardListUpdated.bind(impl), false);
        this.helper_internal_.registerHandler(1, KeyboardSettingsObserver_OnKeyboardPoliciesUpdated_ParamsSpec.$, null, impl.onKeyboardPoliciesUpdated.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class KeyboardSettingsObserver {
    static get $interfaceName() {
        return "ash.settings.mojom.KeyboardSettingsObserver";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new KeyboardSettingsObserverRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the KeyboardSettingsObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class KeyboardSettingsObserverCallbackRouter {
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(KeyboardSettingsObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.onKeyboardListUpdated =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, KeyboardSettingsObserver_OnKeyboardListUpdated_ParamsSpec.$, null, this.onKeyboardListUpdated.createReceiverHandler(false /* expectsResponse */), false);
        this.onKeyboardPoliciesUpdated =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, KeyboardSettingsObserver_OnKeyboardPoliciesUpdated_ParamsSpec.$, null, this.onKeyboardPoliciesUpdated.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class TouchpadSettingsObserverPendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.settings.mojom.TouchpadSettingsObserver', scope);
    }
}
export class TouchpadSettingsObserverRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(TouchpadSettingsObserverPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    onTouchpadListUpdated(touchpads) {
        this.proxy.sendMessage(0, TouchpadSettingsObserver_OnTouchpadListUpdated_ParamsSpec.$, null, [
            touchpads
        ], false);
    }
}
;
/**
 * An object which receives request messages for the TouchpadSettingsObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class TouchpadSettingsObserverReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(TouchpadSettingsObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, TouchpadSettingsObserver_OnTouchpadListUpdated_ParamsSpec.$, null, impl.onTouchpadListUpdated.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class TouchpadSettingsObserver {
    static get $interfaceName() {
        return "ash.settings.mojom.TouchpadSettingsObserver";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new TouchpadSettingsObserverRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the TouchpadSettingsObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class TouchpadSettingsObserverCallbackRouter {
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(TouchpadSettingsObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.onTouchpadListUpdated =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, TouchpadSettingsObserver_OnTouchpadListUpdated_ParamsSpec.$, null, this.onTouchpadListUpdated.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class PointingStickSettingsObserverPendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.settings.mojom.PointingStickSettingsObserver', scope);
    }
}
export class PointingStickSettingsObserverRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(PointingStickSettingsObserverPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    onPointingStickListUpdated(pointSticks) {
        this.proxy.sendMessage(0, PointingStickSettingsObserver_OnPointingStickListUpdated_ParamsSpec.$, null, [
            pointSticks
        ], false);
    }
}
;
/**
 * An object which receives request messages for the PointingStickSettingsObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PointingStickSettingsObserverReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PointingStickSettingsObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, PointingStickSettingsObserver_OnPointingStickListUpdated_ParamsSpec.$, null, impl.onPointingStickListUpdated.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class PointingStickSettingsObserver {
    static get $interfaceName() {
        return "ash.settings.mojom.PointingStickSettingsObserver";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new PointingStickSettingsObserverRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the PointingStickSettingsObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PointingStickSettingsObserverCallbackRouter {
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PointingStickSettingsObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.onPointingStickListUpdated =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, PointingStickSettingsObserver_OnPointingStickListUpdated_ParamsSpec.$, null, this.onPointingStickListUpdated.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class MouseSettingsObserverPendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.settings.mojom.MouseSettingsObserver', scope);
    }
}
export class MouseSettingsObserverRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(MouseSettingsObserverPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    onMouseListUpdated(mice) {
        this.proxy.sendMessage(0, MouseSettingsObserver_OnMouseListUpdated_ParamsSpec.$, null, [
            mice
        ], false);
    }
    onMousePoliciesUpdated(policies) {
        this.proxy.sendMessage(1, MouseSettingsObserver_OnMousePoliciesUpdated_ParamsSpec.$, null, [
            policies
        ], false);
    }
}
;
/**
 * An object which receives request messages for the MouseSettingsObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class MouseSettingsObserverReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(MouseSettingsObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, MouseSettingsObserver_OnMouseListUpdated_ParamsSpec.$, null, impl.onMouseListUpdated.bind(impl), false);
        this.helper_internal_.registerHandler(1, MouseSettingsObserver_OnMousePoliciesUpdated_ParamsSpec.$, null, impl.onMousePoliciesUpdated.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class MouseSettingsObserver {
    static get $interfaceName() {
        return "ash.settings.mojom.MouseSettingsObserver";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new MouseSettingsObserverRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the MouseSettingsObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class MouseSettingsObserverCallbackRouter {
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(MouseSettingsObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.onMouseListUpdated =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, MouseSettingsObserver_OnMouseListUpdated_ParamsSpec.$, null, this.onMouseListUpdated.createReceiverHandler(false /* expectsResponse */), false);
        this.onMousePoliciesUpdated =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, MouseSettingsObserver_OnMousePoliciesUpdated_ParamsSpec.$, null, this.onMousePoliciesUpdated.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class ButtonPressObserverPendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.settings.mojom.ButtonPressObserver', scope);
    }
}
export class ButtonPressObserverRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(ButtonPressObserverPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    onButtonPressed(button) {
        this.proxy.sendMessage(0, ButtonPressObserver_OnButtonPressed_ParamsSpec.$, null, [
            button
        ], false);
    }
}
;
/**
 * An object which receives request messages for the ButtonPressObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class ButtonPressObserverReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(ButtonPressObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, ButtonPressObserver_OnButtonPressed_ParamsSpec.$, null, impl.onButtonPressed.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class ButtonPressObserver {
    static get $interfaceName() {
        return "ash.settings.mojom.ButtonPressObserver";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new ButtonPressObserverRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the ButtonPressObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class ButtonPressObserverCallbackRouter {
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(ButtonPressObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.onButtonPressed =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, ButtonPressObserver_OnButtonPressed_ParamsSpec.$, null, this.onButtonPressed.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class GraphicsTabletSettingsObserverPendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.settings.mojom.GraphicsTabletSettingsObserver', scope);
    }
}
export class GraphicsTabletSettingsObserverRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(GraphicsTabletSettingsObserverPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    onGraphicsTabletListUpdated(graphicsTablets) {
        this.proxy.sendMessage(0, GraphicsTabletSettingsObserver_OnGraphicsTabletListUpdated_ParamsSpec.$, null, [
            graphicsTablets
        ], false);
    }
}
;
/**
 * An object which receives request messages for the GraphicsTabletSettingsObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class GraphicsTabletSettingsObserverReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(GraphicsTabletSettingsObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, GraphicsTabletSettingsObserver_OnGraphicsTabletListUpdated_ParamsSpec.$, null, impl.onGraphicsTabletListUpdated.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class GraphicsTabletSettingsObserver {
    static get $interfaceName() {
        return "ash.settings.mojom.GraphicsTabletSettingsObserver";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new GraphicsTabletSettingsObserverRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the GraphicsTabletSettingsObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class GraphicsTabletSettingsObserverCallbackRouter {
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(GraphicsTabletSettingsObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.onGraphicsTabletListUpdated =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, GraphicsTabletSettingsObserver_OnGraphicsTabletListUpdated_ParamsSpec.$, null, this.onGraphicsTabletListUpdated.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class KeyboardBrightnessObserverPendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.settings.mojom.KeyboardBrightnessObserver', scope);
    }
}
export class KeyboardBrightnessObserverRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(KeyboardBrightnessObserverPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    onKeyboardBrightnessChanged(brightnessPercent) {
        this.proxy.sendMessage(0, KeyboardBrightnessObserver_OnKeyboardBrightnessChanged_ParamsSpec.$, null, [
            brightnessPercent
        ], false);
    }
}
;
/**
 * An object which receives request messages for the KeyboardBrightnessObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class KeyboardBrightnessObserverReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(KeyboardBrightnessObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, KeyboardBrightnessObserver_OnKeyboardBrightnessChanged_ParamsSpec.$, null, impl.onKeyboardBrightnessChanged.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class KeyboardBrightnessObserver {
    static get $interfaceName() {
        return "ash.settings.mojom.KeyboardBrightnessObserver";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new KeyboardBrightnessObserverRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the KeyboardBrightnessObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class KeyboardBrightnessObserverCallbackRouter {
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(KeyboardBrightnessObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.onKeyboardBrightnessChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, KeyboardBrightnessObserver_OnKeyboardBrightnessChanged_ParamsSpec.$, null, this.onKeyboardBrightnessChanged.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class KeyboardAmbientLightSensorObserverPendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.settings.mojom.KeyboardAmbientLightSensorObserver', scope);
    }
}
export class KeyboardAmbientLightSensorObserverRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(KeyboardAmbientLightSensorObserverPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    onKeyboardAmbientLightSensorEnabledChanged(keyboardAmbientLightSensorEnabled) {
        this.proxy.sendMessage(0, KeyboardAmbientLightSensorObserver_OnKeyboardAmbientLightSensorEnabledChanged_ParamsSpec.$, null, [
            keyboardAmbientLightSensorEnabled
        ], false);
    }
}
;
/**
 * An object which receives request messages for the KeyboardAmbientLightSensorObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class KeyboardAmbientLightSensorObserverReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(KeyboardAmbientLightSensorObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, KeyboardAmbientLightSensorObserver_OnKeyboardAmbientLightSensorEnabledChanged_ParamsSpec.$, null, impl.onKeyboardAmbientLightSensorEnabledChanged.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class KeyboardAmbientLightSensorObserver {
    static get $interfaceName() {
        return "ash.settings.mojom.KeyboardAmbientLightSensorObserver";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new KeyboardAmbientLightSensorObserverRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the KeyboardAmbientLightSensorObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class KeyboardAmbientLightSensorObserverCallbackRouter {
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(KeyboardAmbientLightSensorObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.onKeyboardAmbientLightSensorEnabledChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, KeyboardAmbientLightSensorObserver_OnKeyboardAmbientLightSensorEnabledChanged_ParamsSpec.$, null, this.onKeyboardAmbientLightSensorEnabledChanged.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class LidStateObserverPendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.settings.mojom.LidStateObserver', scope);
    }
}
export class LidStateObserverRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(LidStateObserverPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    onLidStateChanged(isLidOpen) {
        this.proxy.sendMessage(0, LidStateObserver_OnLidStateChanged_ParamsSpec.$, null, [
            isLidOpen
        ], false);
    }
}
;
/**
 * An object which receives request messages for the LidStateObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class LidStateObserverReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(LidStateObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, LidStateObserver_OnLidStateChanged_ParamsSpec.$, null, impl.onLidStateChanged.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class LidStateObserver {
    static get $interfaceName() {
        return "ash.settings.mojom.LidStateObserver";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new LidStateObserverRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the LidStateObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class LidStateObserverCallbackRouter {
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(LidStateObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.onLidStateChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, LidStateObserver_OnLidStateChanged_ParamsSpec.$, null, this.onLidStateChanged.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class InputDeviceSettingsProviderPendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.settings.mojom.InputDeviceSettingsProvider', scope);
    }
}
export class InputDeviceSettingsProviderRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(InputDeviceSettingsProviderPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    observeKeyboardSettings(observer) {
        this.proxy.sendMessage(0, InputDeviceSettingsProvider_ObserveKeyboardSettings_ParamsSpec.$, null, [
            observer
        ], false);
    }
    observeTouchpadSettings(observer) {
        this.proxy.sendMessage(1, InputDeviceSettingsProvider_ObserveTouchpadSettings_ParamsSpec.$, null, [
            observer
        ], false);
    }
    observePointingStickSettings(observer) {
        this.proxy.sendMessage(2, InputDeviceSettingsProvider_ObservePointingStickSettings_ParamsSpec.$, null, [
            observer
        ], false);
    }
    observeMouseSettings(observer) {
        this.proxy.sendMessage(3, InputDeviceSettingsProvider_ObserveMouseSettings_ParamsSpec.$, null, [
            observer
        ], false);
    }
    observeGraphicsTabletSettings(observer) {
        this.proxy.sendMessage(4, InputDeviceSettingsProvider_ObserveGraphicsTabletSettings_ParamsSpec.$, null, [
            observer
        ], false);
    }
    observeButtonPresses(observer) {
        this.proxy.sendMessage(5, InputDeviceSettingsProvider_ObserveButtonPresses_ParamsSpec.$, null, [
            observer
        ], false);
    }
    observeKeyboardBrightness(observer) {
        this.proxy.sendMessage(6, InputDeviceSettingsProvider_ObserveKeyboardBrightness_ParamsSpec.$, null, [
            observer
        ], false);
    }
    observeKeyboardAmbientLightSensor(observer) {
        this.proxy.sendMessage(7, InputDeviceSettingsProvider_ObserveKeyboardAmbientLightSensor_ParamsSpec.$, null, [
            observer
        ], false);
    }
    observeLidState(observer) {
        return this.proxy.sendMessage(8, InputDeviceSettingsProvider_ObserveLidState_ParamsSpec.$, InputDeviceSettingsProvider_ObserveLidState_ResponseParamsSpec.$, [
            observer
        ], false);
    }
    restoreDefaultKeyboardRemappings(deviceId) {
        this.proxy.sendMessage(9, InputDeviceSettingsProvider_RestoreDefaultKeyboardRemappings_ParamsSpec.$, null, [
            deviceId
        ], false);
    }
    setKeyboardSettings(deviceId, settings) {
        this.proxy.sendMessage(10, InputDeviceSettingsProvider_SetKeyboardSettings_ParamsSpec.$, null, [
            deviceId,
            settings
        ], false);
    }
    setPointingStickSettings(deviceId, settings) {
        this.proxy.sendMessage(11, InputDeviceSettingsProvider_SetPointingStickSettings_ParamsSpec.$, null, [
            deviceId,
            settings
        ], false);
    }
    setMouseSettings(deviceId, settings) {
        this.proxy.sendMessage(12, InputDeviceSettingsProvider_SetMouseSettings_ParamsSpec.$, null, [
            deviceId,
            settings
        ], false);
    }
    setTouchpadSettings(deviceId, settings) {
        this.proxy.sendMessage(13, InputDeviceSettingsProvider_SetTouchpadSettings_ParamsSpec.$, null, [
            deviceId,
            settings
        ], false);
    }
    setGraphicsTabletSettings(deviceId, settings) {
        this.proxy.sendMessage(14, InputDeviceSettingsProvider_SetGraphicsTabletSettings_ParamsSpec.$, null, [
            deviceId,
            settings
        ], false);
    }
    setKeyboardBrightness(percent) {
        this.proxy.sendMessage(15, InputDeviceSettingsProvider_SetKeyboardBrightness_ParamsSpec.$, null, [
            percent
        ], false);
    }
    setKeyboardAmbientLightSensorEnabled(enabled) {
        this.proxy.sendMessage(16, InputDeviceSettingsProvider_SetKeyboardAmbientLightSensorEnabled_ParamsSpec.$, null, [
            enabled
        ], false);
    }
    startObserving(deviceId) {
        this.proxy.sendMessage(17, InputDeviceSettingsProvider_StartObserving_ParamsSpec.$, null, [
            deviceId
        ], false);
    }
    stopObserving() {
        this.proxy.sendMessage(18, InputDeviceSettingsProvider_StopObserving_ParamsSpec.$, null, [], false);
    }
    getActionsForMouseButtonCustomization() {
        return this.proxy.sendMessage(19, InputDeviceSettingsProvider_GetActionsForMouseButtonCustomization_ParamsSpec.$, InputDeviceSettingsProvider_GetActionsForMouseButtonCustomization_ResponseParamsSpec.$, [], false);
    }
    getActionsForGraphicsTabletButtonCustomization() {
        return this.proxy.sendMessage(20, InputDeviceSettingsProvider_GetActionsForGraphicsTabletButtonCustomization_ParamsSpec.$, InputDeviceSettingsProvider_GetActionsForGraphicsTabletButtonCustomization_ResponseParamsSpec.$, [], false);
    }
    getMetaKeyToDisplay() {
        return this.proxy.sendMessage(21, InputDeviceSettingsProvider_GetMetaKeyToDisplay_ParamsSpec.$, InputDeviceSettingsProvider_GetMetaKeyToDisplay_ResponseParamsSpec.$, [], false);
    }
    hasKeyboardBacklight() {
        return this.proxy.sendMessage(22, InputDeviceSettingsProvider_HasKeyboardBacklight_ParamsSpec.$, InputDeviceSettingsProvider_HasKeyboardBacklight_ResponseParamsSpec.$, [], false);
    }
    hasAmbientLightSensor() {
        return this.proxy.sendMessage(23, InputDeviceSettingsProvider_HasAmbientLightSensor_ParamsSpec.$, InputDeviceSettingsProvider_HasAmbientLightSensor_ResponseParamsSpec.$, [], false);
    }
    isRgbKeyboardSupported() {
        return this.proxy.sendMessage(24, InputDeviceSettingsProvider_IsRgbKeyboardSupported_ParamsSpec.$, InputDeviceSettingsProvider_IsRgbKeyboardSupported_ResponseParamsSpec.$, [], false);
    }
    recordKeyboardColorLinkClicked() {
        this.proxy.sendMessage(25, InputDeviceSettingsProvider_RecordKeyboardColorLinkClicked_ParamsSpec.$, null, [], false);
    }
    recordKeyboardBrightnessChangeFromSlider(percent) {
        this.proxy.sendMessage(26, InputDeviceSettingsProvider_RecordKeyboardBrightnessChangeFromSlider_ParamsSpec.$, null, [
            percent
        ], false);
    }
    getDeviceIconImage(deviceKey) {
        return this.proxy.sendMessage(27, InputDeviceSettingsProvider_GetDeviceIconImage_ParamsSpec.$, InputDeviceSettingsProvider_GetDeviceIconImage_ResponseParamsSpec.$, [
            deviceKey
        ], false);
    }
    launchCompanionApp(packageId) {
        this.proxy.sendMessage(28, InputDeviceSettingsProvider_LaunchCompanionApp_ParamsSpec.$, null, [
            packageId
        ], false);
    }
}
;
/**
 * An object which receives request messages for the InputDeviceSettingsProvider
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class InputDeviceSettingsProviderReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(InputDeviceSettingsProviderRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, InputDeviceSettingsProvider_ObserveKeyboardSettings_ParamsSpec.$, null, impl.observeKeyboardSettings.bind(impl), false);
        this.helper_internal_.registerHandler(1, InputDeviceSettingsProvider_ObserveTouchpadSettings_ParamsSpec.$, null, impl.observeTouchpadSettings.bind(impl), false);
        this.helper_internal_.registerHandler(2, InputDeviceSettingsProvider_ObservePointingStickSettings_ParamsSpec.$, null, impl.observePointingStickSettings.bind(impl), false);
        this.helper_internal_.registerHandler(3, InputDeviceSettingsProvider_ObserveMouseSettings_ParamsSpec.$, null, impl.observeMouseSettings.bind(impl), false);
        this.helper_internal_.registerHandler(4, InputDeviceSettingsProvider_ObserveGraphicsTabletSettings_ParamsSpec.$, null, impl.observeGraphicsTabletSettings.bind(impl), false);
        this.helper_internal_.registerHandler(5, InputDeviceSettingsProvider_ObserveButtonPresses_ParamsSpec.$, null, impl.observeButtonPresses.bind(impl), false);
        this.helper_internal_.registerHandler(6, InputDeviceSettingsProvider_ObserveKeyboardBrightness_ParamsSpec.$, null, impl.observeKeyboardBrightness.bind(impl), false);
        this.helper_internal_.registerHandler(7, InputDeviceSettingsProvider_ObserveKeyboardAmbientLightSensor_ParamsSpec.$, null, impl.observeKeyboardAmbientLightSensor.bind(impl), false);
        this.helper_internal_.registerHandler(8, InputDeviceSettingsProvider_ObserveLidState_ParamsSpec.$, InputDeviceSettingsProvider_ObserveLidState_ResponseParamsSpec.$, impl.observeLidState.bind(impl), false);
        this.helper_internal_.registerHandler(9, InputDeviceSettingsProvider_RestoreDefaultKeyboardRemappings_ParamsSpec.$, null, impl.restoreDefaultKeyboardRemappings.bind(impl), false);
        this.helper_internal_.registerHandler(10, InputDeviceSettingsProvider_SetKeyboardSettings_ParamsSpec.$, null, impl.setKeyboardSettings.bind(impl), false);
        this.helper_internal_.registerHandler(11, InputDeviceSettingsProvider_SetPointingStickSettings_ParamsSpec.$, null, impl.setPointingStickSettings.bind(impl), false);
        this.helper_internal_.registerHandler(12, InputDeviceSettingsProvider_SetMouseSettings_ParamsSpec.$, null, impl.setMouseSettings.bind(impl), false);
        this.helper_internal_.registerHandler(13, InputDeviceSettingsProvider_SetTouchpadSettings_ParamsSpec.$, null, impl.setTouchpadSettings.bind(impl), false);
        this.helper_internal_.registerHandler(14, InputDeviceSettingsProvider_SetGraphicsTabletSettings_ParamsSpec.$, null, impl.setGraphicsTabletSettings.bind(impl), false);
        this.helper_internal_.registerHandler(15, InputDeviceSettingsProvider_SetKeyboardBrightness_ParamsSpec.$, null, impl.setKeyboardBrightness.bind(impl), false);
        this.helper_internal_.registerHandler(16, InputDeviceSettingsProvider_SetKeyboardAmbientLightSensorEnabled_ParamsSpec.$, null, impl.setKeyboardAmbientLightSensorEnabled.bind(impl), false);
        this.helper_internal_.registerHandler(17, InputDeviceSettingsProvider_StartObserving_ParamsSpec.$, null, impl.startObserving.bind(impl), false);
        this.helper_internal_.registerHandler(18, InputDeviceSettingsProvider_StopObserving_ParamsSpec.$, null, impl.stopObserving.bind(impl), false);
        this.helper_internal_.registerHandler(19, InputDeviceSettingsProvider_GetActionsForMouseButtonCustomization_ParamsSpec.$, InputDeviceSettingsProvider_GetActionsForMouseButtonCustomization_ResponseParamsSpec.$, impl.getActionsForMouseButtonCustomization.bind(impl), false);
        this.helper_internal_.registerHandler(20, InputDeviceSettingsProvider_GetActionsForGraphicsTabletButtonCustomization_ParamsSpec.$, InputDeviceSettingsProvider_GetActionsForGraphicsTabletButtonCustomization_ResponseParamsSpec.$, impl.getActionsForGraphicsTabletButtonCustomization.bind(impl), false);
        this.helper_internal_.registerHandler(21, InputDeviceSettingsProvider_GetMetaKeyToDisplay_ParamsSpec.$, InputDeviceSettingsProvider_GetMetaKeyToDisplay_ResponseParamsSpec.$, impl.getMetaKeyToDisplay.bind(impl), false);
        this.helper_internal_.registerHandler(22, InputDeviceSettingsProvider_HasKeyboardBacklight_ParamsSpec.$, InputDeviceSettingsProvider_HasKeyboardBacklight_ResponseParamsSpec.$, impl.hasKeyboardBacklight.bind(impl), false);
        this.helper_internal_.registerHandler(23, InputDeviceSettingsProvider_HasAmbientLightSensor_ParamsSpec.$, InputDeviceSettingsProvider_HasAmbientLightSensor_ResponseParamsSpec.$, impl.hasAmbientLightSensor.bind(impl), false);
        this.helper_internal_.registerHandler(24, InputDeviceSettingsProvider_IsRgbKeyboardSupported_ParamsSpec.$, InputDeviceSettingsProvider_IsRgbKeyboardSupported_ResponseParamsSpec.$, impl.isRgbKeyboardSupported.bind(impl), false);
        this.helper_internal_.registerHandler(25, InputDeviceSettingsProvider_RecordKeyboardColorLinkClicked_ParamsSpec.$, null, impl.recordKeyboardColorLinkClicked.bind(impl), false);
        this.helper_internal_.registerHandler(26, InputDeviceSettingsProvider_RecordKeyboardBrightnessChangeFromSlider_ParamsSpec.$, null, impl.recordKeyboardBrightnessChangeFromSlider.bind(impl), false);
        this.helper_internal_.registerHandler(27, InputDeviceSettingsProvider_GetDeviceIconImage_ParamsSpec.$, InputDeviceSettingsProvider_GetDeviceIconImage_ResponseParamsSpec.$, impl.getDeviceIconImage.bind(impl), false);
        this.helper_internal_.registerHandler(28, InputDeviceSettingsProvider_LaunchCompanionApp_ParamsSpec.$, null, impl.launchCompanionApp.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class InputDeviceSettingsProvider {
    static get $interfaceName() {
        return "ash.settings.mojom.InputDeviceSettingsProvider";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new InputDeviceSettingsProviderRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the InputDeviceSettingsProvider
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class InputDeviceSettingsProviderCallbackRouter {
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(InputDeviceSettingsProviderRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.observeKeyboardSettings =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, InputDeviceSettingsProvider_ObserveKeyboardSettings_ParamsSpec.$, null, this.observeKeyboardSettings.createReceiverHandler(false /* expectsResponse */), false);
        this.observeTouchpadSettings =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, InputDeviceSettingsProvider_ObserveTouchpadSettings_ParamsSpec.$, null, this.observeTouchpadSettings.createReceiverHandler(false /* expectsResponse */), false);
        this.observePointingStickSettings =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, InputDeviceSettingsProvider_ObservePointingStickSettings_ParamsSpec.$, null, this.observePointingStickSettings.createReceiverHandler(false /* expectsResponse */), false);
        this.observeMouseSettings =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(3, InputDeviceSettingsProvider_ObserveMouseSettings_ParamsSpec.$, null, this.observeMouseSettings.createReceiverHandler(false /* expectsResponse */), false);
        this.observeGraphicsTabletSettings =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(4, InputDeviceSettingsProvider_ObserveGraphicsTabletSettings_ParamsSpec.$, null, this.observeGraphicsTabletSettings.createReceiverHandler(false /* expectsResponse */), false);
        this.observeButtonPresses =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(5, InputDeviceSettingsProvider_ObserveButtonPresses_ParamsSpec.$, null, this.observeButtonPresses.createReceiverHandler(false /* expectsResponse */), false);
        this.observeKeyboardBrightness =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(6, InputDeviceSettingsProvider_ObserveKeyboardBrightness_ParamsSpec.$, null, this.observeKeyboardBrightness.createReceiverHandler(false /* expectsResponse */), false);
        this.observeKeyboardAmbientLightSensor =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(7, InputDeviceSettingsProvider_ObserveKeyboardAmbientLightSensor_ParamsSpec.$, null, this.observeKeyboardAmbientLightSensor.createReceiverHandler(false /* expectsResponse */), false);
        this.observeLidState =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(8, InputDeviceSettingsProvider_ObserveLidState_ParamsSpec.$, InputDeviceSettingsProvider_ObserveLidState_ResponseParamsSpec.$, this.observeLidState.createReceiverHandler(true /* expectsResponse */), false);
        this.restoreDefaultKeyboardRemappings =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(9, InputDeviceSettingsProvider_RestoreDefaultKeyboardRemappings_ParamsSpec.$, null, this.restoreDefaultKeyboardRemappings.createReceiverHandler(false /* expectsResponse */), false);
        this.setKeyboardSettings =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(10, InputDeviceSettingsProvider_SetKeyboardSettings_ParamsSpec.$, null, this.setKeyboardSettings.createReceiverHandler(false /* expectsResponse */), false);
        this.setPointingStickSettings =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(11, InputDeviceSettingsProvider_SetPointingStickSettings_ParamsSpec.$, null, this.setPointingStickSettings.createReceiverHandler(false /* expectsResponse */), false);
        this.setMouseSettings =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(12, InputDeviceSettingsProvider_SetMouseSettings_ParamsSpec.$, null, this.setMouseSettings.createReceiverHandler(false /* expectsResponse */), false);
        this.setTouchpadSettings =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(13, InputDeviceSettingsProvider_SetTouchpadSettings_ParamsSpec.$, null, this.setTouchpadSettings.createReceiverHandler(false /* expectsResponse */), false);
        this.setGraphicsTabletSettings =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(14, InputDeviceSettingsProvider_SetGraphicsTabletSettings_ParamsSpec.$, null, this.setGraphicsTabletSettings.createReceiverHandler(false /* expectsResponse */), false);
        this.setKeyboardBrightness =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(15, InputDeviceSettingsProvider_SetKeyboardBrightness_ParamsSpec.$, null, this.setKeyboardBrightness.createReceiverHandler(false /* expectsResponse */), false);
        this.setKeyboardAmbientLightSensorEnabled =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(16, InputDeviceSettingsProvider_SetKeyboardAmbientLightSensorEnabled_ParamsSpec.$, null, this.setKeyboardAmbientLightSensorEnabled.createReceiverHandler(false /* expectsResponse */), false);
        this.startObserving =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(17, InputDeviceSettingsProvider_StartObserving_ParamsSpec.$, null, this.startObserving.createReceiverHandler(false /* expectsResponse */), false);
        this.stopObserving =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(18, InputDeviceSettingsProvider_StopObserving_ParamsSpec.$, null, this.stopObserving.createReceiverHandler(false /* expectsResponse */), false);
        this.getActionsForMouseButtonCustomization =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(19, InputDeviceSettingsProvider_GetActionsForMouseButtonCustomization_ParamsSpec.$, InputDeviceSettingsProvider_GetActionsForMouseButtonCustomization_ResponseParamsSpec.$, this.getActionsForMouseButtonCustomization.createReceiverHandler(true /* expectsResponse */), false);
        this.getActionsForGraphicsTabletButtonCustomization =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(20, InputDeviceSettingsProvider_GetActionsForGraphicsTabletButtonCustomization_ParamsSpec.$, InputDeviceSettingsProvider_GetActionsForGraphicsTabletButtonCustomization_ResponseParamsSpec.$, this.getActionsForGraphicsTabletButtonCustomization.createReceiverHandler(true /* expectsResponse */), false);
        this.getMetaKeyToDisplay =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(21, InputDeviceSettingsProvider_GetMetaKeyToDisplay_ParamsSpec.$, InputDeviceSettingsProvider_GetMetaKeyToDisplay_ResponseParamsSpec.$, this.getMetaKeyToDisplay.createReceiverHandler(true /* expectsResponse */), false);
        this.hasKeyboardBacklight =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(22, InputDeviceSettingsProvider_HasKeyboardBacklight_ParamsSpec.$, InputDeviceSettingsProvider_HasKeyboardBacklight_ResponseParamsSpec.$, this.hasKeyboardBacklight.createReceiverHandler(true /* expectsResponse */), false);
        this.hasAmbientLightSensor =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(23, InputDeviceSettingsProvider_HasAmbientLightSensor_ParamsSpec.$, InputDeviceSettingsProvider_HasAmbientLightSensor_ResponseParamsSpec.$, this.hasAmbientLightSensor.createReceiverHandler(true /* expectsResponse */), false);
        this.isRgbKeyboardSupported =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(24, InputDeviceSettingsProvider_IsRgbKeyboardSupported_ParamsSpec.$, InputDeviceSettingsProvider_IsRgbKeyboardSupported_ResponseParamsSpec.$, this.isRgbKeyboardSupported.createReceiverHandler(true /* expectsResponse */), false);
        this.recordKeyboardColorLinkClicked =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(25, InputDeviceSettingsProvider_RecordKeyboardColorLinkClicked_ParamsSpec.$, null, this.recordKeyboardColorLinkClicked.createReceiverHandler(false /* expectsResponse */), false);
        this.recordKeyboardBrightnessChangeFromSlider =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(26, InputDeviceSettingsProvider_RecordKeyboardBrightnessChangeFromSlider_ParamsSpec.$, null, this.recordKeyboardBrightnessChangeFromSlider.createReceiverHandler(false /* expectsResponse */), false);
        this.getDeviceIconImage =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(27, InputDeviceSettingsProvider_GetDeviceIconImage_ParamsSpec.$, InputDeviceSettingsProvider_GetDeviceIconImage_ResponseParamsSpec.$, this.getDeviceIconImage.createReceiverHandler(true /* expectsResponse */), false);
        this.launchCompanionApp =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(28, InputDeviceSettingsProvider_LaunchCompanionApp_ParamsSpec.$, null, this.launchCompanionApp.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export const ActionChoiceSpec = { $: {} };
export const KeyboardSettingsObserver_OnKeyboardListUpdated_ParamsSpec = { $: {} };
export const KeyboardSettingsObserver_OnKeyboardPoliciesUpdated_ParamsSpec = { $: {} };
export const TouchpadSettingsObserver_OnTouchpadListUpdated_ParamsSpec = { $: {} };
export const PointingStickSettingsObserver_OnPointingStickListUpdated_ParamsSpec = { $: {} };
export const MouseSettingsObserver_OnMouseListUpdated_ParamsSpec = { $: {} };
export const MouseSettingsObserver_OnMousePoliciesUpdated_ParamsSpec = { $: {} };
export const ButtonPressObserver_OnButtonPressed_ParamsSpec = { $: {} };
export const GraphicsTabletSettingsObserver_OnGraphicsTabletListUpdated_ParamsSpec = { $: {} };
export const KeyboardBrightnessObserver_OnKeyboardBrightnessChanged_ParamsSpec = { $: {} };
export const KeyboardAmbientLightSensorObserver_OnKeyboardAmbientLightSensorEnabledChanged_ParamsSpec = { $: {} };
export const LidStateObserver_OnLidStateChanged_ParamsSpec = { $: {} };
export const InputDeviceSettingsProvider_ObserveKeyboardSettings_ParamsSpec = { $: {} };
export const InputDeviceSettingsProvider_ObserveTouchpadSettings_ParamsSpec = { $: {} };
export const InputDeviceSettingsProvider_ObservePointingStickSettings_ParamsSpec = { $: {} };
export const InputDeviceSettingsProvider_ObserveMouseSettings_ParamsSpec = { $: {} };
export const InputDeviceSettingsProvider_ObserveGraphicsTabletSettings_ParamsSpec = { $: {} };
export const InputDeviceSettingsProvider_ObserveButtonPresses_ParamsSpec = { $: {} };
export const InputDeviceSettingsProvider_ObserveKeyboardBrightness_ParamsSpec = { $: {} };
export const InputDeviceSettingsProvider_ObserveKeyboardAmbientLightSensor_ParamsSpec = { $: {} };
export const InputDeviceSettingsProvider_ObserveLidState_ParamsSpec = { $: {} };
export const InputDeviceSettingsProvider_ObserveLidState_ResponseParamsSpec = { $: {} };
export const InputDeviceSettingsProvider_RestoreDefaultKeyboardRemappings_ParamsSpec = { $: {} };
export const InputDeviceSettingsProvider_SetKeyboardSettings_ParamsSpec = { $: {} };
export const InputDeviceSettingsProvider_SetPointingStickSettings_ParamsSpec = { $: {} };
export const InputDeviceSettingsProvider_SetMouseSettings_ParamsSpec = { $: {} };
export const InputDeviceSettingsProvider_SetTouchpadSettings_ParamsSpec = { $: {} };
export const InputDeviceSettingsProvider_SetGraphicsTabletSettings_ParamsSpec = { $: {} };
export const InputDeviceSettingsProvider_SetKeyboardBrightness_ParamsSpec = { $: {} };
export const InputDeviceSettingsProvider_SetKeyboardAmbientLightSensorEnabled_ParamsSpec = { $: {} };
export const InputDeviceSettingsProvider_StartObserving_ParamsSpec = { $: {} };
export const InputDeviceSettingsProvider_StopObserving_ParamsSpec = { $: {} };
export const InputDeviceSettingsProvider_GetActionsForMouseButtonCustomization_ParamsSpec = { $: {} };
export const InputDeviceSettingsProvider_GetActionsForMouseButtonCustomization_ResponseParamsSpec = { $: {} };
export const InputDeviceSettingsProvider_GetActionsForGraphicsTabletButtonCustomization_ParamsSpec = { $: {} };
export const InputDeviceSettingsProvider_GetActionsForGraphicsTabletButtonCustomization_ResponseParamsSpec = { $: {} };
export const InputDeviceSettingsProvider_GetMetaKeyToDisplay_ParamsSpec = { $: {} };
export const InputDeviceSettingsProvider_GetMetaKeyToDisplay_ResponseParamsSpec = { $: {} };
export const InputDeviceSettingsProvider_HasKeyboardBacklight_ParamsSpec = { $: {} };
export const InputDeviceSettingsProvider_HasKeyboardBacklight_ResponseParamsSpec = { $: {} };
export const InputDeviceSettingsProvider_HasAmbientLightSensor_ParamsSpec = { $: {} };
export const InputDeviceSettingsProvider_HasAmbientLightSensor_ResponseParamsSpec = { $: {} };
export const InputDeviceSettingsProvider_IsRgbKeyboardSupported_ParamsSpec = { $: {} };
export const InputDeviceSettingsProvider_IsRgbKeyboardSupported_ResponseParamsSpec = { $: {} };
export const InputDeviceSettingsProvider_RecordKeyboardColorLinkClicked_ParamsSpec = { $: {} };
export const InputDeviceSettingsProvider_RecordKeyboardBrightnessChangeFromSlider_ParamsSpec = { $: {} };
export const InputDeviceSettingsProvider_GetDeviceIconImage_ParamsSpec = { $: {} };
export const InputDeviceSettingsProvider_GetDeviceIconImage_ResponseParamsSpec = { $: {} };
export const InputDeviceSettingsProvider_LaunchCompanionApp_ParamsSpec = { $: {} };
export const ActionTypeSpec = { $: {} };
mojo.internal.Struct(ActionChoiceSpec.$, 'ActionChoice', [
    mojo.internal.StructField('actionType', 0, 0, ActionTypeSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('name', 16, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 32],]);
mojo.internal.Struct(KeyboardSettingsObserver_OnKeyboardListUpdated_ParamsSpec.$, 'KeyboardSettingsObserver_OnKeyboardListUpdated_Params', [
    mojo.internal.StructField('keyboards', 0, 0, mojo.internal.Array(ash_mojom_KeyboardSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(KeyboardSettingsObserver_OnKeyboardPoliciesUpdated_ParamsSpec.$, 'KeyboardSettingsObserver_OnKeyboardPoliciesUpdated_Params', [
    mojo.internal.StructField('policies', 0, 0, ash_mojom_KeyboardPoliciesSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(TouchpadSettingsObserver_OnTouchpadListUpdated_ParamsSpec.$, 'TouchpadSettingsObserver_OnTouchpadListUpdated_Params', [
    mojo.internal.StructField('touchpads', 0, 0, mojo.internal.Array(ash_mojom_TouchpadSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PointingStickSettingsObserver_OnPointingStickListUpdated_ParamsSpec.$, 'PointingStickSettingsObserver_OnPointingStickListUpdated_Params', [
    mojo.internal.StructField('pointSticks', 0, 0, mojo.internal.Array(ash_mojom_PointingStickSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(MouseSettingsObserver_OnMouseListUpdated_ParamsSpec.$, 'MouseSettingsObserver_OnMouseListUpdated_Params', [
    mojo.internal.StructField('mice', 0, 0, mojo.internal.Array(ash_mojom_MouseSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(MouseSettingsObserver_OnMousePoliciesUpdated_ParamsSpec.$, 'MouseSettingsObserver_OnMousePoliciesUpdated_Params', [
    mojo.internal.StructField('policies', 0, 0, ash_mojom_MousePoliciesSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(ButtonPressObserver_OnButtonPressed_ParamsSpec.$, 'ButtonPressObserver_OnButtonPressed_Params', [
    mojo.internal.StructField('button', 0, 0, ash_mojom_ButtonSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(GraphicsTabletSettingsObserver_OnGraphicsTabletListUpdated_ParamsSpec.$, 'GraphicsTabletSettingsObserver_OnGraphicsTabletListUpdated_Params', [
    mojo.internal.StructField('graphicsTablets', 0, 0, mojo.internal.Array(ash_mojom_GraphicsTabletSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(KeyboardBrightnessObserver_OnKeyboardBrightnessChanged_ParamsSpec.$, 'KeyboardBrightnessObserver_OnKeyboardBrightnessChanged_Params', [
    mojo.internal.StructField('brightnessPercent', 0, 0, mojo.internal.Double, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(KeyboardAmbientLightSensorObserver_OnKeyboardAmbientLightSensorEnabledChanged_ParamsSpec.$, 'KeyboardAmbientLightSensorObserver_OnKeyboardAmbientLightSensorEnabledChanged_Params', [
    mojo.internal.StructField('keyboardAmbientLightSensorEnabled', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(LidStateObserver_OnLidStateChanged_ParamsSpec.$, 'LidStateObserver_OnLidStateChanged_Params', [
    mojo.internal.StructField('isLidOpen', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(InputDeviceSettingsProvider_ObserveKeyboardSettings_ParamsSpec.$, 'InputDeviceSettingsProvider_ObserveKeyboardSettings_Params', [
    mojo.internal.StructField('observer', 0, 0, mojo.internal.InterfaceProxy(KeyboardSettingsObserverRemote), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(InputDeviceSettingsProvider_ObserveTouchpadSettings_ParamsSpec.$, 'InputDeviceSettingsProvider_ObserveTouchpadSettings_Params', [
    mojo.internal.StructField('observer', 0, 0, mojo.internal.InterfaceProxy(TouchpadSettingsObserverRemote), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(InputDeviceSettingsProvider_ObservePointingStickSettings_ParamsSpec.$, 'InputDeviceSettingsProvider_ObservePointingStickSettings_Params', [
    mojo.internal.StructField('observer', 0, 0, mojo.internal.InterfaceProxy(PointingStickSettingsObserverRemote), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(InputDeviceSettingsProvider_ObserveMouseSettings_ParamsSpec.$, 'InputDeviceSettingsProvider_ObserveMouseSettings_Params', [
    mojo.internal.StructField('observer', 0, 0, mojo.internal.InterfaceProxy(MouseSettingsObserverRemote), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(InputDeviceSettingsProvider_ObserveGraphicsTabletSettings_ParamsSpec.$, 'InputDeviceSettingsProvider_ObserveGraphicsTabletSettings_Params', [
    mojo.internal.StructField('observer', 0, 0, mojo.internal.InterfaceProxy(GraphicsTabletSettingsObserverRemote), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(InputDeviceSettingsProvider_ObserveButtonPresses_ParamsSpec.$, 'InputDeviceSettingsProvider_ObserveButtonPresses_Params', [
    mojo.internal.StructField('observer', 0, 0, mojo.internal.InterfaceProxy(ButtonPressObserverRemote), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(InputDeviceSettingsProvider_ObserveKeyboardBrightness_ParamsSpec.$, 'InputDeviceSettingsProvider_ObserveKeyboardBrightness_Params', [
    mojo.internal.StructField('observer', 0, 0, mojo.internal.InterfaceProxy(KeyboardBrightnessObserverRemote), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(InputDeviceSettingsProvider_ObserveKeyboardAmbientLightSensor_ParamsSpec.$, 'InputDeviceSettingsProvider_ObserveKeyboardAmbientLightSensor_Params', [
    mojo.internal.StructField('observer', 0, 0, mojo.internal.InterfaceProxy(KeyboardAmbientLightSensorObserverRemote), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(InputDeviceSettingsProvider_ObserveLidState_ParamsSpec.$, 'InputDeviceSettingsProvider_ObserveLidState_Params', [
    mojo.internal.StructField('observer', 0, 0, mojo.internal.InterfaceProxy(LidStateObserverRemote), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(InputDeviceSettingsProvider_ObserveLidState_ResponseParamsSpec.$, 'InputDeviceSettingsProvider_ObserveLidState_ResponseParams', [
    mojo.internal.StructField('isLidOpen', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(InputDeviceSettingsProvider_RestoreDefaultKeyboardRemappings_ParamsSpec.$, 'InputDeviceSettingsProvider_RestoreDefaultKeyboardRemappings_Params', [
    mojo.internal.StructField('deviceId', 0, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(InputDeviceSettingsProvider_SetKeyboardSettings_ParamsSpec.$, 'InputDeviceSettingsProvider_SetKeyboardSettings_Params', [
    mojo.internal.StructField('deviceId', 0, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('settings', 8, 0, ash_mojom_KeyboardSettingsSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(InputDeviceSettingsProvider_SetPointingStickSettings_ParamsSpec.$, 'InputDeviceSettingsProvider_SetPointingStickSettings_Params', [
    mojo.internal.StructField('deviceId', 0, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('settings', 8, 0, ash_mojom_PointingStickSettingsSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(InputDeviceSettingsProvider_SetMouseSettings_ParamsSpec.$, 'InputDeviceSettingsProvider_SetMouseSettings_Params', [
    mojo.internal.StructField('deviceId', 0, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('settings', 8, 0, ash_mojom_MouseSettingsSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(InputDeviceSettingsProvider_SetTouchpadSettings_ParamsSpec.$, 'InputDeviceSettingsProvider_SetTouchpadSettings_Params', [
    mojo.internal.StructField('deviceId', 0, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('settings', 8, 0, ash_mojom_TouchpadSettingsSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(InputDeviceSettingsProvider_SetGraphicsTabletSettings_ParamsSpec.$, 'InputDeviceSettingsProvider_SetGraphicsTabletSettings_Params', [
    mojo.internal.StructField('deviceId', 0, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('settings', 8, 0, ash_mojom_GraphicsTabletSettingsSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(InputDeviceSettingsProvider_SetKeyboardBrightness_ParamsSpec.$, 'InputDeviceSettingsProvider_SetKeyboardBrightness_Params', [
    mojo.internal.StructField('percent', 0, 0, mojo.internal.Double, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(InputDeviceSettingsProvider_SetKeyboardAmbientLightSensorEnabled_ParamsSpec.$, 'InputDeviceSettingsProvider_SetKeyboardAmbientLightSensorEnabled_Params', [
    mojo.internal.StructField('enabled', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(InputDeviceSettingsProvider_StartObserving_ParamsSpec.$, 'InputDeviceSettingsProvider_StartObserving_Params', [
    mojo.internal.StructField('deviceId', 0, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(InputDeviceSettingsProvider_StopObserving_ParamsSpec.$, 'InputDeviceSettingsProvider_StopObserving_Params', [], [[0, 8],]);
mojo.internal.Struct(InputDeviceSettingsProvider_GetActionsForMouseButtonCustomization_ParamsSpec.$, 'InputDeviceSettingsProvider_GetActionsForMouseButtonCustomization_Params', [], [[0, 8],]);
mojo.internal.Struct(InputDeviceSettingsProvider_GetActionsForMouseButtonCustomization_ResponseParamsSpec.$, 'InputDeviceSettingsProvider_GetActionsForMouseButtonCustomization_ResponseParams', [
    mojo.internal.StructField('options', 0, 0, mojo.internal.Array(ActionChoiceSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(InputDeviceSettingsProvider_GetActionsForGraphicsTabletButtonCustomization_ParamsSpec.$, 'InputDeviceSettingsProvider_GetActionsForGraphicsTabletButtonCustomization_Params', [], [[0, 8],]);
mojo.internal.Struct(InputDeviceSettingsProvider_GetActionsForGraphicsTabletButtonCustomization_ResponseParamsSpec.$, 'InputDeviceSettingsProvider_GetActionsForGraphicsTabletButtonCustomization_ResponseParams', [
    mojo.internal.StructField('options', 0, 0, mojo.internal.Array(ActionChoiceSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(InputDeviceSettingsProvider_GetMetaKeyToDisplay_ParamsSpec.$, 'InputDeviceSettingsProvider_GetMetaKeyToDisplay_Params', [], [[0, 8],]);
mojo.internal.Struct(InputDeviceSettingsProvider_GetMetaKeyToDisplay_ResponseParamsSpec.$, 'InputDeviceSettingsProvider_GetMetaKeyToDisplay_ResponseParams', [
    mojo.internal.StructField('metaKey', 0, 0, ui_mojom_MetaKeySpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(InputDeviceSettingsProvider_HasKeyboardBacklight_ParamsSpec.$, 'InputDeviceSettingsProvider_HasKeyboardBacklight_Params', [], [[0, 8],]);
mojo.internal.Struct(InputDeviceSettingsProvider_HasKeyboardBacklight_ResponseParamsSpec.$, 'InputDeviceSettingsProvider_HasKeyboardBacklight_ResponseParams', [
    mojo.internal.StructField('hasKeyboardBacklight', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(InputDeviceSettingsProvider_HasAmbientLightSensor_ParamsSpec.$, 'InputDeviceSettingsProvider_HasAmbientLightSensor_Params', [], [[0, 8],]);
mojo.internal.Struct(InputDeviceSettingsProvider_HasAmbientLightSensor_ResponseParamsSpec.$, 'InputDeviceSettingsProvider_HasAmbientLightSensor_ResponseParams', [
    mojo.internal.StructField('hasAmbientLightSensor', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(InputDeviceSettingsProvider_IsRgbKeyboardSupported_ParamsSpec.$, 'InputDeviceSettingsProvider_IsRgbKeyboardSupported_Params', [], [[0, 8],]);
mojo.internal.Struct(InputDeviceSettingsProvider_IsRgbKeyboardSupported_ResponseParamsSpec.$, 'InputDeviceSettingsProvider_IsRgbKeyboardSupported_ResponseParams', [
    mojo.internal.StructField('isRgbKeyboardSupported', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(InputDeviceSettingsProvider_RecordKeyboardColorLinkClicked_ParamsSpec.$, 'InputDeviceSettingsProvider_RecordKeyboardColorLinkClicked_Params', [], [[0, 8],]);
mojo.internal.Struct(InputDeviceSettingsProvider_RecordKeyboardBrightnessChangeFromSlider_ParamsSpec.$, 'InputDeviceSettingsProvider_RecordKeyboardBrightnessChangeFromSlider_Params', [
    mojo.internal.StructField('percent', 0, 0, mojo.internal.Double, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(InputDeviceSettingsProvider_GetDeviceIconImage_ParamsSpec.$, 'InputDeviceSettingsProvider_GetDeviceIconImage_Params', [
    mojo.internal.StructField('deviceKey', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(InputDeviceSettingsProvider_GetDeviceIconImage_ResponseParamsSpec.$, 'InputDeviceSettingsProvider_GetDeviceIconImage_ResponseParams', [
    mojo.internal.StructField('dataUrl', 0, 0, mojo.internal.String, null, true /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(InputDeviceSettingsProvider_LaunchCompanionApp_ParamsSpec.$, 'InputDeviceSettingsProvider_LaunchCompanionApp_Params', [
    mojo.internal.StructField('packageId', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Union(ActionTypeSpec.$, 'ActionType', {
    'acceleratorAction': {
        'ordinal': 0,
        'type': ash_mojom_AcceleratorActionSpec.$,
    },
    'staticShortcutAction': {
        'ordinal': 1,
        'type': ash_mojom_StaticShortcutActionSpec.$,
    },
});
export var ActionTypeFieldTags;
(function (ActionTypeFieldTags) {
    ActionTypeFieldTags[ActionTypeFieldTags["ACCELERATOR_ACTION"] = 0] = "ACCELERATOR_ACTION";
    ActionTypeFieldTags[ActionTypeFieldTags["STATIC_SHORTCUT_ACTION"] = 1] = "STATIC_SHORTCUT_ACTION";
})(ActionTypeFieldTags || (ActionTypeFieldTags = {}));
export function whichActionType(u) {
    if (u.acceleratorAction !== null && u.acceleratorAction !== undefined) {
        return ActionTypeFieldTags.ACCELERATOR_ACTION;
    }
    if (u.staticShortcutAction !== null && u.staticShortcutAction !== undefined) {
        return ActionTypeFieldTags.STATIC_SHORTCUT_ACTION;
    }
    throw new Error("no union field has been set, this is an illegal state");
}
