// chromeos/ash/services/ime/public/mojom/input_method_user_data.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { mojo } from '//resources/mojo/mojo/public/js/bindings.js';
import { JapaneseDictionarySpec as ash_ime_mojom_JapaneseDictionarySpec, JapaneseDictionaryEntrySpec as ash_ime_mojom_JapaneseDictionaryEntrySpec } from './user_data_japanese_dictionary.mojom-webui.js';
import { JapaneseLegacyConfigSpec as ash_ime_mojom_JapaneseLegacyConfigSpec } from './user_data_japanese_legacy_config.mojom-webui.js';
import { BigStringSpec as mojoBase_mojom_BigStringSpec } from '//resources/mojo/mojo/public/mojom/base/big_string.mojom-webui.js';
export class InputMethodUserDataServicePendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.ime.mojom.InputMethodUserDataService', scope);
    }
}
export class InputMethodUserDataServiceRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(InputMethodUserDataServicePendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    fetchJapaneseLegacyConfig() {
        return this.proxy.sendMessage(0, InputMethodUserDataService_FetchJapaneseLegacyConfig_ParamsSpec.$, InputMethodUserDataService_FetchJapaneseLegacyConfig_ResponseParamsSpec.$, [], false);
    }
    fetchJapaneseDictionary() {
        return this.proxy.sendMessage(1, InputMethodUserDataService_FetchJapaneseDictionary_ParamsSpec.$, InputMethodUserDataService_FetchJapaneseDictionary_ResponseParamsSpec.$, [], false);
    }
    addJapaneseDictionaryEntry(dictId, entry) {
        return this.proxy.sendMessage(2, InputMethodUserDataService_AddJapaneseDictionaryEntry_ParamsSpec.$, InputMethodUserDataService_AddJapaneseDictionaryEntry_ResponseParamsSpec.$, [
            dictId,
            entry
        ], false);
    }
    editJapaneseDictionaryEntry(dictId, entryIndex, entry) {
        return this.proxy.sendMessage(3, InputMethodUserDataService_EditJapaneseDictionaryEntry_ParamsSpec.$, InputMethodUserDataService_EditJapaneseDictionaryEntry_ResponseParamsSpec.$, [
            dictId,
            entryIndex,
            entry
        ], false);
    }
    deleteJapaneseDictionaryEntry(dictId, entryIndex) {
        return this.proxy.sendMessage(4, InputMethodUserDataService_DeleteJapaneseDictionaryEntry_ParamsSpec.$, InputMethodUserDataService_DeleteJapaneseDictionaryEntry_ResponseParamsSpec.$, [
            dictId,
            entryIndex
        ], false);
    }
    createJapaneseDictionary(dictionaryName) {
        return this.proxy.sendMessage(5, InputMethodUserDataService_CreateJapaneseDictionary_ParamsSpec.$, InputMethodUserDataService_CreateJapaneseDictionary_ResponseParamsSpec.$, [
            dictionaryName
        ], false);
    }
    renameJapaneseDictionary(dictId, dictionaryName) {
        return this.proxy.sendMessage(6, InputMethodUserDataService_RenameJapaneseDictionary_ParamsSpec.$, InputMethodUserDataService_RenameJapaneseDictionary_ResponseParamsSpec.$, [
            dictId,
            dictionaryName
        ], false);
    }
    deleteJapaneseDictionary(dictId) {
        return this.proxy.sendMessage(7, InputMethodUserDataService_DeleteJapaneseDictionary_ParamsSpec.$, InputMethodUserDataService_DeleteJapaneseDictionary_ResponseParamsSpec.$, [
            dictId
        ], false);
    }
    exportJapaneseDictionary(dictId) {
        return this.proxy.sendMessage(8, InputMethodUserDataService_ExportJapaneseDictionary_ParamsSpec.$, InputMethodUserDataService_ExportJapaneseDictionary_ResponseParamsSpec.$, [
            dictId
        ], false);
    }
    importJapaneseDictionary(dictId, tsvData) {
        return this.proxy.sendMessage(9, InputMethodUserDataService_ImportJapaneseDictionary_ParamsSpec.$, InputMethodUserDataService_ImportJapaneseDictionary_ResponseParamsSpec.$, [
            dictId,
            tsvData
        ], false);
    }
    clearJapanesePersonalizationData(clearConversionHistory, clearSuggestionHistory) {
        return this.proxy.sendMessage(10, InputMethodUserDataService_ClearJapanesePersonalizationData_ParamsSpec.$, InputMethodUserDataService_ClearJapanesePersonalizationData_ResponseParamsSpec.$, [
            clearConversionHistory,
            clearSuggestionHistory
        ], false);
    }
}
;
/**
 * An object which receives request messages for the InputMethodUserDataService
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class InputMethodUserDataServiceReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(InputMethodUserDataServiceRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, InputMethodUserDataService_FetchJapaneseLegacyConfig_ParamsSpec.$, InputMethodUserDataService_FetchJapaneseLegacyConfig_ResponseParamsSpec.$, impl.fetchJapaneseLegacyConfig.bind(impl), false);
        this.helper_internal_.registerHandler(1, InputMethodUserDataService_FetchJapaneseDictionary_ParamsSpec.$, InputMethodUserDataService_FetchJapaneseDictionary_ResponseParamsSpec.$, impl.fetchJapaneseDictionary.bind(impl), false);
        this.helper_internal_.registerHandler(2, InputMethodUserDataService_AddJapaneseDictionaryEntry_ParamsSpec.$, InputMethodUserDataService_AddJapaneseDictionaryEntry_ResponseParamsSpec.$, impl.addJapaneseDictionaryEntry.bind(impl), false);
        this.helper_internal_.registerHandler(3, InputMethodUserDataService_EditJapaneseDictionaryEntry_ParamsSpec.$, InputMethodUserDataService_EditJapaneseDictionaryEntry_ResponseParamsSpec.$, impl.editJapaneseDictionaryEntry.bind(impl), false);
        this.helper_internal_.registerHandler(4, InputMethodUserDataService_DeleteJapaneseDictionaryEntry_ParamsSpec.$, InputMethodUserDataService_DeleteJapaneseDictionaryEntry_ResponseParamsSpec.$, impl.deleteJapaneseDictionaryEntry.bind(impl), false);
        this.helper_internal_.registerHandler(5, InputMethodUserDataService_CreateJapaneseDictionary_ParamsSpec.$, InputMethodUserDataService_CreateJapaneseDictionary_ResponseParamsSpec.$, impl.createJapaneseDictionary.bind(impl), false);
        this.helper_internal_.registerHandler(6, InputMethodUserDataService_RenameJapaneseDictionary_ParamsSpec.$, InputMethodUserDataService_RenameJapaneseDictionary_ResponseParamsSpec.$, impl.renameJapaneseDictionary.bind(impl), false);
        this.helper_internal_.registerHandler(7, InputMethodUserDataService_DeleteJapaneseDictionary_ParamsSpec.$, InputMethodUserDataService_DeleteJapaneseDictionary_ResponseParamsSpec.$, impl.deleteJapaneseDictionary.bind(impl), false);
        this.helper_internal_.registerHandler(8, InputMethodUserDataService_ExportJapaneseDictionary_ParamsSpec.$, InputMethodUserDataService_ExportJapaneseDictionary_ResponseParamsSpec.$, impl.exportJapaneseDictionary.bind(impl), false);
        this.helper_internal_.registerHandler(9, InputMethodUserDataService_ImportJapaneseDictionary_ParamsSpec.$, InputMethodUserDataService_ImportJapaneseDictionary_ResponseParamsSpec.$, impl.importJapaneseDictionary.bind(impl), false);
        this.helper_internal_.registerHandler(10, InputMethodUserDataService_ClearJapanesePersonalizationData_ParamsSpec.$, InputMethodUserDataService_ClearJapanesePersonalizationData_ResponseParamsSpec.$, impl.clearJapanesePersonalizationData.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class InputMethodUserDataService {
    static get $interfaceName() {
        return "ash.ime.mojom.InputMethodUserDataService";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new InputMethodUserDataServiceRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the InputMethodUserDataService
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class InputMethodUserDataServiceCallbackRouter {
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(InputMethodUserDataServiceRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.fetchJapaneseLegacyConfig =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, InputMethodUserDataService_FetchJapaneseLegacyConfig_ParamsSpec.$, InputMethodUserDataService_FetchJapaneseLegacyConfig_ResponseParamsSpec.$, this.fetchJapaneseLegacyConfig.createReceiverHandler(true /* expectsResponse */), false);
        this.fetchJapaneseDictionary =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, InputMethodUserDataService_FetchJapaneseDictionary_ParamsSpec.$, InputMethodUserDataService_FetchJapaneseDictionary_ResponseParamsSpec.$, this.fetchJapaneseDictionary.createReceiverHandler(true /* expectsResponse */), false);
        this.addJapaneseDictionaryEntry =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, InputMethodUserDataService_AddJapaneseDictionaryEntry_ParamsSpec.$, InputMethodUserDataService_AddJapaneseDictionaryEntry_ResponseParamsSpec.$, this.addJapaneseDictionaryEntry.createReceiverHandler(true /* expectsResponse */), false);
        this.editJapaneseDictionaryEntry =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(3, InputMethodUserDataService_EditJapaneseDictionaryEntry_ParamsSpec.$, InputMethodUserDataService_EditJapaneseDictionaryEntry_ResponseParamsSpec.$, this.editJapaneseDictionaryEntry.createReceiverHandler(true /* expectsResponse */), false);
        this.deleteJapaneseDictionaryEntry =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(4, InputMethodUserDataService_DeleteJapaneseDictionaryEntry_ParamsSpec.$, InputMethodUserDataService_DeleteJapaneseDictionaryEntry_ResponseParamsSpec.$, this.deleteJapaneseDictionaryEntry.createReceiverHandler(true /* expectsResponse */), false);
        this.createJapaneseDictionary =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(5, InputMethodUserDataService_CreateJapaneseDictionary_ParamsSpec.$, InputMethodUserDataService_CreateJapaneseDictionary_ResponseParamsSpec.$, this.createJapaneseDictionary.createReceiverHandler(true /* expectsResponse */), false);
        this.renameJapaneseDictionary =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(6, InputMethodUserDataService_RenameJapaneseDictionary_ParamsSpec.$, InputMethodUserDataService_RenameJapaneseDictionary_ResponseParamsSpec.$, this.renameJapaneseDictionary.createReceiverHandler(true /* expectsResponse */), false);
        this.deleteJapaneseDictionary =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(7, InputMethodUserDataService_DeleteJapaneseDictionary_ParamsSpec.$, InputMethodUserDataService_DeleteJapaneseDictionary_ResponseParamsSpec.$, this.deleteJapaneseDictionary.createReceiverHandler(true /* expectsResponse */), false);
        this.exportJapaneseDictionary =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(8, InputMethodUserDataService_ExportJapaneseDictionary_ParamsSpec.$, InputMethodUserDataService_ExportJapaneseDictionary_ResponseParamsSpec.$, this.exportJapaneseDictionary.createReceiverHandler(true /* expectsResponse */), false);
        this.importJapaneseDictionary =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(9, InputMethodUserDataService_ImportJapaneseDictionary_ParamsSpec.$, InputMethodUserDataService_ImportJapaneseDictionary_ResponseParamsSpec.$, this.importJapaneseDictionary.createReceiverHandler(true /* expectsResponse */), false);
        this.clearJapanesePersonalizationData =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(10, InputMethodUserDataService_ClearJapanesePersonalizationData_ParamsSpec.$, InputMethodUserDataService_ClearJapanesePersonalizationData_ResponseParamsSpec.$, this.clearJapanesePersonalizationData.createReceiverHandler(true /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export const StatusSpec = { $: {} };
export const InputMethodUserDataService_FetchJapaneseLegacyConfig_ParamsSpec = { $: {} };
export const InputMethodUserDataService_FetchJapaneseLegacyConfig_ResponseParamsSpec = { $: {} };
export const InputMethodUserDataService_FetchJapaneseDictionary_ParamsSpec = { $: {} };
export const InputMethodUserDataService_FetchJapaneseDictionary_ResponseParamsSpec = { $: {} };
export const InputMethodUserDataService_AddJapaneseDictionaryEntry_ParamsSpec = { $: {} };
export const InputMethodUserDataService_AddJapaneseDictionaryEntry_ResponseParamsSpec = { $: {} };
export const InputMethodUserDataService_EditJapaneseDictionaryEntry_ParamsSpec = { $: {} };
export const InputMethodUserDataService_EditJapaneseDictionaryEntry_ResponseParamsSpec = { $: {} };
export const InputMethodUserDataService_DeleteJapaneseDictionaryEntry_ParamsSpec = { $: {} };
export const InputMethodUserDataService_DeleteJapaneseDictionaryEntry_ResponseParamsSpec = { $: {} };
export const InputMethodUserDataService_CreateJapaneseDictionary_ParamsSpec = { $: {} };
export const InputMethodUserDataService_CreateJapaneseDictionary_ResponseParamsSpec = { $: {} };
export const InputMethodUserDataService_RenameJapaneseDictionary_ParamsSpec = { $: {} };
export const InputMethodUserDataService_RenameJapaneseDictionary_ResponseParamsSpec = { $: {} };
export const InputMethodUserDataService_DeleteJapaneseDictionary_ParamsSpec = { $: {} };
export const InputMethodUserDataService_DeleteJapaneseDictionary_ResponseParamsSpec = { $: {} };
export const InputMethodUserDataService_ExportJapaneseDictionary_ParamsSpec = { $: {} };
export const InputMethodUserDataService_ExportJapaneseDictionary_ResponseParamsSpec = { $: {} };
export const InputMethodUserDataService_ImportJapaneseDictionary_ParamsSpec = { $: {} };
export const InputMethodUserDataService_ImportJapaneseDictionary_ResponseParamsSpec = { $: {} };
export const InputMethodUserDataService_ClearJapanesePersonalizationData_ParamsSpec = { $: {} };
export const InputMethodUserDataService_ClearJapanesePersonalizationData_ResponseParamsSpec = { $: {} };
export const JapaneseLegacyConfigResponseSpec = { $: {} };
export const JapaneseDictionaryResponseSpec = { $: {} };
mojo.internal.Struct(StatusSpec.$, 'Status', [
    mojo.internal.StructField('success', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('reason', 8, 0, mojo.internal.String, null, true /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(InputMethodUserDataService_FetchJapaneseLegacyConfig_ParamsSpec.$, 'InputMethodUserDataService_FetchJapaneseLegacyConfig_Params', [], [[0, 8],]);
mojo.internal.Struct(InputMethodUserDataService_FetchJapaneseLegacyConfig_ResponseParamsSpec.$, 'InputMethodUserDataService_FetchJapaneseLegacyConfig_ResponseParams', [
    mojo.internal.StructField('response', 0, 0, JapaneseLegacyConfigResponseSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(InputMethodUserDataService_FetchJapaneseDictionary_ParamsSpec.$, 'InputMethodUserDataService_FetchJapaneseDictionary_Params', [], [[0, 8],]);
mojo.internal.Struct(InputMethodUserDataService_FetchJapaneseDictionary_ResponseParamsSpec.$, 'InputMethodUserDataService_FetchJapaneseDictionary_ResponseParams', [
    mojo.internal.StructField('response', 0, 0, JapaneseDictionaryResponseSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(InputMethodUserDataService_AddJapaneseDictionaryEntry_ParamsSpec.$, 'InputMethodUserDataService_AddJapaneseDictionaryEntry_Params', [
    mojo.internal.StructField('dictId', 0, 0, mojo.internal.Uint64, BigInt(0), false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('entry', 8, 0, ash_ime_mojom_JapaneseDictionaryEntrySpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(InputMethodUserDataService_AddJapaneseDictionaryEntry_ResponseParamsSpec.$, 'InputMethodUserDataService_AddJapaneseDictionaryEntry_ResponseParams', [
    mojo.internal.StructField('status', 0, 0, StatusSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(InputMethodUserDataService_EditJapaneseDictionaryEntry_ParamsSpec.$, 'InputMethodUserDataService_EditJapaneseDictionaryEntry_Params', [
    mojo.internal.StructField('dictId', 0, 0, mojo.internal.Uint64, BigInt(0), false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('entryIndex', 8, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('entry', 16, 0, ash_ime_mojom_JapaneseDictionaryEntrySpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 32],]);
mojo.internal.Struct(InputMethodUserDataService_EditJapaneseDictionaryEntry_ResponseParamsSpec.$, 'InputMethodUserDataService_EditJapaneseDictionaryEntry_ResponseParams', [
    mojo.internal.StructField('status', 0, 0, StatusSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(InputMethodUserDataService_DeleteJapaneseDictionaryEntry_ParamsSpec.$, 'InputMethodUserDataService_DeleteJapaneseDictionaryEntry_Params', [
    mojo.internal.StructField('dictId', 0, 0, mojo.internal.Uint64, BigInt(0), false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('entryIndex', 8, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(InputMethodUserDataService_DeleteJapaneseDictionaryEntry_ResponseParamsSpec.$, 'InputMethodUserDataService_DeleteJapaneseDictionaryEntry_ResponseParams', [
    mojo.internal.StructField('status', 0, 0, StatusSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(InputMethodUserDataService_CreateJapaneseDictionary_ParamsSpec.$, 'InputMethodUserDataService_CreateJapaneseDictionary_Params', [
    mojo.internal.StructField('dictionaryName', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(InputMethodUserDataService_CreateJapaneseDictionary_ResponseParamsSpec.$, 'InputMethodUserDataService_CreateJapaneseDictionary_ResponseParams', [
    mojo.internal.StructField('status', 0, 0, StatusSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(InputMethodUserDataService_RenameJapaneseDictionary_ParamsSpec.$, 'InputMethodUserDataService_RenameJapaneseDictionary_Params', [
    mojo.internal.StructField('dictId', 0, 0, mojo.internal.Uint64, BigInt(0), false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('dictionaryName', 8, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(InputMethodUserDataService_RenameJapaneseDictionary_ResponseParamsSpec.$, 'InputMethodUserDataService_RenameJapaneseDictionary_ResponseParams', [
    mojo.internal.StructField('status', 0, 0, StatusSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(InputMethodUserDataService_DeleteJapaneseDictionary_ParamsSpec.$, 'InputMethodUserDataService_DeleteJapaneseDictionary_Params', [
    mojo.internal.StructField('dictId', 0, 0, mojo.internal.Uint64, BigInt(0), false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(InputMethodUserDataService_DeleteJapaneseDictionary_ResponseParamsSpec.$, 'InputMethodUserDataService_DeleteJapaneseDictionary_ResponseParams', [
    mojo.internal.StructField('status', 0, 0, StatusSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(InputMethodUserDataService_ExportJapaneseDictionary_ParamsSpec.$, 'InputMethodUserDataService_ExportJapaneseDictionary_Params', [
    mojo.internal.StructField('dictId', 0, 0, mojo.internal.Uint64, BigInt(0), false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(InputMethodUserDataService_ExportJapaneseDictionary_ResponseParamsSpec.$, 'InputMethodUserDataService_ExportJapaneseDictionary_ResponseParams', [
    mojo.internal.StructField('result', 0, 0, mojoBase_mojom_BigStringSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(InputMethodUserDataService_ImportJapaneseDictionary_ParamsSpec.$, 'InputMethodUserDataService_ImportJapaneseDictionary_Params', [
    mojo.internal.StructField('dictId', 0, 0, mojo.internal.Uint64, BigInt(0), false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('tsvData', 8, 0, mojoBase_mojom_BigStringSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(InputMethodUserDataService_ImportJapaneseDictionary_ResponseParamsSpec.$, 'InputMethodUserDataService_ImportJapaneseDictionary_ResponseParams', [
    mojo.internal.StructField('status', 0, 0, StatusSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(InputMethodUserDataService_ClearJapanesePersonalizationData_ParamsSpec.$, 'InputMethodUserDataService_ClearJapanesePersonalizationData_Params', [
    mojo.internal.StructField('clearConversionHistory', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('clearSuggestionHistory', 0, 1, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(InputMethodUserDataService_ClearJapanesePersonalizationData_ResponseParamsSpec.$, 'InputMethodUserDataService_ClearJapanesePersonalizationData_ResponseParams', [
    mojo.internal.StructField('status', 0, 0, StatusSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Union(JapaneseLegacyConfigResponseSpec.$, 'JapaneseLegacyConfigResponse', {
    'errorReason': {
        'ordinal': 0,
        'type': mojo.internal.String,
    },
    'response': {
        'ordinal': 1,
        'type': ash_ime_mojom_JapaneseLegacyConfigSpec.$,
    },
});
export var JapaneseLegacyConfigResponseFieldTags;
(function (JapaneseLegacyConfigResponseFieldTags) {
    JapaneseLegacyConfigResponseFieldTags[JapaneseLegacyConfigResponseFieldTags["ERROR_REASON"] = 0] = "ERROR_REASON";
    JapaneseLegacyConfigResponseFieldTags[JapaneseLegacyConfigResponseFieldTags["RESPONSE"] = 1] = "RESPONSE";
})(JapaneseLegacyConfigResponseFieldTags || (JapaneseLegacyConfigResponseFieldTags = {}));
export function whichJapaneseLegacyConfigResponse(u) {
    if (u.errorReason !== null && u.errorReason !== undefined) {
        return JapaneseLegacyConfigResponseFieldTags.ERROR_REASON;
    }
    if (u.response !== null && u.response !== undefined) {
        return JapaneseLegacyConfigResponseFieldTags.RESPONSE;
    }
    throw new Error("no union field has been set, this is an illegal state");
}
mojo.internal.Union(JapaneseDictionaryResponseSpec.$, 'JapaneseDictionaryResponse', {
    'errorReason': {
        'ordinal': 0,
        'type': mojo.internal.String,
    },
    'dictionaries': {
        'ordinal': 1,
        'type': mojo.internal.Array(ash_ime_mojom_JapaneseDictionarySpec.$, false),
    },
});
export var JapaneseDictionaryResponseFieldTags;
(function (JapaneseDictionaryResponseFieldTags) {
    JapaneseDictionaryResponseFieldTags[JapaneseDictionaryResponseFieldTags["ERROR_REASON"] = 0] = "ERROR_REASON";
    JapaneseDictionaryResponseFieldTags[JapaneseDictionaryResponseFieldTags["DICTIONARIES"] = 1] = "DICTIONARIES";
})(JapaneseDictionaryResponseFieldTags || (JapaneseDictionaryResponseFieldTags = {}));
export function whichJapaneseDictionaryResponse(u) {
    if (u.errorReason !== null && u.errorReason !== undefined) {
        return JapaneseDictionaryResponseFieldTags.ERROR_REASON;
    }
    if (u.dictionaries !== null && u.dictionaries !== undefined) {
        return JapaneseDictionaryResponseFieldTags.DICTIONARIES;
    }
    throw new Error("no union field has been set, this is an illegal state");
}
